/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
 
 http://www.cocos2d-x.org
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

#include <iostream>
#include "HelloWorldScene.h"
#include "SimpleAudioEngine.h"
#include "../cocos2d/cocos/deprecated/CCDeprecated.h"
//#include "SensorsAnalytics.h"
#include "ui/CocosGUI.h"

#include "SensorsAnalytics/SensorsAnalytics/include/SensorsAnalytics.h"

USING_NS_CC;
using namespace std;
using namespace cocos2d::ui;

Scene *HelloWorld::createScene() {
    return HelloWorld::create();
}

// Print useful error message instead of segfaulting when files are not there.
static void problemLoading(const char *filename) {
    printf("Error while loading: %s\n", filename);
    printf("Depending on how you compiled you might have to add 'Resources/' in front of filenames in HelloWorldScene.cpp\n");
}

// on "init" you need to initialize your instance
bool HelloWorld::init() {
    //////////////////////////////
    // 1. super init first
    if (!Scene::init()) {
        return false;
    }

    auto visibleSize = Director::getInstance()->getVisibleSize();
    Vec2 origin = Director::getInstance()->getVisibleOrigin();

    /////////////////////////////
    // 2. add a menu item with "X" image, which is clicked to quit the program
    //    you may modify it.

    // add a "close" icon to exit the progress. it's an autorelease object
    auto closeItem = MenuItemImage::create(
            "CloseNormal.png",
            "CloseSelected.png",
            CC_CALLBACK_1(HelloWorld::menuCloseCallback, this));

    if (closeItem == nullptr ||
        closeItem->getContentSize().width <= 0 ||
        closeItem->getContentSize().height <= 0) {
        problemLoading("'CloseNormal.png' and 'CloseSelected.png'");
    } else {
        float x = origin.x + visibleSize.width - closeItem->getContentSize().width / 2 - 20;
        float y = origin.y + closeItem->getContentSize().height / 2 + 20;
        closeItem->setPosition(Vec2(x, y));
    }

    // create menu, it's an autorelease object
    auto menu = Menu::create(closeItem, NULL);

    menu->setPosition(Vec2::ZERO);
    this->addChild(menu, 4);
    /////////////////////////////
    // 3. add your codes below...

    // add a label shows "Hello World"
    // create and initialize a label

    auto label = Label::createWithTTF("Hello World", "fonts/Marker Felt.ttf", 24);
    if (label == nullptr) {
        problemLoading("'fonts/Marker Felt.ttf'");
    } else {
        // position the label on the center of the screen
        label->setPosition(Vec2(origin.x + visibleSize.width / 2,
                                origin.y + visibleSize.height - label->getContentSize().height));

        // add the label as a child to this layer
        this->addChild(label, 1);
    }

    // add "HelloWorld" splash screen"
    auto sprite = Sprite::create("HelloWorld.png");
//    if (sprite == nullptr)
//    {
//        problemLoading("'HelloWorld.png'");
//    }
//    else
//    {
//        // position the sprite on the center of the screen
//        sprite->setPosition(Vec2(visibleSize.width/2 + origin.x, visibleSize.height/2 + origin.y));
//
//        // add the sprite as a child to this layer
//        this->addChild(sprite, 0);
//    }

//    SensorsAnalytics::track();


    float x = origin.x + 50;
    float y = origin.y + 120;
    auto button = Button::create("HelloWorld.png", "HelloWorld.png", "HelloWorld.png");

//    addButton(x,y,*button,0);

    button->addTouchEventListener([&](Ref *sender, Widget::TouchEventType type) {
        switch (type) {
            case ui::Widget::TouchEventType::BEGAN:

                log("SA.Button1 clicked");
                break;
            case ui::Widget::TouchEventType::ENDED: {
                sensorsdata::SensorsAnalytics::trackTimerStart("timerabc");
                sensorsdata::SensorsAnalytics::trackTimerStart("timerabcd");

            }
                break;
            default:
                break;
        }
    });
    button->setPosition(Vec2(x, y));
    this->addChild(button);
//    SensorsAnalytics::track("timerabc");


    float x2 = origin.x + 100;
    float y2 = origin.y + 120;
    auto button2 = Button::create("HelloWorld.png", "HelloWorld.png", "HelloWorld.png");
    button2->addTouchEventListener([&](Ref *sender, Widget::TouchEventType type) {
        switch (type) {
            case ui::Widget::TouchEventType::BEGAN:

                log("SA.Button2 clicked");
                {
                    sensorsdata::ObjectNode pro;
                    pro.setBool("bool", true);
                    pro.setString("str", "string");
//                    SensorsAnalytics::trackTimerPause("timerabc");
//                    SensorsAnalytics::clearTrackTimer();
//                    SensorsAnalytics::clearSuperProperties();
//                    SensorsAnalytics::unregisterSuperProperty("reyuejianzhong");
                    sensorsdata::SensorsAnalytics::removeTimer("timerabc");
//                    SensorsAnalytics::deleteAll();
                }
                break;
            case ui::Widget::TouchEventType::ENDED:
                break;
            default:
                break;
        }
    });
    button2->setPosition(Vec2(x2, y2));
    this->addChild(button2);


    float x3 = origin.x + 150;
    float y3 = origin.y + 120;
    auto button3 = Button::create("HelloWorld.png", "HelloWorld.png", "HelloWorld.png");
    button3->addTouchEventListener([&](Ref *sender, Widget::TouchEventType type) {
        switch (type) {
            case ui::Widget::TouchEventType::BEGAN:

                log("SA.Button3 clicked");
                {
                    sensorsdata::ObjectNode pro;
                    pro.setBool("bool", true);
                    pro.setString("str", "string");
                    sensorsdata::SensorsAnalytics::trackTimerResume("timerabc");
                    sensorsdata::SensorsAnalytics::deleteAll();
                }
                break;
            case ui::Widget::TouchEventType::ENDED:
                break;
            default:
                break;
        }
    });
    button3->setPosition(Vec2(x3, y3));
    this->addChild(button3);


    float x4 = origin.x + 200;
    float y4 = origin.y + 120;
    auto button4 = Button::create("HelloWorld.png", "HelloWorld.png", "HelloWorld.png");
    button4->addTouchEventListener([&](Ref *sender, Widget::TouchEventType type) {
        switch (type) {
            case ui::Widget::TouchEventType::BEGAN:

                log("SA.Button4 clicked");
                {
                    sensorsdata::ObjectNode pro;
                    pro.setBool("bool", true);
                    pro.setString("str", "string");
                    sensorsdata::SensorsAnalytics::trackTimerEnd("timerabc");
                    sensorsdata::SensorsAnalytics::trackTimerEnd("timerabcd", pro);

                    sensorsdata::SensorsAnalytics::flush();
                }
                break;
            case ui::Widget::TouchEventType::ENDED:
                break;
            default:
                break;
        }
    });
    button4->setPosition(Vec2(x4, y4));
    this->addChild(button4);


    return true;
}

void HelloWorld::addButton(float x, float y, Button &button, int t) {


}

void HelloWorld::menuCloseCallback(Ref *pSender) {
    //Close the cocos2d-x game scene and quit the application
//    SensorsAnalytics::deleteAll();
//    Director::getInstance()->end();
    log("menuCloseCallback");
    sensorsdata::SensorsAnalytics::track("trackTimer");
    sensorsdata::SensorsAnalytics::flush();
    /*To navigate back to native iOS screen(if present) without quitting the application  ,do not use Director::getInstance()->end() as given above,instead trigger a custom event created in RootViewController.mm as below*/

    //EventCustom customEndEvent("game_scene_close_event");
    //_eventDispatcher->dispatchEvent(&customEndEvent);


}
