'use strict';

const fs = require('fs');
const path = require('path');

module.exports = {
  onAssetMenu(assetInfo) {
    const assetPath = assetInfo.url;
    const subpackage = getSubpackage(assetPath);

    return [
      {
        label: '★★★获取资源路径★★★',
        click() {
          handleMenuClick(assetInfo);
        },
        enabled: !!subpackage, // 动态设置菜单项的状态
      },
    ];
  },
};

function getSubpackage(assetPath) {
  const match = assetPath.match(/db:\/\/assets\/(.*?)\//);
  return match ? match[1] : null;
}

async function handleMenuClick(assetInfo) {
  try {
    const assetUuid = assetInfo.uuid;
    const info = await Editor.Message.request('asset-db', 'query-asset-info', assetUuid);
    const assetPath = info.url;
    const subpackage = getSubpackage(assetPath);

    if (subpackage) {
      const scriptPath = path.join(Editor.Project.path, `assets/${subpackage}/Scripts/Resources.ts`);
      const cleanAssetPath = cleanPath(assetPath, subpackage);
      await createOrUpdateScript(scriptPath, subpackage, info.name, cleanAssetPath);
    } else {
      console.log('资源不在任何分包中');
    }
  } catch (err) {
    console.error('查询资源信息失败', err.message);
  }
}

function cleanPath(assetPath, subpackage) {
  const basePath = `db://assets/${subpackage}/`;
  return assetPath.replace(basePath, '').replace(/\.[^/.]+$/, "");
}

async function createOrUpdateScript(scriptPath, subpackage, key, value) {
  try {
    let data = {};

    if (fs.existsSync(scriptPath)) {
      const content = fs.readFileSync(scriptPath, 'utf8');
      const regex = new RegExp(`export const ${subpackage}Res = (\\{[\\s\\S]*?\\});`);
      const match = content.match(regex);

      if (match && match[1]) {
        data = JSON.parse(match[1]);
      }
    }

    data[key] = value;

    const newContent = `export const ${subpackage}Res = ${JSON.stringify(data, null, 2)};`;

    fs.writeFileSync(scriptPath, newContent, 'utf8');
    console.log('脚本文件更新成功:', data);
  } catch (err) {
    console.error('脚本文件处理失败:', err.message);
  }
}
