import { _decorator, assetManager, Button, Component, find, instantiate, Node, Prefab } from 'cc';
import { testUi } from './testUi';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    protected onLoad(): void {
        assetManager.loadBundle('testbundle',(err,bundle)=>{
            bundle.load('testUi',(err,asset:Prefab)=>{
                let ui:Node = instantiate(asset);
                ui.parent = find('Canvas');
                let component = ui.addComponent(testUi);
                let fun = component['openAnim'];
                fun && fun.call(component,null);
            })
        });
    }
}


