import { _decorator, Component, find, Node, tween, UITransform, v3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('testUi')
export class testUi extends Component {

    openAnim():void{
        const block = this.node;
        const uiTransform = this.node.getComponent(UITransform);
        uiTransform.contentSize = find('Canvas').getComponent(UITransform).contentSize;

        block.scale = v3(0.1, 0.1, 0.1);
        console.log('before tween size==>',block.getComponent(UITransform).contentSize)
        tween(block).to(1,{scale:v3(1,1,1)}, {
            onUpdate: (target, ratio) => {
                console.log('tween size==>',block.getComponent(UITransform).contentSize)
            },
        }).call(()=>{
            console.log('after tween size==>',block.getComponent(UITransform).contentSize)
        }).start();
    }
}


