
import { _decorator, Component,EventHandler,Node, Button, Color } from 'cc';
import { ZGGSSpritespr } from './ZGGSSpritespr';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = YMButton
 * DateTime = Tue Oct 19 2021 15:31:04 GMT+0800 (中国标准时间)
 * Author = eduwc
 * FileBasename = YMButton.ts
 * FileBasenameNoExtension = YMButton
 * URL = db://assets/script/XXPrefab/YMButton.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */
 
@ccclass('ZGGSButtonbtn')
export class ZGGSButtonbtn extends Button {

    m_call:any = null;
    m_lastTime:number = 0;
    m_intervalTime:number = 200; //2次点击间隔时间

    m_color:Object = {};
    start () {
    }

    callback (call:(event: Event, customEventData: string)=>void,customEventData?:string) {
        this.m_call = call;

        const clickEventHandler = new EventHandler();
        clickEventHandler.target = this.node;
        clickEventHandler.component = 'ZGGSButtonbtn';
        clickEventHandler.handler = 'callbackHandler';
        clickEventHandler.customEventData = customEventData;

        this.clickEvents.push(clickEventHandler);



    }


    callbackHandler (event,customEventData) {
        let dangqian = Date.now();
        //防止点击过快
        if(dangqian-this.m_lastTime>this.m_intervalTime)
        {
            this.m_lastTime = dangqian
            this.m_call(event,customEventData);
        }

       
    }

    //按钮变成灰态，但是可以点击
    unuse()
    {
        var func = function(node){
            for (var i=0; i < node.children.length; i++) {
                var com = node.children[i].getComponent(ZGGSSpritespr)
                if(com) {
                    com.grayscale = true
                }
                func(node.children[i])
            }
        }.bind(this)
        func({children:[this.node]})
    }

    use()
    {
        var func = function(node){
            for (var i=0; i < node.children.length; i++) {
                var com = node.children[i].getComponent(ZGGSSpritespr)
                if(com) {
                    com.grayscale = false
                }
                func(node.children[i])
            }
        }.bind(this)
        func({children:[this.node]})
    }

 

}
