
import { _decorator, Component, resources, Prefab, Node, AudioClip, SpriteFrame } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = YMAssetManager
 * DateTime = Tue Oct 19 2021 17:50:54 GMT+0800 (中国标准时间)
 * Author = eduwc
 * FileBasename = YMAssetManager.ts
 * FileBasenameNoExtension = YMAssetManager
 * URL = db://assets/script/XXPrefab/YMAssetManager.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('ZGGSComPreLoad')
export class ZGGSComPreLoad extends Component {

    start() {

    }

    //**  
    //  * Prefab 加载
    //  * @param path 
    //  * @param callBack 
    //  */
    static loadPrefab(path, callBack: (prefab) => void) {
        resources.load(path, Prefab, (err, prefab) => {
            //console.log("loadPrefabErr",err)
            callBack(prefab);
        });

    }

    static loadAudio(path, callBack: (audioClip) => void) {
        resources.load(path, AudioClip, (err, audioClip) => {
            //console.log("loadAudioErr",err)
            callBack(audioClip);
        });
    }

    static loadSpriteFrame(path, callBack: (spriteFrame) => void) {
        resources.load(path, SpriteFrame, (err, spriteFrame) => {
            // console.log("loadSpriteFrame",spriteFrame)
            callBack(spriteFrame);
        });
    }

}
