
import { _decorator, Component, Node, Label, Sprite } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent
 * DateTime = Mon Oct 25 2021 15:23:25 GMT+0800 (中国标准时间)
 * Author = peacePLZ
 * FileBasename = NewComponent.ts
 * FileBasenameNoExtension = NewComponent
 * URL = db://assets/NewComponent.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('NewComponent')
export class testBtn extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property(Label)
    str: Label = null;

    @property(Sprite)
    Sp: Sprite = null;
    start() {
        // [3]
    }

    // update (deltaTime: number) {
    //     // [4]
    // }

    private _index = 0;
    setData(id: number) {
        let ts = this;
        this._index = id;
        this.str.string = id.toString();
        //在这个里面加监听就会点到遮罩之外的,在onload 或者start不会
        //本地就可复现
        this.Sp.node.on(Node.EventType.TOUCH_END, () => {
            console.log(`点到了${ts._index}`);
        }, this)
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
