
import { _decorator, Component, Node, instantiate, ScrollView, UITransform } from 'cc';
import { testBtn } from './testBtn';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = TestScrollView
 * DateTime = Mon Oct 25 2021 15:27:16 GMT+0800 (中国标准时间)
 * Author = peacePLZ
 * FileBasename = testScrollView.ts
 * FileBasenameNoExtension = testScrollView
 * URL = db://assets/testScrollView.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('TestScrollView')
export class TestScrollView extends Component {
    // [1]
    // dummy = '';
    @property(Node)
    Content: Node = null;

    @property(Node)
    Button: Node = null;

    @property(ScrollView)
    SV: ScrollView = null;
    // [2]
    // @property
    // serializableDummy = 0;

    private BtnArrays: testBtn[] = [];
    private _height = 0;
    speed: number = 100;
    start() {
        this._height = 6 * 100 + 5 * 10;
        this.Content.getComponent(UITransform).height = this._height;
        for (let index = 0; index < 12; index++) {
            let node = instantiate(this.Button);
            let com = node.getComponent(testBtn);
            this.BtnArrays.push(com);
            com.setData(index);
            this.Content.addChild(node);
        }

        this._SrollDown();
        // [3]
    }

    private _SrollDown() {
        let distance = (this._height - 250) - this.Content.position.y;
        let time = distance / this.speed;
        this.SV.scrollToBottom(time, false)
        this.scheduleOnce(this._SrollTop, time);
    }

    private _SrollTop() {
        let distance = this.Content.position.y;
        let time = distance / this.speed;
        this.SV.scrollToTop(time, false)
        this.scheduleOnce(this._SrollDown, time);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
