import ADControl from "./adSdk/ADControl";
import ConfData from "./manage/conf/ConfData";
import BundleControl from "./manage/control/controlBunle/BundleControl";
import GameControl from "./manage/control/controlData/GameControl";
import GuideControl from "./manage/control/controlData/GuideControl";
import StorageConreol from "./manage/control/controlData/StorageConreol";
import StateControl from "./manage/control/StateControl";
import ViewControl from "./manage/control/ViewControl";
import { bundles, Pages, Storey } from "./manage/enum/Integrate";
import { ResControl } from "./manage/resUrl/bundles";
import GameView from "./view/GameView";
// import { PosType } from "./ZTSDK/GaComponent";



const { ccclass, property } = cc._decorator;

@ccclass
export default class AppRoot extends cc.Component {

    // LIFE-CYCLE CALLBACKS:
    @property(cc.Canvas)
    Canvas: cc.Canvas = null;

    @property(GameView)
    GameView: GameView = null;


    //预加载页面
    private Prefabs: Pages[] = [ /*Pages.HomeView, Pages.WinView,*/ Pages.WaitView]

    /**需要加载的数量 */
    private loadNum: number = 5
    /**已经加载的数量 */
    private alreadyLoadNum = 0


    onLoad() {
        console.log('AppRoot加载完成');
        this.init()
    }

    start() {

    }



    // update (dt) {}
    init() {

        if (cc.winSize.height < 1200) {
            let height = cc.winSize.height
            GameControl.ints.changeRatio = true
            this.Canvas.fitWidth = false
            this.Canvas.fitHeight = true

            let width = cc.winSize.height * (height / 1334)

            this.Canvas.designResolution.width = width
            this.Canvas.designResolution.height = 1334
            this.node.width = width
            this.node.height = 1334
        }





        window.clog = {} as any

        // let __debug = cc.sys.localStorage.getItem('__debug')
        // if (__debug == 1) {
        //     window['__debug'] = 101
        // }

        let debug = window['__debug'] == 101
        if (debug || cc.sys.isBrowser) {
            clog.log = console.log.bind(console);
            clog.warn = console.warn.bind(console);
            clog.error = console.error.bind(console);
            clog.time = console.time.bind(console);
            clog.timeEnd = console.timeEnd.bind(console);
            clog.info = console.timeEnd.bind(console);
        } else {
            clog.log = () => void {}
            clog.warn = () => void {}
            clog.error = () => void {}
            clog.time = () => void {}
            clog.timeEnd = () => void {}
            clog.info = () => void {}
        }

        clog.log(this.Canvas.designResolution.width, this.Canvas.designResolution.height, cc.winSize.width, cc.winSize.height, this.node.width, this.node.height);

        this.load()
    }

    async load() {

        if (cc.sys.isBrowser) {
            window['__GM'] = 101
            window['__skin'] = 1
            window['__mapId'] = 3
            window['__bgID'] = 2 //0原1格子2天空
            window['__mapType'] = 1 //0=7x17  1=6x16
            window['__keyID'] = 0
            window['__guide'] = 1 //1同色2空瓶

        }
        // if (window['__mapId'] == 2 && window['__keyID'] == 2) {
        //     window['__mapType'] = 1
        // }
        ADControl.ints.keyID = window['__keyID'] || 0
        GameControl.ints.mapType = window['__mapType'] || 0

        ResControl.ints.time = Date.now()
        clog.time('------------------load over')
        clog.time('------------------load over1')
        clog.time('------------------load over2')
        clog.time('------------------load over3')
        clog.time('------------------load over4')
        clog.time('------------------load over5')
        clog.time('------------------load over6')
        ResControl.ints.initData()
        ViewControl.ints.initData(this.node)


        // ViewControl.ints.openView(Pages.LoadView, Storey.ViewUI, null, false)

        this.loadBundle()
        let time = Date.now()
        ///***增加初始化类注意适配抖音直玩 */
        await ADControl.ints.initData()
        console.warn('------------------load over AD time-', Date.now() - time)
        await StorageConreol.ints.intiData()

        this.dataComplete()
        this.initControl()

    }

    async loadBundle() {
        let num = 0
        for (let v in bundles) {
            BundleControl.ints.loadSub(bundles[v], () => {
                num++
                if (num == 3) {
                    this.addLoadNum('loadBundle', 1)
                    let fun = async () => {
                        await this.loadPrefabs()
                    }
                    let fun2 = async () => {
                        await this.loadConf()
                    }
                    fun()
                    fun2()
                }
            })
        }



    }
    private async loadConf() {
        let mapId = window['__mapId'] || 1
        let data = await BundleControl.ints.getAsset("conf/map" + mapId, cc.JsonAsset) as cc.JsonAsset
        ConfData.ints.parseJson(data)
        this.addLoadNum('loadConf', 2)
        this.dataComplete()
    }



    async loadPrefabs() {
        await ViewControl.ints.loadView(this.Prefabs)
        this.addLoadNum('loadPrefabs', 3)
        this.dataComplete()
    }
    ///***增加初始化类注意适配抖音直玩 */
    initControl() {

        StateControl.ints.initData()
        GuideControl.ints.initData()
        this.addLoadNum('initControl', 4)

    }


    private _dataCompleteNum = 0
    ///***增加初始化类注意适配抖音直玩 */
    /**用户数据和 本地地图数据加载完成后执行 */
    async dataComplete() {
        this._dataCompleteNum++
        if (this._dataCompleteNum == 3) {
            await GameControl.ints.initData()

            this.addLoadNum('dataComplete', 5)
        }

    }

    addLoadNum(name: string, index: number) {

        this.alreadyLoadNum++
        clog.timeEnd('------------------load over' + this.alreadyLoadNum)
        console.warn('------------------load over time-' + this.alreadyLoadNum, Date.now() - ResControl.ints.time)
        console.log(name)

        if (this.alreadyLoadNum == this.loadNum) {
            this.GameView.showView()
            StateControl.ints.playBGM('BGM')
        }


    }




}
