import DateControl from "../manage/control/controlData/DateControl"
import GameControl from "../manage/control/controlData/GameControl"
import StorageConreol from "../manage/control/controlData/StorageConreol"
import EventControl from "../manage/control/event/EventControl"
import StateControl from "../manage/control/StateControl"
import ViewControl from "../manage/control/ViewControl"
import { EventName } from "../manage/enum/EventEnum"
import DefApi from "./DefApi"
import ZTSDKControl from "./ZTSDKControl"



export default class ADControl {

    /**是否在直玩界面 */
    isStraight: boolean = false

    keyID: number = 0


    private _openId: string = '-235'


    private static _ints: ADControl

    static get ints() {
        if (!this._ints) {
            this._ints = new ADControl
        }
        return this._ints
    }

    private _isPlayVideo = false
    private _platform: DefApi = null

    private _type: platformType = platformType.None

    get isPlayVideo() {
        return this._isPlayVideo
    }

    get openId() {
        return this._openId
    }

    get type() {
        return this._type
    }




    private _notAD: boolean = false
    notAD() {
        this._notAD = !this._notAD
        return this._notAD
    }

    initData() {
        return new Promise(async (resolve, reject) => {


            this._type = platformType.None



           
            clog.log('keyID', this.keyID);


            this._platform = new DefApi()
            let time = Date.now()



            let code = await this._platform.login(false)

            let data: any = await ZTSDKControl.ints.initData(this._type)
            if (data && data.isSuccess) {
                this._openId = data.openId
                clog.log('openid', this._openId)
            }
            console.warn('------------------load over ZTSDK time-', Date.now() - time)
            this.onShow()
            this.onHide()

            resolve(code)
        })
    }

    /**侧边栏奖励判断 */
    sidebar(_data?) {

        let data = null
        if (_data) {
            data = _data
        } else {
            data = this._platform.getLaunchOptionsSync()
        }
        clog.log('sidebar启动参数', data)
        let cebianlan = StorageConreol.ints.getStorage('cebianlan')
        if (cebianlan == 0) {
            switch (cc.sys.platform) {
                case cc.sys.WECHAT_GAME:
                    if (data.scene == '1089' || data.scene == '1103' || data.scene == '1257' || data.scene == '1027') {
                        StorageConreol.ints.setStorage('cebianlan', 1)
                    }
                    break
                case cc.sys['BYTEDANCE_GAME']:
                    if (data.scene == '021001' || data.scene == '021036' || data.scene == '101001' || data.scene == '101036' || data.scene == '021020') {
                        StorageConreol.ints.setStorage('cebianlan', 1)
                    }

                    break
                case cc.sys.WECHAT_GAME:

                    break
                case cc.sys.WECHAT_GAME:

                    break
                default:

            }
            EventControl.ints.emit(EventName.RedDrop)
        }
    }


    onShow() {

        this._platform.onShow((res) => {
            clog.log('onShow', res)
            if (!this._isPlayVideo) {
                StateControl.ints.resumeMusic()
            }
            this.sidebar(res)
        })
    }
    onHide() {
        this._platform.onHide(() => {
            if (!this._isPlayVideo) {
                StateControl.ints.pauseMusic()
            }
        })
    }



    showVideo(data: { successFun?: Function, failFun?: Function, errFun?: Function, closeFun?: Function }) {
        if (this._notAD) {
            data.successFun && data.successFun()
            data.closeFun && data.closeFun()
            return
        }
        if (this._isPlayVideo) {
            ViewControl.ints.showTip('正在播放视频，请稍后...')
            return
        }
        this._isPlayVideo = true
        let _data = {
            successFun: () => {
                this._isPlayVideo = false
                data.successFun && data.successFun()
            },
            failFun: () => {
                ViewControl.ints.showTip('播放完才有奖励哦')
                this._isPlayVideo = false
                data.failFun && data.failFun()
            },
            errFun: () => {
                ViewControl.ints.showTip('视频出错了')
                this._isPlayVideo = false
                data.errFun && data.errFun()

            },
            closeFun: async () => {
                GameControl.ints.gameRun()
                StateControl.ints.resumeMusic()
                this._isPlayVideo = false
                data.closeFun && data.closeFun()
            }
        }
        StateControl.ints.pauseMusic()
        GameControl.ints.gamePause()
        this._platform.showVideo(_data)
    }

    /**右上角拉起分享 */
    onShareAppMessage() {
        this._platform.onShareAppMessage()
    }
    /**主动分享 */
    shareAppMessage() {
        this._platform.shareAppMessage()
    }

    /*******插屏 ************/

    showInterstitialAd() {
        if (this._notAD) return
        this._platform.showInterstitialAd()
    }
    /*******banner ************/
    showBannerAd() {
        if (this._notAD) return
        this._platform.showBannerAd()
    }

    hideBannerAd() {
        this._platform.hideBannerAd()
    }

    /**短震动 */
    vibrateShort() {
        this._platform.vibrateShort()
    }

    /**长震动 */
    vibrateLong() {
        this._platform.shareAppMessage()
    }

    /**添加桌面 */
    async addShortcut() {
        return await this._platform.addShortcut()
    }

    /**添加桌面查询 */
    async checkShortcut() {
        return await this._platform.checkShortcut()
    }

    /**设为常用 */
    async addCommonUse() {
        return await this._platform.addCommonUse()
    }
    /**设为常用查询 */
    async checkCommonUse() {
        return await this._platform.checkCommonUse()
    }
    /**获取小游戏冷启动时的参数 */
    getLaunchOptionsSync() {
        return this._platform.getLaunchOptionsSync()
    }
    /**侧边栏是否可用 */
    async checkScene() {
        return await this._platform.checkScene()
    }

    /**跳到侧边栏 */
    navigateToScene(fun: Function) {
        this._platform.navigateToScene(fun)
    }

    /**敏感词查询接口 */
    async sensitiveWordCheck(str: string) {
        return await this._platform.sensitiveWordCheck(str)
    }

    /**场景上报 */
    reportScene(data: { sceneId?: number, costTime: number }) {
        this._platform.reportScene(data)
    }

    reportAnalytics(key: string, data: any) {
        this._platform.reportAnalytics(key, data)
    }


    private checkFeed: boolean = false
    /**查询订阅状态,tt专属 */
    checkFeedSubscribeStatus() {

        if (!this.checkFeed) {
            this.checkFeed = true
            this._platform.checkFeedSubscribeStatus()
        }
    }
    /**拉取客服 */
    openCustomerServiceConversation() {
        this._platform.openCustomerServiceConversation()
    }
    /**版本更新提示 */
    getUpdateManager() {
        this._platform.getUpdateManager()
    }


    

    /**获取用户信息授权 */
    async getSetting(key: string) {
        return await this._platform.getSetting(key)
    }
    /**显示获取用户信息按钮 */
    getUserDataBtn(node: cc.Node, fun: Function) {
        return this._platform.getUserDataBtn(node, fun)
    }

    async getUserData() {
        return await this._platform.getUserData()
    }

    getBottomInfo(node: cc.Node) {
        return this._platform.getBottomInfo(node)
    }

    /**打开设置 */
    async openSetting(key: string) {
        return await this._platform.openSetting(key)
    }

    /**向子域发送数据 */
    postMessage(data: { key: string, value: string }[]) {
        this._platform.postMessage(data)
    }

    /**上报托管数据 */
    setUserCloudStorage(data: { key: string, value: string }[]) {
        this._platform.setUserCloudStorage(data)
    }


}

export enum platformType {
    None,
    WX,
    TT,
    KS,
    BL
}