import GameControl from "../manage/control/controlData/GameControl"
import { UserStorage } from "../manage/control/controlData/StorageConreol"
import ADControl, { platformType } from "./ADControl"

export default class ZTSDKControl {

    private static _ints: ZTSDKControl

    static get ints() {
        if (!this._ints) {
            this._ints = new ZTSDKControl
        }
        return this._ints
    }

    version: string = '1.0.0'

    private _ga: any//GA



    initData(_type: platformType) {
        return new Promise(async (resolve, reject) => {

            let fun = () => {
                this._ga = {}
                this._ga.onLevelStart = function () { return Promise.resolve() };
                this._ga.onLevelSuccess = function () { return Promise.resolve() };
                this._ga.onLevelGiveUp = function () { return Promise.resolve() };
                this._ga.onLevelFail = function () { return Promise.resolve() };
                this._ga.onAdFinish = function () { return Promise.resolve() };
                this._ga.onAdCancel = function () { return Promise.resolve() };
                this._ga.onAdRequest = function () { return Promise.resolve() };
                this._ga.onGameExit = function () { return Promise.resolve() };
                this._ga.onModEnter = function () { return Promise.resolve() };
                this._ga.onModExit = function () { return Promise.resolve() };
                this._ga.getGameDataFromServer = function () { return Promise.resolve() };
                this._ga.saveDataToServer = function () { return Promise.resolve() };
                window['ga'] = this._ga

            }

            fun()
            resolve(null)
            return

        })
    }



    /**是否可以上报 */
    isReport() {
        let isReport = true
        if (this._ga) {
            isReport = true
        } else {
            isReport = false
        }
        return isReport
    }


    //ZTSDKControl.ints
    onLevelStart(data) {
        if (this.isReport()) {
            this._ga.onLevelStart(data)
        }
    }
    onLevelSuccess(data) {
        if (this.isReport()) {
            this._ga.onLevelSuccess(data)
        }
    }
    onLevelGiveUp(data) {
        if (this.isReport()) {
            this._ga.onLevelGiveUp(data)
        }
    }
    onLevelFail(data) {
        if (this.isReport()) {
            this._ga.onLevelFail(data)
        }
    }
    onAdFinish(data) {
        if (this.isReport()) {
            this._ga.onAdFinish(data)
        }
    }
    onAdCancel(data) {
        if (this.isReport()) {
            this._ga.onAdCancel(data)
        }
    }
    onAdRequest(data) {
        if (this.isReport()) {
            this._ga.onAdRequest(data)
        }
    }
    onGameExit(data) {
        if (this.isReport()) {
            this._ga.onGameExit(data)
        }
    }
    onModEnter(data) {
        if (this.isReport()) {
            this._ga.onModEnter(data)
        }
    }
    onModExit(data) {
        if (this.isReport()) {
            this._ga.onModExit(data)
        }
    }

    private _keyName: string = 'spxmjds_user_data'
    /**从服务器获取数据 */
    getGameDataFromServer(isNewPlay: number) {
        return new Promise((resolve, reject) => {
            if (cc.sys.isBrowser || !this._ga) {
                resolve(null)
                return;
            }
            let tharData = { success: true, data: null }
            this._ga.loadDataFromServer(this._keyName).then((data) => {
                clog.log("loadDataFromServer:", data);
                if (isNewPlay != 1) {
                    tharData = data
                }
                clog.log('tharData', tharData)
                let resultData = null
                if (tharData && tharData.success) {
                    clog.log(data.data)
                    if (tharData.data) {
                        resultData = JSON.parse(JSON.parse(tharData.data))
                    }
                }
                resolve(resultData)
            });
        })

    }

    saveDataToServer(data: any) {
        if (this._ga) {

            this._ga.saveDataToServer(this._keyName, JSON.stringify(data)).then(() => {
                clog.log('保存数据成功');
            })
        }
    }






}