import ADControl from "../../adSdk/ADControl";
import ZTSDKControl from "../../adSdk/ZTSDKControl";
import DateControl from "../../manage/control/controlData/DateControl";
import GameControl, { BottleData, ColorType } from "../../manage/control/controlData/GameControl";
import GuideControl from "../../manage/control/controlData/GuideControl";
import NodeControl from "../../manage/control/controlNode/NodeControl";
import EventControl from "../../manage/control/event/EventControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { EventName } from "../../manage/enum/EventEnum";
import ArrayUtil from "../../manage/utils/ArrayUtil";

const { ccclass, property } = cc._decorator;

@ccclass
export default class bottle extends cc.Component {


    @property(cc.Node)
    block: cc.Node = null;

    @property(cc.Node)
    top: cc.Node = null;
    @property(cc.Mask)
    mask: cc.Mask = null;
    @property(cc.Node)
    waterNode: cc.Node = null;
    @property(cc.Node)
    plug: cc.Node = null;
    @property(cc.Node)
    video: cc.Node = null;

    @property(cc.Node)
    lock: cc.Node = null;
    @property(cc.Label)
    lockNum: cc.Label = null;

    @property(cc.Node)
    shadow: cc.Node = null;
    @property(cc.Node)
    column: cc.Node = null;
    @property(cc.Node)
    column2: cc.Node = null;
    @property(cc.Node)
    disturb: cc.Node = null;
    @property(cc.Node)
    appear: cc.Node = null;
    @property(cc.Node)
    appear4: cc.Node = null;

    @property(cc.Node)
    lockColor: cc.Node = null;
    @property(cc.Node)
    brand: cc.Node = null;

    @property(cc.Node)
    blast: cc.Node = null;
    @property(cc.Node)
    light: cc.Node = null;
    @property(cc.Node)
    opening: cc.Node = null;
    @property(cc.Node)
    bottle: cc.Node = null;


    @property(cc.ParticleSystem)
    ParticleAsset: cc.ParticleSystem = null;

    @property([cc.Node])
    storeys: cc.Node[] = [];
    @property([cc.Node])
    storeyColors: cc.Node[] = [];


    protected _data: BottleData = null
    protected blockHeight: number = -1000
    protected _lockScale: number = 0

    /**瓶子是否可以箱子操作 */
    public isOperate: boolean = true

    /**瓶子是否正在倒水 */
    public _isPourWater: boolean = false



    block_pos: cc.Vec2 = null

    protected _index: number = 0

    protected _shadowOpacity: number = -1

    get isPourWater() {
        return this._isPourWater
    }
    set isPourWater(value: boolean) {
        if (value) {
            GameControl.ints.operate = 1
        } else {
            GameControl.ints.operate = -1
        }

        this._isPourWater = value
    }

    get data() {
        return this._data
    }

    get index() {
        return this._index
    }
    /**是否已经完成 */
    get complete() {
        return this._data.complete == 1
    }


    protected _zIndex: number = -1


    get zIndex() {
        return this._zIndex
    }

    protected _lightForever: cc.Tween = null

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        cc.tween(this.brand)
            .to(2, { angle: -5 })
            .to(2, { angle: 5 })
            .union()
            .repeatForever()
            .start()
        this._lightForever = cc.tween(this.light)
            .to(2, { opacity: 0 })
            .to(2, { opacity: 255 })
            .union()
            .repeatForever()
            .start()


    }

    setData(_data: BottleData, index: number) {
        this.off()
        this._index = index
        this._data = _data
        this.block_pos = GameControl.ints.getPos(this._data.pos)
        this._zIndex = -1
        if (this._data.ad == 1) {
            this.node.on(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
            this.node.on(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
            this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
        } else {
            this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
        }




        this.initData()
    }

    off() {
        this.node.off(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
        this.node.off(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
        this.node.off(cc.Node.EventType.TOUCH_START, this.touchStart, this);
    }

    showBlock() {
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == ColorType.NONE) {
                this.storeys[i].active = false
                this.storeys[i].children[1].active = false
            } else {
                GameControl.ints.bottleBlockNum++
                if (!GameControl.ints.colorNum[this._data[i][0]]) GameControl.ints.colorNum[this._data[i][0]] = 0
                GameControl.ints.colorNum[this._data[i][0]]++
                this.storeys[i].active = true
                if (this.blockHeight != -1000) {
                    this.storeys[i].height = this.blockHeight
                }
                this.storeyColors[i].children[0].active = false
                if (this._data[i][1] == 1) {
                    this.storeys[i].children[1].active = true
                    this.storeys[i].children[1].getComponent(cc.Sprite).enabled = false
                    this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                    this.storeyColors[i].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                } else {
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.storeyColors[i].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                    }
                    this.storeys[i].children[1].active = false

                }

            }
        }
        this.lock.opacity = 150
    }

    initData() {
        this.bottle.active = true//this._data.ad == 0


        let data = this.getEmpty()
        this.opening.opacity = data == 0 ? 255 : 0
        this.blast.active = false
        this.node.parent.setPosition(this.block_pos)
        if (this._shadowOpacity == -1) this._shadowOpacity = this.shadow.opacity
        this.shadow.opacity = this._shadowOpacity
        this.shadow.x = -60
        this.shadow.y = 25
        this.node.y = 0
        this.isOperate = true
        this.ParticleAsset.resetSystem()
        this.ParticleAsset.node.active = false

        this._isPourWater = false
        this.light.active = false
        this.block.parent = GameControl.ints.gameView.mapNode
        if (this._zIndex == -1) this._zIndex = this._data.pos[1] * 50 + 50 - this._data.pos[0] * 2
        this.block.zIndex = this._zIndex
        this.block.name = this._zIndex + ''
        this.lockNum.node.x = 3

        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == ColorType.NONE) {
                this.storeys[i].active = false
                this.storeys[i].children[1].active = false
            } else {
                GameControl.ints.bottleBlockNum++
                if (!GameControl.ints.colorNum[this._data[i][0]]) GameControl.ints.colorNum[this._data[i][0]] = 0
                GameControl.ints.colorNum[this._data[i][0]]++
                this.storeys[i].active = true
                if (this.blockHeight != -1000) {
                    this.storeys[i].height = this.blockHeight
                }
                this.storeyColors[i].children[0].active = false
                if (this._data[i][1] == 1) {
                    this.storeys[i].children[1].active = true
                    this.storeys[i].children[1].getComponent(cc.Sprite).enabled = true
                    this.storeyColors[i].color = cc.color().fromHEX('#000000')
                    this.storeyColors[i].children[0].color = cc.color().fromHEX('#000000')

                } else {
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.storeyColors[i].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                    }
                    this.storeys[i].children[1].active = false

                }
                this.storeys[i].children[1].opacity = 255

            }
        }
        if (this.getEmpty() != 4 && this._data.ad != 1) {
            this.top.color = cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].bleak)
            this.top.children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].bleak)
            this.top.children[0].active = false
        }

        this.top.children[1].active = false
        this.top.parent.active = this.getEmpty() != 4
        this.node.active = this._data.showBottle == 1
        this.video.active = this._data.ad == 1
        this.mask.enabled = false
        this.column.active = false
        this.column2.active = false
        this.disturb.active = false
        this.appear.active = false
        this.appear4.active = false

        this.waterNode.scale = 1
        this.block.scale = 1
        if (this.blockHeight == -1000) {
            this.blockHeight = this.storeys[3].height
        }

        if (this._data.ad == 1) {
            this.plug.y = 345
            this.plug.active = true

        } else {
            this.plug.active = this._data.complete == 1
        }
        if (this.plug.active) {
            this.plug.opacity = 255
        }

        this.lock.opacity = 255
        this.lock.active = this._data.lock[0] != 0
        if (this._lockScale == 0) this._lockScale = this.lock.scale
        this.lock.scale = this._lockScale

        if (this.lock.active && this._data.lock[0] != ColorType.BLACK) {

            this.lockColor.color = cc.color().fromHEX(GameControl.ints.colorList[this._data.lock[0]].dark)
        } else if (this.lock.active && this._data.lock[0] == ColorType.BLACK) {
            this.lockColor.color = cc.color().fromHEX('#FFFFFF')
        }



        this.lockNum.string = this._data.lock[1] + ''

    }
    /**锁定值减少 */
    async unlock() {
        return new Promise(async (resolve, reject) => {
            this._data.lock[1]--
            if (this._data.lock[1] == 0) this.lockNum.node.x = -5
            this.lockNum.string = this._data.lock[1] + ''
            let time = 0.3
            cc.tween(this.lockNum.node)
                .to(time / 2, { scale: 1.4 })
                .to(time / 2, { scale: 1 })
                .call(() => {

                })
                .start()


            if (this._data.lock[1] <= 0) {
                this._data.lock[0] = 0
                resolve(true)
                await DateControl.ints.Delay(time)
                this.brand.angle = 0
                this.ParticleAsset.node.active = true
                this.block.parent = GameControl.ints.gameView.topMap
                this.block.zIndex = 1
                cc.tween(this.lock)
                    .to(0.2, { scale: 0 })
                    .delay(1)
                    .call(() => {
                        this.block.parent = GameControl.ints.gameView.mapNode
                        this.block.zIndex = this._zIndex
                    })
                    .start()
            }
            resolve(false)
        })


    }

    setOpening() {
        let opacity: number = 0
        let data = this.getEmpty()
        if (data == 0) opacity = 255
        cc.Tween.stopAllByTarget(this.opening)
        cc.tween(this.opening)
            .to(0.5, { opacity })
            .start()
    }

    /**盖瓶子 */
    cover() {
        this.plug.active = true
        this.plug.opacity = 0
        this.plug.y = 435
        let thar = this

        cc.tween(this.plug)
            .to(0.3, { opacity: 255, y: 345 })
            .call(() => {
                StateControl.ints.playEffect('装满水声音')



                this.appear4.active = true
                this.appear4.getComponent(sp.Skeleton).setCompleteListener(() => {
                    this.appear4.active = false
                    EventControl.ints.emit(EventName.BoxInspect, thar)
                })
                this.appear4.getComponent(sp.Skeleton).setAnimation(0, 'guang', false)
                EventControl.ints.emit(EventName.showPlayNow, thar);
            })
            .start()
    }

    /**开瓶子 */
    openCover() {
        this.appear.active = true
        this.appear.getComponent(sp.Skeleton).setCompleteListener(() => {
            this.appear.active = false
        })
        this.appear.getComponent(sp.Skeleton).setAnimation(0, 'guang', false)

        this.plug.active = true
        this.plug.opacity = 255
        this.plug.y = 345
        this._isPourWater = true
        cc.tween(this.node)
            .to(0.1, { scaleY: 0.5 })
            .call(() => {
                StateControl.ints.playEffect('解锁')
            })
            .to(0.1, { scaleY: 0.55 })
            .call(() => {
                this.bottle.active = true
                cc.tween(this.plug)
                    .to(0.2, { opacity: 200, y: 500 })
                    .to(0.2, { opacity: 0, y: 500 })
                    .call(() => {
                        this._isPourWater = false
                    })
                    .start()

            })
            .start()


    }




    /**获得是否可以打乱 */
    getDisturb(showTip: boolean) {
        if (this._data.lock[0] != 0 || this._data.ad == 1) return
        let can = false
        let colorId = -1
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0 && this._data[i][1] == 1) {
                can = true
                break
            }
            if (this._data[i][0] != 0 && colorId == -1) {
                colorId = this._data[i][0]
            }
            if (this._data[i][0] != 0 && this._data[i][0] != colorId) {
                can = true
                break
            }
        }

        return can
    }

    setDisturb() {
        this.disturb.active = true
    }
    /**打乱动画 */
    disturbAn() {

        let lastBottle = GameControl.ints.lastBottle
        if (lastBottle) {
            if (lastBottle.addBottle == this) {
                GameControl.ints.lastBottle = null
                GameControl.ints.gameView.backInspect()
            }
        }

        GameControl.ints.gameView.restoreDisturb()
        StateControl.ints.playEffect('乱序')
        let data: Record<number, number[]> = {}
        let data2: Record<number, number[]> = {}
        let arr: number[] = []


        for (let i = 3; i >= this.getEmpty(); i--) {
            arr.push(i)
            if (!data2[i]) data2[i] = []
            data2[i][0] = this.data[i][0]
            data2[i][1] = this.data[i][1]
        }
        ArrayUtil.shuffle(arr)
        for (let i = 0; i < arr.length; i++) {
            this.data[3 - i][0] = data2[arr[i]][0]
            this.data[3 - i][1] = data2[arr[i]][1]
        }


        for (let i = 3; i >= this.getEmpty(); i--) {
            if (!data[i]) data[i] = []
            data[i][0] = this.data[i][0]
            data[i][1] = this.data[i][1]
        }



        let index = 0
        let fun = () => {
            index++
            for (let i = 3; i >= this.getEmpty(); i--) {
                let datai = i - 1
                if (i <= this.getEmpty()) {
                    datai = 3
                }
                data2[i][0] = data[datai][0]
                data2[i][1] = data[datai][1]
            }

            for (let i = 3; i >= this.getEmpty(); i--) {
                data[i][0] = data2[i][0]
                data[i][1] = data2[i][1]
            }
            // clog.log(data2);


            let fun2 = (data3) => {

                for (let i = 3; i >= this.getEmpty(); i--) {

                    this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[data3[i][0]].dark)
                    this.storeyColors[i].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[data3[i][0]].dark)
                    if (data3[i][1] == 1) {
                        this.storeys[i].children[1].active = true
                        this.storeys[i].children[1].opacity = 255
                        this.storeys[i].children[1].getComponent(cc.Sprite).enabled = true

                        this.storeyColors[i].color = cc.color().fromHEX('#000000')
                        this.storeyColors[i].children[0].color = cc.color().fromHEX('#000000')
                    } else if (data3[i][1] == 0) {

                        this.storeys[i].children[1].active = false
                    }
                }
                this.top.color = cc.color().fromHEX(GameControl.ints.colorList[data3[this.getEmpty()][0]].bleak)
                this.top.children[0].color = cc.color().fromHEX(GameControl.ints.colorList[data3[this.getEmpty()][0]].bleak)
            }
            fun2(data2)

            if (index >= 16) {
                fun2(this.data)

                for (let i = 0; i < 3; i++) { //判断最顶层是否黑色，黑色就解锁
                    if (this._data[i][0] != 0) {
                        if (this._data[i][1] == 1) {
                            this._data[i][1] = 0
                            this.storeys[i].children[1].active = false
                            this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                            this.storeyColors[i].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        }

                        break
                    }
                }

                this.unschedule(fun)

            }

        }
        fun()
        let time = 0.02
        // if (arr.length == 2) time = 0.02
        this.schedule(fun, time)



    }

    /**是否已经完成 */
    isComplete() {
        let isComplete = 1
        let color = 0
        color = this._data[3][0]
        if (color == ColorType.NONE) return
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == ColorType.NONE || this._data[i][1] == 1 || color != this._data[i][0]) {
                isComplete = 0
                break
            }
        }

        this._data.complete = isComplete

    }
    /**黑色块解锁 */
    blackUnlock() {
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                if (this._data[i][1] == 1) {
                    this._data[i][1] = 0
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.storeyColors[i].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                    }
                    this.blast.active = true
                    this.blast.getComponent(sp.Skeleton).setAnimation(0, 'bao', false)
                    this.blast.getComponent(sp.Skeleton).setCompleteListener(() => {
                        this.blast.active = false
                    })
                    this.blast.y = this.storeys[i].y
                    cc.tween(this.storeys[i].children[1])
                        .to(0.3, { opacity: 0 })
                        .start()

                }
                break
            }
        }
    }

    /**获得最上层颜色id */
    getTopColorId() {
        let colorId = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                colorId = this._data[i][0]
                break
            }
        }

        return colorId
    }
    /**获得上层空位有多少 */
    getEmpty() {
        let empty = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == 0) {
                empty++
            }
        }

        return empty
    }
    /**获得上层相同颜色层 */
    getTopColor(): number[] {
        let index = []
        let colorId = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                if (colorId == 0) colorId = this._data[i][0]
                if (this._data[i][0] == colorId && this._data[i][1] != 1) {
                    index.push(i)
                } else {
                    break
                }
            }
        }
        return index
    }

    /**倒水时长 */
    protected pourWaterTime: number = 0.15
    /**倾斜时长 */
    protected inclineTime: number = 0.2

    /**移动到瓶子位置 1左-右 */
    async pourWater(selectItem: bottle) {
        GameControl.ints.selectItem = null
        selectItem.light.active = false
        let otherNode: cc.Node = selectItem.block
        otherNode.parent = GameControl.ints.gameView.topMap
        cc.Tween.stopAllByTarget(selectItem.node)

        otherNode.y += this._riseY
        selectItem.node.y = 0

        this.light.active = true
        cc.Tween.stopAllByTarget(this.light)
        this.light.opacity = 255

        let time = 0.1
        let x = 150
        let y = 90
        let x2 = 180
        let y2 = 240
        let angle = 80
        let angle2 = 0

        let direction = 1
        if (this.node.parent.x < selectItem.node.parent.x || this._data.pos[0] == 0) {
            direction = -1
        }




        let index = this.getEmpty()
        let index2 = index
        let topColor = selectItem.getTopColor()
        let topColorlength = topColor.length
        let topColorlength2 = topColorlength
        let colorId = selectItem.getTopColorId()
        clog.log(topColor, topColorlength);

        let endId = 0
        if (index2 >= topColorlength2) {
            endId = topColor[0] + topColorlength2 - 1
        } else {
            endId = topColor[0] + index2 - 1
        }
        clog.log(index2, topColorlength2, topColor[0], endId);

        switch (topColor[0]) {
            case 3:
                angle = 90 * direction * -1
                x2 = 196
                y2 = 295
                break
            case 2:
                angle = 80 * direction * -1
                x2 = 196
                y2 = 260
                break
            case 1:
                angle = 70 * direction * -1
                x2 = 190
                y2 = 228
                break
            case 0:
                angle = 60 * direction * -1
                x2 = 180
                y2 = 197
                break
        }

        if (direction == 1) {
            x *= -1
            x2 *= -1
            if (this.node.parent.y < selectItem.node.parent.y - y) {
                angle2 = -10
                y = y2
            }

        } else if (direction == -1) {
            if (this.node.parent.y < selectItem.node.parent.y - y) {
                angle2 = 10
                y = y2
            }
        }

        let moveFun = () => {
            return new Promise((resolve, reject) => {


                cc.tween(otherNode)
                    .to(time, { angle: angle2, x: this.node.parent.x + x, y: this.node.parent.y + y })//移动到指定位置
                    .call(async () => {
                        await selectItem.incline(topColor[0], direction, 1)//倾斜
                        await selectItem.reduceWater(topColor[0], endId, direction, this.block)//倒水瓶子水减少




                        resolve(true)
                    })
                    .to(this.inclineTime, { angle: angle, x: this.node.parent.x + x2, y: this.node.parent.y + y2 })//旋转瓶身
                    .call(() => {
                        this.light.active = false
                        if (!GameControl.ints.lastBottle) {
                            GameControl.ints.lastBottle = { addBottle: null, reduceBottle: null, num: 0, coloId: ColorType.NONE }
                        }
                        GameControl.ints.lastBottle.addBottle = this
                        GameControl.ints.lastBottle.reduceBottle = selectItem
                        GameControl.ints.lastBottle.num = 0
                        GameControl.ints.lastBottle.coloId = colorId

                        let startId = -1
                        let endId2 = -1

                        this.top.children[0].active = true
                        this.top.children[0].getComponent(sp.Skeleton).setAnimation(0, 'huang', true)
                        for (let node of this.storeys) {
                            // clog.log(node);
                            if (node.active) {
                                node.children[0].children[0].active = true
                                let sp1 = node.children[0].children[0].getComponent(sp.Skeleton)
                                if (sp1) {
                                    sp1.setAnimation(0, 'huang', true)
                                }
                                break
                            }
                        }

                        for (let i = 3; i >= 0; i--) {
                            if (this._data[i][0] == 0) {
                                if (startId == -1) startId = i
                                this.addWater(i, colorId, this.pourWaterTime * (endId - topColor[0] + 1))
                                index--
                                topColorlength--
                                GameControl.ints.lastBottle.num++
                            }

                            if (index <= 0 || topColorlength <= 0) {
                                endId2 = i
                                break
                            }
                        }




                        // this.node.parent.parent = GameControl.ints.gameView.topMap
                        // this.node.parent.zIndex = 1
                        this.mask.enabled = true
                        this.column.scaleX = -0.7 * direction
                        this.column.active = true
                        this.column.children[0].color = cc.color().fromHEX(GameControl.ints.colorList[colorId].dark)
                        this.column.children[1].color = this.column.children[0].color
                        this.column.y = 514 // 水柱初始位置
                        let startScaleY = 0
                        let endScaleY = 0
                        clog.log(startId, endId2);

                        switch (startId) {
                            case 3:
                                startScaleY = 1.08
                                break
                            case 2:
                                startScaleY = 0.95
                                break
                            case 1:
                                startScaleY = 0.81
                                break
                            case 0:
                                startScaleY = 0.67
                                break

                        }

                        switch (endId2) {
                            case 3:
                                endScaleY = 0.81
                                break
                            case 2:
                                endScaleY = 0.67
                                break
                            case 1:
                                endScaleY = 0.53
                                break
                            case 0:
                                endScaleY = 0.4
                                break
                        }


                        this.column.scaleY = startScaleY
                        cc.tween(this.column)
                            .to(this.pourWaterTime * (endId - topColor[0] + 1), { y: 455, scaleY: endScaleY })
                            .start()


                    })
                    .start()


            })
        }
        await moveFun()
        this.setOpening()
        selectItem.setOpening()
        this.isComplete()
        if (this._data.complete == 1) {
            this.cover()
        } else {
            this.isPourWater = false
        }
        selectItem.incline(endId, direction, 2)//水回正


        this.block.parent = GameControl.ints.gameView.mapNode
        this.block.zIndex = this._zIndex
        this.top.children[0].active = false
        for (let node of this.storeys) {
            node.children[0].children[0].active = false
        }
        this.mask.enabled = false
        this.column.active = false
        GameControl.ints.gameView.disturbInspect()
        this.top.children[0].active = false

        for (let i = 0; i < 4; i++) {
            this.storeyColors[i].children[0].active = false
        }

        cc.tween(otherNode)
            .to(this.inclineTime, { angle: 0, x: selectItem.block_pos.x, y: selectItem.block_pos.y })//倒水瓶子归位
            .call(() => {
                selectItem.isPourWater = false
                otherNode.parent = GameControl.ints.gameView.mapNode
                otherNode.zIndex = selectItem.zIndex
                selectItem.shadow.y = 25
                cc.tween(selectItem.shadow)
                    .to(0.05, { opacity: this._shadowOpacity, y: 25, x: -60 })
                    .call(() => {
                        StateControl.ints.playEffect('放下')
                        selectItem.node.on(cc.Node.EventType.TOUCH_START, selectItem.touchStart, selectItem);
                        // if (this._data.complete == 0) {
                        GameControl.ints.gameView.backInspect()
                        // }
                        GameControl.ints.gameView.saveData()

                    })
                    .start()
            })
            .start()



    }

    protected _riseY: number = 80
    /**瓶子1上升2下降 */
    clickBottle(direction: number) {
        let time = 0.2

        if (direction == 1) {
            this.mask.enabled = true
            cc.Tween.stopAllByTarget(this.light)
            this.light.opacity = 255
            this.light.active = true
            this._lightForever.start()
            StateControl.ints.playEffect('点击水瓶')
            this.top.children[0].active = true
            this.top.children[0].getComponent(sp.Skeleton).setAnimation(0, 'huang', true)

            for (let node of this.storeys) {
                if (node.active) {
                    node.children[0].children[0].active = true
                    let sp1 = node.children[0].children[0].getComponent(sp.Skeleton)
                    if (sp1) {
                        sp1.setAnimation(0, 'huang', true)
                    }
                    break
                }

            }


            cc.tween(this.shadow)
                .to(time, { opacity: 0, y: -60, x: -240 }, cc.easeOut(3.0))
                .delay(.5)
                .call(() => {
                    this.top.children[0].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
                    this.top.children[0].active = false
                    for (let node of this.storeys) {
                        node.children[0].children[0].active = false

                    }
                    if (!this._isPourWater) {
                        this.mask.enabled = false
                    }
                    this.block.parent = GameControl.ints.gameView.topMap
                    this.block.zIndex = 10

                })
                .start()
            cc.tween(this.node)
                .to(time, { y: this._riseY }, cc.easeOut(3.0))
                .start()
        } else {

            this.light.active = false
            this.block.parent = GameControl.ints.gameView.mapNode
            this.block.zIndex = this._zIndex
            cc.tween(this.shadow)
                // .delay(0.15)
                .to(time, { opacity: this._shadowOpacity, y: 25, x: -60 })
                .start()

            cc.tween(this.node)
                // .to(0.15, { y: this.node.y + 30 })
                .to(time, { y: 0 })
                .call(() => {
                    StateControl.ints.playEffect('放下')
                    this.top.children[0].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
                    this.top.children[0].active = false
                    for (let node of this.storeys) {
                        node.children[0].children[0].active = false

                    }
                    if (!this._isPourWater) {
                        this.mask.enabled = false
                    }
                    // for (let node of this.storeys) {
                    //     let sp1 = node.children[0].children[0].getComponent(sp.Skeleton)
                    //     if (sp1) {
                    //         sp1.setAnimation(0, 'idle', true)
                    //     }
                    // }
                })
                .start()
        }

    }


    /**倾斜，type=1倒下=2立起 */
    incline(endId: number, direction: number, type: number) {
        return new Promise(async (resolve, reject) => {
            let arr = []



            this.mask.enabled = true

            let angle/*  */ = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
            let x/*      */ = [0, 28, 56, 80, 99, 110, 117, 118, 111, 80, 100]
            let y/*      */ = [0, 0, 10, 23, 46, 73, 95, 123, 142, 158, 165]
            let scaleX/* */ = [1, 1.3, 1.6, 1.8, 2, 2.1, 2.2, 2.3, 2.3, 2.3, 2.3]
            let scaleY/* */ = [1, 1, 0.94, 0.9, 0.85, 0.8, 0.75, 0.7, 0.6, 0.4, 0.45]

            let endIndex = 0
            switch (endId) {
                case 3:
                    endIndex = 10
                    break
                case 2:
                    endIndex = 9
                    break
                case 1:
                    endIndex = 8
                    break
                case 0:
                    endIndex = 7
                    break
            }
            for (let i = 0; i < endIndex; i++) {
                if (type == 1) {
                    arr.push(i)
                } else {
                    arr.push(endIndex - i - 1)
                }

            }
            let fun = (index: number) => {
                console.log("倾斜调试", index, "层:", arr[index], "角度:", angle[arr[index]] * direction, "X:", x[arr[index]] * direction, "Y:", y[arr[index]], "scaleX:", scaleX[arr[index]], "scaleY:", scaleY[arr[index]]);

                cc.tween(this.waterNode)
                    .delay(this.inclineTime / endIndex * index)
                    .to(this.inclineTime / endIndex, { angle: angle[arr[index]] * direction, x: x[arr[index]] * direction, y: y[arr[index]], scaleX: scaleX[arr[index]], scaleY: scaleY[arr[index]] })
                    .call(() => {


                        if (index == endIndex - 1) {
                            if (type == 2) {
                                this.blackUnlock()
                                this.mask.enabled = false
                            }
                            resolve(true)
                        }
                    })
                    .start()
            }

            for (let i = 0; i < endIndex; i++) {
                fun(i)
            }

        })
    }

    /**加水 */
    addWater(id: number, color: number, time: number = 0) {
        let pourWaterTime = this.pourWaterTime
        if (time != 0) pourWaterTime = time
        clog.log(pourWaterTime, time)
        this.storeys[id].height = 0
        this.storeys[id].active = true
        this.storeyColors[id].color = cc.color().fromHEX(GameControl.ints.colorList[color].dark)
        this.top.color = cc.color().fromHEX(GameControl.ints.colorList[color].bleak)
        this.storeyColors[id].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[color].dark)
        this.top.children[0].color = cc.color().fromHEX(GameControl.ints.colorList[color].bleak)

        this.storeys[id].y = 210 - id * 60
        this._data[id][0] = color
        this.top.parent.active = true
        let height = this.blockHeight

        cc.tween(this.storeys[id])
            .to(pourWaterTime, { height: height })
            .call(() => {

            })
            .start()
    }
    /**回退操作mask */
    async enabledMask(time: number = 0) {
        let pourWaterTime = this.pourWaterTime
        if (time != 0) pourWaterTime = time
        await DateControl.ints.Delay(pourWaterTime)
        this.mask.enabled = false
    }

    /**减水 */
    reduceWater(starId: number, endId: number, direction: number, otherNode: cc.Node) {
        return new Promise((resolve, reject) => {


            this.column2.active = true
            this.column2.scaleX = direction
            this.column2.children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].dark)
            this.column2.children[1].color = cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].dark)



            let endIndex = endId
            let angle/*  */ = [70, 80, 90, 100]
            let x/*      */ = [118, 111, 80, 100]
            let y/*      */ = [123, 142, 158, 165]
            let scaleX/* */ = [2.3, 2.3, 2.3, 2.3]
            let scaleY/* */ = [0.7, 0.6, 0.4, 0.45]

            let fun = (index: number) => {
                cc.tween(this.waterNode)
                    .delay(this.pourWaterTime / endIndex * index * (endId - starId + 1))
                    .to(this.pourWaterTime / endIndex * (endId - starId + 1), { angle: angle[index + 1] * direction, x: x[index + 1] * direction, y: y[index + 1], scaleX: scaleX[index + 1], scaleY: scaleY[index + 1] })

                    .call(() => {

                        clog.log(index, endIndex - 1);


                    })
                    .start()
            }
            clog.log(endIndex);
            if (endIndex == 1 || endIndex == 0) {
                StateControl.ints.playEffect('倒水1')
            } else if (endIndex == 2) {
                StateControl.ints.playEffect('倒水2')
            } else if (endIndex == 3) {
                StateControl.ints.playEffect('倒水3')
            }

            for (let i = 0; i < endIndex; i++) {
                fun(i)
            }









            let x2 = [190, 196, 196, 188]
            let y2 = [196, 228, 262, 295]
            cc.tween(this.block)
                .to(this.pourWaterTime * (endId - starId + 1), { angle: angle[endIndex] * direction * -1, x: otherNode.x + x2[endIndex] * direction * -1, y: otherNode.y + y2[endIndex] })
                .call(() => {
                    if (this.getEmpty() != 4) {
                        this.top.color = cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].bleak)
                        this.top.children[0].color = cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].bleak)
                    } else {
                        this.top.parent.active = false
                    }
                    this.column2.active = false
                    resolve(true)
                })
                .start()


            for (let i = starId; i <= endId; i++) {
                this._data[i][0] = 0
                cc.tween(this.storeys[i])
                    .to(this.pourWaterTime * (endId - starId + 1), { height: 0 })
                    .call(() => {
                        this.storeys[i].active = false
                    })
                    .start()
            }


            if (this.getEmpty() != 4) {
                cc.tween(this.top)
                    .delay(this.pourWaterTime * (3 / 4) * (endId - starId + 1))
                    .to(this.pourWaterTime * (1 / 4) * (endId - starId + 1), { color: cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].bleak) })
                    .call(() => {

                    })
                    .start()
                cc.tween(this.top.children[0])
                    .delay(this.pourWaterTime * (3 / 4) * (endId - starId + 1))
                    .to(this.pourWaterTime * (1 / 4) * (endId - starId + 1), { color: cc.color().fromHEX(GameControl.ints.colorList[this.getTopColorId()].bleak) })
                    .call(() => {

                    })
                    .start()
            }


        })

    }




    adTouchStart(event: cc.Event.EventTouch) {
        if (this._data.ad == 1) {
            GameControl.ints.gameView.finger.active = false
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1.2 })
                .start()
        }

    }

    adTouchEnd() {
        if (this._data.ad == 1) {
            StateControl.ints.playEffect('btn_0')
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()


            if (GameControl.ints.useProp) {
                ViewControl.ints.showTip('正在使用道具')
                return
            }
            GameControl.ints.useProp = true

            let data = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                pos_ext: '主关卡',
                pos_sub_ext: ZTSDKControl.ints.version,
                why: '解锁空瓶',
                pos_index: GameControl.ints.gameView.data.level + 1,
            }
            ZTSDKControl.ints.onAdRequest(data);


            ADControl.ints.showVideo({
                successFun: () => {


                    this.node.off(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
                    this.node.off(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
                    this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
                    this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
                    GameControl.ints.gameView.finger.active = false
                    this.video.active = false
                    this._data.ad = 0
                    this.openCover()
                    GameControl.ints.gameView.saveData()
                    ZTSDKControl.ints.onAdFinish(data);
                },
                closeFun: () => {
                    GameControl.ints.useProp = false
                    ZTSDKControl.ints.onAdCancel(data);
                }
            })
            return
        }
    }

    adTouchCancel() {
        if (this._data.ad == 1) {
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()
        }
    }

    touchStart(event: cc.Event.EventTouch) {
        ADControl.ints.checkFeedSubscribeStatus()
        clog.log(this._data);
        GameControl.ints.gameView.showFinger()

        if (this._data.lock[0]) {

            let txt = GameControl.ints.getTipLab(this._data.lock[0], this._data.lock[1])

            ViewControl.ints.showTip(txt)
        }
        if ((this._data.complete == 1 || this.getEmpty() == 4 && GameControl.ints.selectItem == null) && this._data.ad != 1 && !this._isPourWater) {
            if (this._data.complete == 1) {
                StateControl.ints.playEffect('装满水瓶')
            } else if (this.getEmpty() == 4) {
                StateControl.ints.playEffect('空玻璃瓶')
            }
            cc.Tween.stopAllByTarget(this.node)

            cc.tween(this.node)
                .to(0.05, { angle: -5 })
                .to(0.05, { angle: 5 })
                .to(0.05, { angle: -5 })
                .to(0.05, { angle: 0 })
                .call(() => {
                })
                .start()

            return
        }
        if (GuideControl.ints.guide[1] == 3) {
            GuideControl.ints.closeGuide()
        }
        if (GuideControl.ints.guide[1] == 2) {
            let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[1].node.parent, GameControl.ints.gameView.node)
            pos.y += 105
            let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
            let txt = '倒入同色水中'
            if (window['__guide'] == 2) {
                txt = '倒入空瓶中'
            }
            GuideControl.ints.showGuide({ type: 1, pos: pos, tipePos, width: 100, height: 215, id: 1, txt })
        }
        // if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 6) {
        //     GuideControl.ints.closeGuide()
        // }
        // if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 5) {
        //     let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[0].node.parent, GameControl.ints.gameView.node)
        //     pos.y += 100
        //     let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
        //     GuideControl.ints.showGuide({ type: 1, pos, tipePos, width: 100, height: 215, id: 1, txt: '可以倒入空瓶' })

        // }




        clog.log(this.isPourWater, this._data.complete, this.getEmpty() == 4, this._data.lock[0], GameControl.ints.loadGameOver);
        if (!GameControl.ints.loadGameOver) return
        if (GameControl.ints.useProp && this.disturb.active) {
            this.disturbAn()
            return
        }



        if (GameControl.ints.useProp && !this.disturb.active) {
            return
        }


        if (this.isPourWater || this._data.complete == 1 || (this.getEmpty() == 4 && GameControl.ints.selectItem == null) || this._data.lock[0]) return

        if (GameControl.ints.selectItem == null) {
            GameControl.ints.selectItem = this
            cc.Tween.stopAllByTarget(this.node)
            cc.Tween.stopAllByTarget(this.shadow)
            this.clickBottle(1)
        } else if (GameControl.ints.selectItem == this) {
            cc.Tween.stopAllByTarget(this.node)
            cc.Tween.stopAllByTarget(this.shadow)
            this.clickBottle(2)
            GameControl.ints.selectItem = null
        } else if (GameControl.ints.selectItem != this) {



            if ((this.getTopColorId() == GameControl.ints.selectItem.getTopColorId() && this.getEmpty() != 0) || this.getEmpty() == 4) {
                this.isPourWater = true
                GameControl.ints.selectItem.isPourWater = true
                GameControl.ints.selectItem.node.off(cc.Node.EventType.TOUCH_START, GameControl.ints.selectItem.touchStart, GameControl.ints.selectItem);

                this.pourWater(GameControl.ints.selectItem)

            } else {
                clog.log('落下2', this.getTopColorId(), GameControl.ints.selectItem.getTopColorId(), this.getEmpty())
                cc.Tween.stopAllByTarget(GameControl.ints.selectItem.node)
                cc.Tween.stopAllByTarget(GameControl.ints.selectItem.shadow)
                GameControl.ints.selectItem.clickBottle(2)
                GameControl.ints.selectItem = this
                this.clickBottle(1)
            }



        }

    }

    // update (dt) {}
}
