import ADControl from "../../adSdk/ADControl";
import ZTSDKControl from "../../adSdk/ZTSDKControl";
import DateControl from "../../manage/control/controlData/DateControl";
import GameControl, { BottleData, ColorType } from "../../manage/control/controlData/GameControl";
import GuideControl from "../../manage/control/controlData/GuideControl";
import NodeControl from "../../manage/control/controlNode/NodeControl";
import EventControl from "../../manage/control/event/EventControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { EventName } from "../../manage/enum/EventEnum";
import ArrayUtil from "../../manage/utils/ArrayUtil";
import bottle from "./bottle";

const { ccclass, property } = cc._decorator;

@ccclass
export default class bottle2 extends bottle {




    // @property(cc.Node)
    // top: cc.Node = null;
    // @property(cc.Mask)
    // mask: cc.Mask = null;
    // @property(cc.Node)
    // waterNode: cc.Node = null;
    // @property(cc.Node)
    // plug: cc.Node = null;
    // @property(cc.Node)
    // video: cc.Node = null;

    // @property(cc.Node)
    // lock: cc.Node = null;
    // @property(cc.Label)
    // lockNum: cc.Label = null;

    // @property(cc.Node)
    // shadow: cc.Node = null;
    // @property(cc.Node)
    // column: cc.Node = null;
    // @property(cc.Node)
    // column2: cc.Node = null;
    // @property(cc.Node)
    // disturb: cc.Node = null;
    // @property(cc.Node)
    // appear: cc.Node = null;
    // @property(cc.Node)
    // lockColor: cc.Node = null;
    // @property(cc.Node)
    // brand: cc.Node = null;

    // @property(cc.Node)
    // blast: cc.Node = null;
    // @property(cc.Node)
    // light: cc.Node = null;

    // @property(cc.ParticleSystem)
    // ParticleAsset: cc.ParticleSystem = null;

    // @property([cc.Node])
    // storeys: cc.Node[] = [];
    // @property([cc.Node])
    // storeyColors: cc.Node[] = [];

    @property([cc.SpriteFrame])
    icons: cc.SpriteFrame[] = [];


    protected _data: BottleData = null
    protected blockHeight: number = -1000
    protected _lockScale: number = 0

    /**瓶子是否可以箱子操作 */
    public isOperate: boolean = true

    /**瓶子是否正在倒水 */
    public _isPourWater: boolean = false



    block_pos: cc.Vec2 = null

    protected _index: number = 0

    get isPourWater() {
        return this._isPourWater
    }
    set isPourWater(value: boolean) {
        if (value) {
            GameControl.ints.operate = 1
        } else {
            GameControl.ints.operate = -1
        }

        this._isPourWater = value
    }

    get data() {
        return this._data
    }

    get index() {
        return this._index
    }
    /**是否已经完成 */
    get complete() {
        return this._data.complete == 1
    }


    protected _zIndex: number = -1


    get zIndex() {
        return this._zIndex
    }

    protected _lightForever: cc.Tween = null

    private storeysPos: cc.Vec2[] = []

    private _storeysTopPos: cc.Vec2[] = []

    get storeysTopPos() {
        return this._storeysTopPos
    }


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        cc.tween(this.brand)
            .to(2, { angle: -5 })
            .to(2, { angle: 5 })
            .union()
            .repeatForever()
            .start()
        this._lightForever = cc.tween(this.light)
            .to(2, { opacity: 0 })
            .to(2, { opacity: 255 })
            .union()
            .repeatForever()
            .start()


    }

    setData(_data: BottleData, index: number) {
        this.off()
        this._index = index
        this._data = _data
        this.block_pos = GameControl.ints.getPos(this._data.pos)
        this._zIndex = -1
        if (this.storeysPos.length == 0) {
            for (let i = 0; i < this.storeys.length; i++) {
                this.storeysPos[i] = cc.v2(0, 0)
                this.storeysPos[i].y = 257 - i * 87
                this._storeysTopPos[i] = cc.v2(0, 0)
                this._storeysTopPos[i].y = 375 + i * 77
            }

        }
        if (this._data.ad == 1) {
            this.node.on(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
            this.node.on(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
            this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
        } else {
            this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
        }




        this.initData()
    }

    off() {
        this.node.off(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
        this.node.off(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
        this.node.off(cc.Node.EventType.TOUCH_START, this.touchStart, this);
    }

    showBlock() {
        // for (let i = 0; i < 4; i++) {

        //     if (this._data[i][0] == ColorType.NONE) {
        //         this.storeys[i].active = false
        //         this.storeys[i].children[1].active = false
        //     } else {
        //         GameControl.ints.bottleBlockNum++
        //         if (!GameControl.ints.colorNum[this._data[i][0]]) GameControl.ints.colorNum[this._data[i][0]] = 0
        //         GameControl.ints.colorNum[this._data[i][0]]++
        //         this.storeys[i].active = true
        //         if (this.blockHeight != -1000) {
        //             this.storeys[i].height = this.blockHeight
        //         }
        //         if (this._data[i][1] == 1) {
        //             this.storeys[i].children[1].active = true
        //             // this.storeys[i].children[1].getComponent(cc.Sprite).enabled = false

        //         } else {
        //             if (this._data[i][0] != 0) {
        //                 this.storeyColors[i].getComponent(cc.Sprite).spriteFrame = this.icons[this._data[i][0]]

        //             }

        //         }

        //     }
        // }
        // this.lock.opacity = 150
    }

    initData() {



        this.blast.active = false
        this.node.parent.setPosition(this.block_pos)
        this.shadow.opacity = 255
        this.shadow.x = -60
        this.shadow.y = 25
        this.isOperate = true
        this.ParticleAsset.resetSystem()
        this.ParticleAsset.node.active = false

        this._isPourWater = false
        this.light.active = false
        this.block.parent = GameControl.ints.gameView.mapNode
        if (this._zIndex == -1) this._zIndex = this._data.pos[1] * 50 + 50 - this._data.pos[0] * 2
        this.block.zIndex = this._zIndex
        this.block.name = this._zIndex + ''
        this.lockNum.node.x = 3
        for (let i = 0; i < 4; i++) {
            cc.Tween.stopAllByTarget(this.storeys[i])
            this.storeys[i].zIndex = 4 - (i + 1)
            this.storeys[i].setPosition(this.storeysPos[i])

            if (this._data[i][0] == ColorType.NONE) {
                this.storeys[i].active = false
                this.storeys[i].children[1].active = false
            } else {
                GameControl.ints.bottleBlockNum++
                if (!GameControl.ints.colorNum[this._data[i][0]]) GameControl.ints.colorNum[this._data[i][0]] = 0
                GameControl.ints.colorNum[this._data[i][0]]++
                this.storeys[i].active = true
                if (this.blockHeight != -1000) {
                    this.storeys[i].height = this.blockHeight
                }

                if (this._data[i][1] == 1) {
                    this.storeys[i].children[1].active = true
                    this.storeys[i].children[1].getComponent(cc.Sprite).enabled = true
                    // this.storeyColors[i].color = cc.color().fromHEX('#000000')
                    // this.storeyColors[i].children[0].color = cc.color().fromHEX('#000000')

                } else {
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].getComponent(cc.Sprite).spriteFrame = this.icons[this._data[i][0]]
                    }
                    this.storeys[i].children[1].active = false

                }
                this.storeys[i].children[1].opacity = 255

            }
        }



        this.node.active = this._data.showBottle == 1
        this.video.active = this._data.ad == 1
        this.mask.enabled = false
        this.disturb.active = false
        this.appear.active = false
        this.waterNode.scale = 1
        this.block.scale = 1
        if (this.blockHeight == -1000) {
            this.blockHeight = this.storeys[3].height
        }

        if (this._data.ad == 1) {
            this.plug.y = 355
            this.plug.active = true

        } else {
            this.plug.active = this._data.complete == 1
        }
        if (this.plug.active) {
            this.plug.opacity = 255
        }

        this.lock.opacity = 255
        this.lock.active = this._data.lock[0] != 0
        if (this._lockScale == 0) this._lockScale = this.lock.scale
        this.lock.scale = this._lockScale

        if (this.lock.active && this._data.lock[0] != ColorType.BLACK) {

            this.lockColor.color = cc.color().fromHEX(GameControl.ints.colorList[this._data.lock[0]].dark)
        } else if (this.lock.active && this._data.lock[0] == ColorType.BLACK) {
            this.lockColor.color = cc.color().fromHEX('#FFFFFF')
        }


        this.lockNum.string = this._data.lock[1] + ''

    }
    /**锁定值减少 */
    async unlock() {
        return new Promise(async (resolve, reject) => {
            this._data.lock[1]--
            if (this._data.lock[1] == 0) this.lockNum.node.x = -5
            this.lockNum.string = this._data.lock[1] + ''
            let time = 0.3
            cc.tween(this.lockNum.node)
                .to(time / 2, { scale: 1.4 })
                .to(time / 2, { scale: 1 })
                .call(() => {

                })
                .start()


            if (this._data.lock[1] <= 0) {
                this._data.lock[0] = 0
                resolve(true)
                await DateControl.ints.Delay(time)
                this.brand.angle = 0
                this.ParticleAsset.node.active = true
                this.block.parent = GameControl.ints.gameView.topMap
                this.block.zIndex = 1
                cc.tween(this.lock)
                    .to(0.2, { scale: 0 })
                    .delay(1)
                    .call(() => {
                        this.block.parent = GameControl.ints.gameView.mapNode
                        this.block.zIndex = this._zIndex
                    })
                    .start()
            }
            resolve(false)
        })

    }



    /**盖瓶子 */
    cover() {
        this.plug.active = true
        this.plug.opacity = 0
        this.plug.y = 435
        let thar = this

        cc.tween(this.plug)
            .to(0.3, { opacity: 255, y: 355 })
            .call(() => {
                StateControl.ints.playEffect('塞瓶盖')
                EventControl.ints.emit(EventName.BoxInspect, thar)
            })
            .start()
    }

    /**开瓶子 */
    openCover() {
        this.appear.active = true
        this.appear.getComponent(sp.Skeleton).setCompleteListener(() => {
            this.appear.active = false
        })
        this.appear.getComponent(sp.Skeleton).setAnimation(0, 'guang', false)

        this.plug.active = true
        this.plug.opacity = 255
        this.plug.y = 355
        this._isPourWater = true
        cc.tween(this.node)
            .to(0.1, { scaleY: 0.5 })
            .call(() => {
                StateControl.ints.playEffect('解锁')
            })
            .to(0.1, { scaleY: 0.55 })
            .call(() => {

                cc.tween(this.plug)
                    .to(0.2, { opacity: 200, y: 500 })
                    .to(0.2, { opacity: 0, y: 500 })
                    .call(() => {
                        this._isPourWater = false
                    })
                    .start()

            })
            .start()


    }




    /**获得是否可以打乱 */
    getDisturb(showTip: boolean) {
        if (this._data.lock[0] != 0 || this._data.ad == 1) return
        let can = false
        let colorId = -1
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0 && this._data[i][1] == 1) {
                can = true
                break
            }
            if (this._data[i][0] != 0 && colorId == -1) {
                colorId = this._data[i][0]
            }
            if (this._data[i][0] != 0 && this._data[i][0] != colorId) {
                can = true
                break
            }
        }

        return can
    }

    setDisturb() {
        this.disturb.active = true
    }
    /**打乱动画 */
    disturbAn() {
        let lastBottle = GameControl.ints.lastBottle
        if (lastBottle) {
            if (lastBottle.addBottle == this) {
                GameControl.ints.lastBottle = null
                GameControl.ints.gameView.backInspect()
            }
        }
        GameControl.ints.gameView.restoreDisturb()
        StateControl.ints.playEffect('乱序')
        let data: Record<number, number[]> = {}
        let data2: Record<number, number[]> = {}
        let arr: number[] = []


        for (let i = 3; i >= this.getEmpty(); i--) {
            arr.push(i)
            if (!data2[i]) data2[i] = []
            data2[i][0] = this.data[i][0]
            data2[i][1] = this.data[i][1]
        }
        ArrayUtil.shuffle(arr)
        for (let i = 0; i < arr.length; i++) {
            this.data[3 - i][0] = data2[arr[i]][0]
            this.data[3 - i][1] = data2[arr[i]][1]
        }


        for (let i = 3; i >= this.getEmpty(); i--) {
            if (!data[i]) data[i] = []
            data[i][0] = this.data[i][0]
            data[i][1] = this.data[i][1]
        }



        let index = 0
        let fun = () => {
            index++
            for (let i = 3; i >= this.getEmpty(); i--) {
                let datai = i - 1
                if (i <= this.getEmpty()) {
                    datai = 3
                }
                data2[i][0] = data[datai][0]
                data2[i][1] = data[datai][1]
            }

            for (let i = 3; i >= this.getEmpty(); i--) {
                data[i][0] = data2[i][0]
                data[i][1] = data2[i][1]
            }
            // clog.log(data2);


            let fun2 = (data3) => {

                for (let i = 3; i >= this.getEmpty(); i--) {

                    this.storeyColors[i].getComponent(cc.Sprite).spriteFrame = this.icons[data3[i][0]]


                    if (data3[i][1] == 1) {
                        this.storeys[i].children[1].active = true
                        this.storeys[i].children[1].opacity = 255
                        this.storeys[i].children[1].getComponent(cc.Sprite).enabled = true


                    } else if (data3[i][1] == 0) {

                        this.storeys[i].children[1].active = false
                    }
                }

            }
            fun2(data2)

            if (index >= 16) {
                fun2(this.data)

                for (let i = 0; i < 3; i++) {
                    if (this._data[i][0] != 0) {
                        if (this._data[i][1] == 1) {
                            this._data[i][1] = 0
                            this.storeys[i].children[1].active = false
                            if (this._data[i][0] != 0) {
                                this.storeyColors[i].getComponent(cc.Sprite).spriteFrame = this.icons[this._data[i][0]]
                            }
                        }

                        break
                    }
                }

                this.unschedule(fun)

            }

        }
        fun()
        let time = 0.02
        // if (arr.length == 2) time = 0.02
        this.schedule(fun, time)



    }

    /**是否已经完成 */
    isComplete() {
        let isComplete = 1
        let color = 0
        color = this._data[3][0]
        if (color == ColorType.NONE) return
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == ColorType.NONE || this._data[i][1] == 1 || color != this._data[i][0]) {
                isComplete = 0
                break
            }
        }

        this._data.complete = isComplete

    }
    /**黑色块解锁 */
    blackUnlock() {
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                if (this._data[i][1] == 1) {
                    this._data[i][1] = 0
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].getComponent(cc.Sprite).spriteFrame = this.icons[this._data[i][0]]
                    }
                    this.blast.active = true
                    this.blast.getComponent(sp.Skeleton).setAnimation(0, 'bao', false)
                    this.blast.getComponent(sp.Skeleton).setCompleteListener(() => {
                        this.blast.active = false
                    })
                    this.blast.y = this.storeys[i].y + 50
                    cc.tween(this.storeys[i].children[1])
                        .to(0.3, { opacity: 0 })
                        .start()

                }
                break
            }
        }
    }

    /**获得最上层颜色id */
    getTopColorId() {
        let colorId = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                colorId = this._data[i][0]
                break
            }
        }

        return colorId
    }
    /**获得上层空位有多少 */
    getEmpty() {
        let empty = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == 0) {
                empty++
            }
        }

        return empty
    }
    /**获得上层相同颜色层 */
    getTopColor(): number[] {
        let index = []
        let colorId = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                if (colorId == 0) colorId = this._data[i][0]
                if (this._data[i][0] == colorId && this._data[i][1] != 1) {
                    index.push(i)
                } else {
                    break
                }
            }
        }
        return index
    }

    /**倒水时长 */
    protected pourWaterTime: number = 0.2
    // /**倾斜时长 */
    // protected inclineTime: number = 0.3

    /**移动到瓶子位置 */
    async pourWater(selectItem: bottle) {
        GameControl.ints.selectItem = null
        selectItem.light.active = false

        this.block.parent = GameControl.ints.gameView.topMap
        this.block.zIndex = 10
        // let otherNode: cc.Node = selectItem.node.parent
        // otherNode.parent = GameControl.ints.gameView.topMap



        this.light.active = true
        cc.Tween.stopAllByTarget(this.light)
        this.light.opacity = 255

        let time = this.pourWaterTime//0.15






        let index = this.getEmpty()
        let index2 = index
        let topColor = selectItem.getTopColor()
        let topColorlength = topColor.length
        let topColorlength2 = topColorlength
        let colorId = selectItem.getTopColorId()
        clog.log(topColor, topColorlength);

        let endId = 0
        if (index2 >= topColorlength2) {
            endId = topColor[0] + topColorlength2 - 1
        } else {
            endId = topColor[0] + index2 - 1
        }
        clog.log(index2, topColorlength2, topColor[0], endId);



        if (!GameControl.ints.lastBottle) {
            GameControl.ints.lastBottle = { addBottle: null, reduceBottle: null, num: 0, coloId: ColorType.NONE }
        }
        GameControl.ints.lastBottle.addBottle = this
        GameControl.ints.lastBottle.reduceBottle = selectItem
        GameControl.ints.lastBottle.num = 0
        GameControl.ints.lastBottle.coloId = colorId
        let startId = -1
        let endId2 = -1

        for (let i = 3; i >= 0; i--) {
            if (this._data[i][0] == 0) {
                if (startId == -1) startId = i
                this._data[i][0] = colorId

                index--
                topColorlength--
                GameControl.ints.lastBottle.num++
            }

            if (index <= 0 || topColorlength <= 0) {
                endId2 = i
                break
            }
        }

        for (let i = topColor[0]; i <= endId; i++) {
            selectItem.data[i][0] = 0
        }






        if (startId - endId2 + 1 < topColor.length) {
            selectItem.clickBottle(2)
        }
        selectItem.isPourWater = false

        selectItem.blackUnlock()




        let moveFun = () => {
            return new Promise((resolve, reject) => {

                for (let i = 0; i < startId - endId2 + 1; i++) {

                    selectItem.storeys[topColor[i]].active = false
                    cc.Tween.stopAllByTarget(selectItem.storeys[topColor[i]])
                    let pos = NodeControl.ints.nodeConvertLocalPointAR(selectItem.block, this.node)
                    this.storeys[index2 - 1 - i].active = true
                    this.storeys[index2 - 1 - i].x = pos.x
                    this.storeys[index2 - 1 - i].y = pos.y + this._storeysTopPos[startId - endId2 - i].y
                    this.storeyColors[index2 - 1 - i].getComponent(cc.Sprite).spriteFrame = this.icons[colorId]
                    cc.tween(this.storeys[index2 - 1 - i])
                        .to(i * 0.05, { y: pos.y + this._storeysTopPos[startId - endId2].y })
                        .to(time + i * 0.05, { x: 0, y: this._storeysTopPos[startId - endId2].y })
                        .call(() => {
                            if (i == 0) {
                                this.light.active = false
                            }
                        })
                        .to(time, { y: this.storeysPos[index2 - 1 - i].y })
                        .call(() => {
                            if (i == startId - endId2) {
                                resolve(true)
                            }
                        })
                        .start()
                }


            })
        }
        await moveFun()

        this.isComplete()

        if (this._data.complete == 1) {

            this.cover()
        } else {
            this.isPourWater = false
        }

        this.block.parent = GameControl.ints.gameView.mapNode
        this.block.zIndex = this._zIndex
        // for (let node of this.storeys) {
        //     node.children[0].children[0].active = false
        // }
        this.mask.enabled = false
        GameControl.ints.gameView.disturbInspect()


        // if (this._data.complete == 0) {
        GameControl.ints.gameView.backInspect()
        // }
        GameControl.ints.gameView.saveData()

        // cc.tween(otherNode)
        //     .to(this.inclineTime, { angle: 0, x: selectItem.block_pos.x, y: selectItem.block_pos.y })//倒水瓶子归位
        //     .call(() => {
        //         selectItem.isPourWater = false
        //         otherNode.parent = GameControl.ints.gameView.mapNode
        //         otherNode.zIndex = selectItem.zIndex
        //         selectItem.shadow.y = 37
        //         cc.tween(selectItem.shadow)
        //             .to(0.05, { opacity: 255, y: 37, x: -60 })
        //             .call(() => {
        //                 StateControl.ints.playEffect('放下')

        //                 if (this._data.complete == 0) {
        //                     GameControl.ints.gameView.backInspect()
        //                 }
        //                 GameControl.ints.gameView.saveData()

        //             })
        //             .start()
        //     })
        //     .start()



    }

    protected _riseY: number = 80
    /**瓶子1上升2下降 */
    clickBottle(direction: number) {
        let time = 0.2

        if (direction == 1) {
            this.light.active = true
            this._lightForever.start()
            StateControl.ints.playEffect('点击水瓶')

            // this.node.parent.parent = GameControl.ints.gameView.topMap
            // this.node.parent.zIndex = 10

            let TopColor = this.getTopColor()
            for (let i = 0; i < TopColor.length; i++) {
                cc.Tween.stopAllByTarget(this.storeys[TopColor[i]])
                cc.tween(this.storeys[TopColor[i]])
                    .to(time + i * 0.05, { y: this._storeysTopPos[TopColor.length - 1 - i].y }, cc.easeOut(3.0))

                    .start()
            }

            // this.top.children[0].active = true
            // this.top.children[0].getComponent(sp.Skeleton).setAnimation(0, 'huang', true)

            // for (let node of this.storeys) {
            //     if (node.active) {
            //         node.children[0].children[0].active = true
            //         let sp1 = node.children[0].children[0].getComponent(sp.Skeleton)
            //         if (sp1) {
            //             sp1.setAnimation(0, 'huang', true)
            //         }
            //         break
            //     }

            // }


            // cc.tween(this.shadow)
            //     .to(time, { opacity: 0, y: -60, x: -240 }, cc.easeOut(3.0))
            //     .delay(.5)
            //     .call(() => {
            //         this.top.children[0].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
            //         this.top.children[0].active = false
            //         for (let node of this.storeys) {
            //             node.children[0].children[0].active = false

            //         }
            //         if (!this._isPourWater) {
            //             this.mask.enabled = false
            //         }
            //         this.node.parent.parent = GameControl.ints.gameView.topMap
            //         this.node.parent.zIndex = 10

            //     })
            //     .start()
            // cc.tween(this.node)
            //     .to(time, { y: this._riseY }, cc.easeOut(3.0))
            //     .start()
        } else {

            this.light.active = false
            this.block.parent = GameControl.ints.gameView.mapNode
            this.block.zIndex = this._zIndex

            let TopColor = this.getTopColor()
            for (let i = TopColor.length - 1; i >= 0; i--) {
                cc.Tween.stopAllByTarget(this.storeys[TopColor[i]])
                cc.tween(this.storeys[TopColor[i]])
                    .to(time + (TopColor.length - 1 - i) * 0.05, { y: this.storeysPos[TopColor[i]].y })
                    .start()
            }

            // cc.tween(this.shadow)
            //     // .delay(0.15)
            //     .to(time, { opacity: 255, y: 37, x: -60 })
            //     .start()

            // cc.tween(this.node)
            //     // .to(0.15, { y: this.node.y + 30 })
            //     .to(time, { y: 0 })
            //     .call(() => {
            //         StateControl.ints.playEffect('放下')
            //         for (let node of this.storeys) {
            //             node.children[0].children[0].active = false

            //         }
            //         if (!this._isPourWater) {
            //             this.mask.enabled = false
            //         }

            //     })
            //     .start()
        }

    }


    ///**倾斜，type=1倒下=2立起 */
    // incline(endId: number, direction: number, type: number) {
    //     return new Promise(async (resolve, reject) => {
    //         let arr = []



    //         this.mask.enabled = true

    //         let angle/*  */ = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
    //         let x/*      */ = [0, 28, 56, 80, 99, 110, 117, 118, 111, 80, 100]
    //         let y/*      */ = [0, 0, 10, 23, 46, 73, 95, 123, 142, 158, 165]
    //         let scaleX/* */ = [1, 1.3, 1.6, 1.8, 2, 2.1, 2.2, 2.3, 2.3, 2.3, 2.3]
    //         let scaleY/* */ = [1, 1, 0.94, 0.9, 0.85, 0.8, 0.75, 0.7, 0.6, 0.4, 0.45]

    //         let endIndex = 0
    //         switch (endId) {
    //             case 3:
    //                 endIndex = 10
    //                 break
    //             case 2:
    //                 endIndex = 9
    //                 break
    //             case 1:
    //                 endIndex = 8
    //                 break
    //             case 0:
    //                 endIndex = 7
    //                 break
    //         }
    //         for (let i = 0; i < endIndex; i++) {
    //             if (type == 1) {
    //                 arr.push(i)
    //             } else {
    //                 arr.push(endIndex - i - 1)
    //             }

    //         }
    //         let fun = (index: number) => {
    //             cc.tween(this.waterNode)
    //                 .delay(this.inclineTime / endIndex * index)
    //                 .to(this.inclineTime / endIndex, { angle: angle[arr[index]] * direction, x: x[arr[index]] * direction, y: y[arr[index]], scaleX: scaleX[arr[index]], scaleY: scaleY[arr[index]] })
    //                 .call(() => {


    //                     if (index == endIndex - 1) {
    //                         if (type == 2) {
    //                             this.blackUnlock()
    //                             this.mask.enabled = false
    //                         }
    //                         resolve(true)
    //                     }
    //                 })
    //                 .start()
    //         }

    //         for (let i = 0; i < endIndex; i++) {
    //             fun(i)
    //         }

    //     })
    // }

    // /**加水 */
    // addWater(id: number, color: number) {

    //     this.storeys[id].height = 0
    //     this.storeys[id].active = true
    //     this.storeyColors[id].color = cc.color().fromHEX(GameControl.ints.colorList[color].dark)
    //     this.storeyColors[id].children[0].color = cc.color().fromHEX(GameControl.ints.colorList[color].dark)
    //     this.storeys[id].y = 210 - id * 60
    //     this._data[id][0] = color
    //     let height = this.blockHeight

    //     cc.tween(this.storeys[id])
    //         .to(this.pourWaterTime, { height: height })
    //         .call(() => {

    //         })
    //         .start()
    // }
    ///**回退操作mask */
    // async enabledMask() {
    //     await DateControl.ints.Delay(this.pourWaterTime)
    //     this.mask.enabled = false
    // }

    // /**减水 */
    // reduceWater(starId: number, endId: number, direction: number, otherNode: cc.Node) {
    //     return new Promise((resolve, reject) => {





    //         let endIndex = endId
    //         let angle/*  */ = [70, 80, 90, 100]
    //         let x/*      */ = [118, 111, 80, 100]
    //         let y/*      */ = [123, 142, 158, 165]
    //         let scaleX/* */ = [2.3, 2.3, 2.3, 2.3]
    //         let scaleY/* */ = [0.7, 0.6, 0.4, 0.45]

    //         let fun = (index: number) => {
    //             cc.tween(this.waterNode)
    //                 .delay(this.pourWaterTime / endIndex * index)
    //                 .to(this.pourWaterTime / endIndex, { angle: angle[index + 1] * direction, x: x[index + 1] * direction, y: y[index + 1], scaleX: scaleX[index + 1], scaleY: scaleY[index + 1] })

    //                 .call(() => {

    //                     clog.log(index, endIndex - 1);


    //                 })
    //                 .start()
    //         }
    //         clog.log(endIndex);
    //         if (endIndex == 1 || endIndex == 0) {
    //             StateControl.ints.playEffect('倒水1')
    //         } else if (endIndex == 2) {
    //             StateControl.ints.playEffect('倒水2')
    //         } else if (endIndex == 3) {
    //             StateControl.ints.playEffect('倒水3')
    //         }

    //         for (let i = 0; i < endIndex; i++) {
    //             fun(i)
    //         }









    //         let x2 = [190, 196, 196, 188]
    //         let y2 = [196, 228, 262, 295]
    //         cc.tween(this.block)
    //             .to(this.pourWaterTime, { angle: angle[endIndex] * direction * -1, x: otherNode.x + x2[endIndex] * direction * -1, y: otherNode.y + y2[endIndex] })
    //             .call(() => {

    //                 resolve(true)
    //             })
    //             .start()


    //         for (let i = starId; i <= endId; i++) {
    //             this._data[i][0] = 0
    //             cc.tween(this.storeys[i])
    //                 .to(this.pourWaterTime, { height: 0 })
    //                 .call(() => {
    //                     this.storeys[i].active = false
    //                 })
    //                 .start()
    //         }





    //     })

    // }




    adTouchStart(event: cc.Event.EventTouch) {
        if (this._data.ad == 1) {
            GameControl.ints.gameView.finger.active = false
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1.2 })
                .start()
        }

    }

    adTouchEnd() {
        if (this._data.ad == 1) {
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()
                
            if (GameControl.ints.useProp) {
                ViewControl.ints.showTip('正在使用道具')
                return
            }
            GameControl.ints.useProp = true

            let data = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                pos_ext: '主关卡',
                pos_sub_ext: ZTSDKControl.ints.version,
                why: '解锁空瓶',
                pos_index: GameControl.ints.gameView.data.level + 1,
            }
            ZTSDKControl.ints.onAdRequest(data);


            StateControl.ints.playEffect('btn_0')
            ADControl.ints.showVideo({
                successFun: () => {

                    this.node.off(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
                    this.node.off(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
                    this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
                    this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
                    GameControl.ints.gameView.finger.active = false
                    this.video.active = false
                    this._data.ad = 0
                    this.openCover()
                    GameControl.ints.gameView.saveData()
                    ZTSDKControl.ints.onAdFinish(data);
                },
                closeFun: () => {
                    GameControl.ints.useProp = false
                    ZTSDKControl.ints.onAdCancel(data);
                }
            })
            return
        }
    }

    adTouchCancel() {
        if (this._data.ad == 1) {
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()
        }
    }

    async touchStart(event: cc.Event.EventTouch) {
        ADControl.ints.checkFeedSubscribeStatus()
        clog.log(this._data);
        GameControl.ints.gameView.tipTime = 0
        if (this._data.lock[0]) {
            let color = ''
            clog.log(this._data.lock[0]);

            switch (this._data.lock[0]) {
                case 1:
                    color = '瓶红色'
                    break
                case 2:
                    color = '瓶绿色'
                    break
                case 3:
                    color = '瓶青色'
                    break
                case 4:
                    color = '瓶黄色'
                    break
                case 5:
                    color = '瓶紫色'
                    break
                case 6:
                    color = '瓶橙色'
                    break
                case 7:
                    color = '瓶蓝色'
                    break
                case 8:
                    color = '瓶灰色'
                    break
                case 100:
                    color = '瓶任意色'
                    break
            }
            let txt = '消除' + this._data.lock[1] + color
            ViewControl.ints.showTip(txt)
        }
        if ((this._data.complete == 1 || this.getEmpty() == 4 && GameControl.ints.selectItem == null) && this._data.ad != 1 && !this._isPourWater) {
            if (this._data.complete == 1) {
                StateControl.ints.playEffect('装满水瓶')
            } else if (this.getEmpty() == 4) {
                StateControl.ints.playEffect('空玻璃瓶')
            }
            cc.Tween.stopAllByTarget(this.node)

            cc.tween(this.node)
                .to(0.05, { angle: -5 })
                .to(0.05, { angle: 5 })
                .to(0.05, { angle: -5 })
                .to(0.05, { angle: 0 })
                .call(() => {
                })
                .start()

            return
        }
        if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 3) {
            let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[1].node.parent, GameControl.ints.gameView.node)
            pos.y += 100
            GuideControl.ints.showGuide({ type: 1, pos: null, tipePos: null, width: 100, height: 200, id: 1, txt: '' })
        }
        if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 2) {
            let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[1].node.parent, GameControl.ints.gameView.node)
            pos.y += 105
            let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
            GuideControl.ints.showGuide({ type: 1, pos: pos, tipePos, width: 100, height: 210, id: 1, txt: '倒入同色水中' })
        }
        if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 6) {
            GuideControl.ints.closeGuide()
        }
        if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 5) {
            let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[0].node.parent, GameControl.ints.gameView.node)
            pos.y += 100
            let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
            GuideControl.ints.showGuide({ type: 1, pos, tipePos, width: 100, height: 210, id: 1, txt: '可以倒入空瓶' })

        }




        clog.log(this.isPourWater, this._data.complete, this.getEmpty() == 4, this._data.lock[0], GameControl.ints.loadGameOver);
        if (!GameControl.ints.loadGameOver) return
        if (GameControl.ints.useProp && this.disturb.active) {
            this.disturbAn()
            return
        }



        if (GameControl.ints.useProp && !this.disturb.active) {
            return
        }


        if (this.isPourWater || this._data.complete == 1 || (this.getEmpty() == 4 && GameControl.ints.selectItem == null) || this._data.lock[0]) return

        if (GameControl.ints.selectItem == null) {
            GameControl.ints.selectItem = this
            cc.Tween.stopAllByTarget(this.node)
            cc.Tween.stopAllByTarget(this.shadow)
            this.clickBottle(1)
        } else if (GameControl.ints.selectItem == this) {
            cc.Tween.stopAllByTarget(this.node)
            cc.Tween.stopAllByTarget(this.shadow)
            this.clickBottle(2)
            GameControl.ints.selectItem = null
        } else if (GameControl.ints.selectItem != this) {



            if ((this.getTopColorId() == GameControl.ints.selectItem.getTopColorId() && this.getEmpty() != 0) || this.getEmpty() == 4) {
                this.isPourWater = true
                GameControl.ints.selectItem.isPourWater = true


                this.pourWater(GameControl.ints.selectItem)

            } else {
                cc.Tween.stopAllByTarget(GameControl.ints.selectItem.node)
                cc.Tween.stopAllByTarget(GameControl.ints.selectItem.shadow)
                GameControl.ints.selectItem.clickBottle(2)
                GameControl.ints.selectItem = this
                this.clickBottle(1)
            }



        }

    }

    // update (dt) {}
}
