import ADControl from "../../adSdk/ADControl";
import ZTSDKControl from "../../adSdk/ZTSDKControl";
import DateControl from "../../manage/control/controlData/DateControl";
import GameControl, { BottleData, ColorType } from "../../manage/control/controlData/GameControl";
import GuideControl from "../../manage/control/controlData/GuideControl";
import NodeControl from "../../manage/control/controlNode/NodeControl";
import EventControl from "../../manage/control/event/EventControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { EventName } from "../../manage/enum/EventEnum";
import ArrayUtil from "../../manage/utils/ArrayUtil";
// import { PosType } from "../../ZTSDK/GaComponent";
import bottle from "./bottle";

const { ccclass, property } = cc._decorator;

@ccclass
export default class bottle3 extends bottle {




    // @property(cc.Node)
    // top: cc.Node = null;
    // @property(cc.Mask)
    // mask: cc.Mask = null;
    // @property(cc.Node)
    // waterNode: cc.Node = null;
    // @property(cc.Node)
    // plug: cc.Node = null;
    // @property(cc.Node)
    // video: cc.Node = null;

    // @property(cc.Node)
    // lock: cc.Node = null;
    // @property(cc.Label)
    // lockNum: cc.Label = null;

    // @property(cc.Node)
    // shadow: cc.Node = null;
    // @property(cc.Node)
    // column: cc.Node = null;
    // @property(cc.Node)
    // column2: cc.Node = null;
    // @property(cc.Node)
    // disturb: cc.Node = null;
    // @property(cc.Node)
    // appear: cc.Node = null;
    // @property(cc.Node)
    // lockColor: cc.Node = null;
    // @property(cc.Node)
    // brand: cc.Node = null;

    // @property(cc.Node)
    // blast: cc.Node = null;
    // @property(cc.Node)
    // light: cc.Node = null;

    // @property(cc.ParticleSystem)
    // ParticleAsset: cc.ParticleSystem = null;

    // @property([cc.Node])
    // storeys: cc.Node[] = [];
    // @property([cc.Node])
    // storeyColors: cc.Node[] = [];
    @property(cc.Node)
    appear3: cc.Node = null;

    @property(cc.Node)
    bottle2: cc.Node = null;

    @property([cc.Node])
    storeys2: cc.Node[] = [];
    @property([cc.Node])
    storeyColors2: cc.Node[] = [];

    @property([cc.Node])
    an1: cc.Node[] = [];
    @property([cc.Node])
    an2: cc.Node[] = [];

    @property([cc.Node])
    booms: cc.Node[] = [];

    @property([cc.Node])
    blockMask: cc.Node[] = [];
    @property([cc.Node])
    blockMask2: cc.Node[] = [];




    protected _data: BottleData = null
    protected blockHeight: number = -1000
    protected _lockScale: number = 0

    /**瓶子是否可以箱子操作 */
    public isOperate: boolean = true

    /**瓶子是否正在倒水 */
    public _isPourWater: boolean = false

    /**是否正在抬起 */
    private isUp: boolean = false



    block_pos: cc.Vec2 = null

    protected _index: number = 0

    get isPourWater() {
        return this._isPourWater
    }
    set isPourWater(value: boolean) {
        if (value) {
            GameControl.ints.operate = 1
        } else {
            GameControl.ints.operate = -1
        }

        this._isPourWater = value
    }

    get data() {
        return this._data
    }

    get index() {
        return this._index
    }
    /**是否已经完成 */
    get complete() {
        return this._data.complete == 1
    }


    protected _zIndex: number = -1


    get zIndex() {
        return this._zIndex
    }

    protected _lightForever: cc.Tween = null

    private storeysPos: cc.Vec2[] = []

    private _storeysTopPos: cc.Vec2[] = []

    get storeysTopPos() {
        return this._storeysTopPos
    }


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        cc.tween(this.brand)
            .to(2, { angle: -5 })
            .to(2, { angle: 5 })
            .union()
            .repeatForever()
            .start()
        this._lightForever = cc.tween(this.light)
            .to(2, { opacity: 0 })
            .to(2, { opacity: 255 })
            .union()
            .repeatForever()
            .start()


    }

    setData(_data: BottleData, index: number) {
        this.off()
        this._index = index
        this._data = _data
        this.block_pos = GameControl.ints.getPos(this._data.pos)
        this._zIndex = -1
        if (this.storeysPos.length == 0) {
            for (let i = 0; i < this.storeys.length; i++) {
                this.storeysPos[i] = cc.v2(0, 0)
                this.storeysPos[i].y = 151 - i * 52
                this._storeysTopPos[i] = cc.v2(0, 0)
                this._storeysTopPos[i].y = 270 + i * 52
            }

        }
        if (this._data.ad == 1) {
            this.node.on(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
            this.node.on(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
            this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
        } else {
            this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
        }




        this.initData()
    }

    off() {
        this.node.off(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
        this.node.off(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
        this.node.off(cc.Node.EventType.TOUCH_START, this.touchStart, this);
    }

    showBlock() {
        // for (let i = 0; i < 4; i++) {

        //     if (this._data[i][0] == ColorType.NONE) {
        //         this.storeys[i].active = false
        //         this.storeys[i].children[1].active = false
        //     } else {
        //         GameControl.ints.bottleBlockNum++
        //         if (!GameControl.ints.colorNum[this._data[i][0]]) GameControl.ints.colorNum[this._data[i][0]] = 0
        //         GameControl.ints.colorNum[this._data[i][0]]++
        //         this.storeys[i].active = true
        //         if (this.blockHeight != -1000) {
        //             this.storeys[i].height = this.blockHeight
        //         }
        //         if (this._data[i][1] == 1) {
        //             this.storeys[i].children[1].active = true
        //             // this.storeys[i].children[1].getComponent(cc.Sprite).enabled = false

        //         } else {
        //             if (this._data[i][0] != 0) {
        //                 this.storeyColors[i].getComponent(cc.Sprite).spriteFrame = this.icons[this._data[i][0]]

        //             }

        //         }

        //     }
        // }
        // this.lock.opacity = 150
    }

    initData() {


        this.isUp = false
        this.blast.active = false
        this.node.parent.setPosition(this.block_pos)
        this.shadow.opacity = 255
        this.shadow.x = -60
        // this.shadow.y = -27
        this.isOperate = true
        this.ParticleAsset.resetSystem()
        this.ParticleAsset.node.active = false

        this._isPourWater = false
        this.light.active = false
        this.block.parent = GameControl.ints.gameView.mapNode
        if (this._zIndex == -1) this._zIndex = this._data.pos[1] * 50 + 50 - this._data.pos[0] * 2
        this.block.zIndex = this._zIndex
        this.block.name = this._zIndex + ''
        this.lockNum.node.x = 3
        for (let i = 0; i < 4; i++) {
            cc.Tween.stopAllByTarget(this.storeys[i])
            cc.Tween.stopAllByTarget(this.storeys2[i])
            this.an1[i].active = false
            this.an2[i].active = false
            this.booms[i].active = false
            this.storeys[i].zIndex = 4 - (i + 1)
            this.storeys[i].setPosition(this.storeysPos[i])
            this.storeys2[i].zIndex = 4 - (i + 1)
            this.storeys2[i].setPosition(this.storeysPos[i])

            if (this._data[i][0] == ColorType.NONE) {
                this.storeys[i].active = false
                this.blockMask[i].active = false
                this.storeys2[i].active = false
                this.blockMask2[i].active = false
            } else {
                GameControl.ints.bottleBlockNum++
                if (!GameControl.ints.colorNum[this._data[i][0]]) GameControl.ints.colorNum[this._data[i][0]] = 0
                GameControl.ints.colorNum[this._data[i][0]]++
                this.storeys[i].active = true
                this.storeys2[i].active = true
                if (this.blockHeight != -1000) {
                    this.storeys[i].height = this.blockHeight
                    this.storeys2[i].height = this.blockHeight
                }

                if (this._data[i][1] == 1) {
                    this.blockMask[i].active = true
                    this.blockMask[i].getComponent(cc.Sprite).enabled = true
                    this.blockMask2[i].active = true
                    this.blockMask2[i].getComponent(cc.Sprite).enabled = true
                    this.storeyColors[i].color = cc.color().fromHEX('#000000')
                    this.storeyColors2[i].color = cc.color().fromHEX('#000000')

                } else {
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.storeyColors2[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.an1[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.an2[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)

                    }
                    this.blockMask[i].active = false
                    this.blockMask2[i].active = false

                }
                this.blockMask[i].opacity = 255
                this.blockMask2[i].opacity = 255

            }
        }


        this.bottle.active = this._data.ad != 1
        this.bottle2.active = this._data.ad == 1

        this.node.active = this._data.showBottle == 1
        this.video.active = this._data.ad == 1
        this.mask.enabled = false
        this.disturb.active = false
        this.appear.active = false
        this.appear4.active = false
        this.appear3.active = false
        this.waterNode.scale = 1
        this.block.scale = 1
        if (this.blockHeight == -1000) {
            this.blockHeight = this.storeys[3].height
        }

        if (this._data.ad == 1) {
            this.plug.y = 273
            this.plug.active = false
            this.bottle

        } else {
            this.plug.active = this._data.complete == 1
        }
        if (this.plug.active) {
            this.plug.opacity = 255
        }

        this.lock.opacity = 255
        this.lock.active = this._data.lock[0] != 0
        if (this._lockScale == 0) this._lockScale = this.lock.scale
        this.lock.scale = this._lockScale

        if (this.lock.active && this._data.lock[0] != ColorType.BLACK) {

            this.lockColor.color = cc.color().fromHEX(GameControl.ints.colorList[this._data.lock[0]].dark)
        } else if (this.lock.active && this._data.lock[0] == ColorType.BLACK) {
            this.lockColor.color = cc.color().fromHEX('#FFFFFF')
        }


        this.lockNum.string = this._data.lock[1] + ''

    }
    /**锁定值减少 */
    async unlock() {
        return new Promise(async (resolve, reject) => {
            this._data.lock[1]--
            if (this._data.lock[1] == 0) this.lockNum.node.x = -5
            this.lockNum.string = this._data.lock[1] + ''
            let time = 0.3
            cc.tween(this.lockNum.node)
                .to(time / 2, { scale: 1.4 })
                .to(time / 2, { scale: 1 })
                .call(() => {

                })
                .start()


            if (this._data.lock[1] <= 0) {
                this._data.lock[0] = 0
                resolve(true)
                await DateControl.ints.Delay(time)
                this.brand.angle = 0
                this.ParticleAsset.node.active = true
                this.block.parent = GameControl.ints.gameView.topMap
                this.block.zIndex = 1
                cc.tween(this.lock)
                    .to(0.2, { scale: 0 })
                    .delay(1)
                    .call(() => {
                        this.block.parent = GameControl.ints.gameView.mapNode
                        this.block.zIndex = this._zIndex
                    })
                    .start()
            }
            resolve(false)
        })

    }



    /**盖瓶子 */
    cover() {
        this.plug.active = true
        this.plug.opacity = 0
        this.plug.y = 400
        let thar = this

        cc.tween(this.plug)
            .to(0.3, { opacity: 255, y: 273 })
            .call(() => {
                StateControl.ints.playEffect('螺丝盖子')
                this.appear4.active = true
                this.appear4.getComponent(sp.Skeleton).setCompleteListener(() => {
                    this.appear4.active = false
                    EventControl.ints.emit(EventName.BoxInspect, thar)
                })
                this.appear4.getComponent(sp.Skeleton).setAnimation(0, 'guang', false)

            })
            .start()
    }

    /**开瓶子 */
    openCover() {
        this.appear.active = true
        this.appear.getComponent(sp.Skeleton).setCompleteListener(() => {
            this.appear.active = false
        })
        this.appear.getComponent(sp.Skeleton).setAnimation(0, 'guang', false)

        // this.plug.active = true
        // this.plug.opacity = 255
        // this.plug.y = 238
        this._isPourWater = true
        cc.tween(this.node)
            .to(0.1, { scaleY: 0.5 })
            .call(() => {
                StateControl.ints.playEffect('生成螺丝')
            })
            .to(0.1, { scaleY: 0.55 })
            .call(() => {

                // cc.tween(this.plug)
                //     .to(0.2, { opacity: 200, y: 500 })
                //     .to(0.2, { opacity: 0, y: 500 })
                //     .call(() => {
                this._isPourWater = false
                this.bottle.active = true
                this.bottle2.active = false
                // this.initData()
                // })
                // .start()

            })
            .start()


    }




    /**获得是否可以打乱 */
    getDisturb(showTip: boolean) {
        if (this._data.lock[0] != 0 || this._data.ad == 1) return false

        if (showTip && this.isUp) {
            if (GameControl.ints.selectItem == this) GameControl.ints.selectItem = null
            let TopColor = this.getTopColor()
            for (let i = TopColor.length - 1; i >= 0; i--) {
                this.storeys[TopColor[i]].y = this.storeysPos[TopColor[i]].y
                this.storeys2[TopColor[i]].y = this.storeysPos[TopColor[i]].y
            }
            this.isUp = false
        }


        let can = false
        let colorId = -1
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0 && this._data[i][1] == 1) {
                can = true
                break
            }
            if (this._data[i][0] != 0 && colorId == -1) {
                colorId = this._data[i][0]
            }
            if (this._data[i][0] != 0 && this._data[i][0] != colorId) {
                can = true
                break
            }
        }

        return can
    }

    setDisturb() {
        this.disturb.active = true
    }
    /**打乱动画 */
    disturbAn() {

        let lastBottle = GameControl.ints.lastBottle
        if (lastBottle) {
            if (lastBottle.addBottle == this) {
                GameControl.ints.lastBottle = null
                GameControl.ints.gameView.backInspect()
            }
        }

        this.isPourWater = true
        GameControl.ints.gameView.restoreDisturb()
        StateControl.ints.playEffect('随机螺母')
        let data: Record<number, number[]> = {}
        let data2: Record<number, number[]> = {}
        let arr: number[] = []


        for (let i = 3; i >= this.getEmpty(); i--) {
            arr.push(i)
            if (!data2[i]) data2[i] = []
            data2[i][0] = this.data[i][0]
            data2[i][1] = this.data[i][1]
        }
        ArrayUtil.shuffle(arr)
        for (let i = 0; i < arr.length; i++) {
            this.data[3 - i][0] = data2[arr[i]][0]
            this.data[3 - i][1] = data2[arr[i]][1]
        }


        for (let i = 3; i >= this.getEmpty(); i--) {
            if (!data[i]) data[i] = []
            data[i][0] = this.data[i][0]
            data[i][1] = this.data[i][1]
        }



        let index = 0
        let fun = () => {
            index++
            for (let i = 3; i >= this.getEmpty(); i--) {
                let datai = i - 1
                if (i <= this.getEmpty()) {
                    datai = 3
                }
                data2[i][0] = data[datai][0]
                data2[i][1] = data[datai][1]
            }

            for (let i = 3; i >= this.getEmpty(); i--) {
                data[i][0] = data2[i][0]
                data[i][1] = data2[i][1]
            }
            // clog.log(data2);


            let fun2 = (data3) => {

                for (let i = 3; i >= this.getEmpty(); i--) {


                    this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[data3[i][0]].dark)
                    this.storeyColors2[i].color = cc.color().fromHEX(GameControl.ints.colorList[data3[i][0]].dark)
                    this.an1[i].color = cc.color().fromHEX(GameControl.ints.colorList[data3[i][0]].dark)
                    this.an2[i].color = cc.color().fromHEX(GameControl.ints.colorList[data3[i][0]].dark)

                    if (data3[i][1] == 1) {
                        // this.blockMask[i].active = false

                        this.blockMask[i].active = true
                        this.blockMask[i].opacity = 255
                        this.blockMask[i].getComponent(cc.Sprite).enabled = true
                        this.blockMask2[i].active = true
                        this.blockMask2[i].opacity = 255
                        this.blockMask2[i].getComponent(cc.Sprite).enabled = true

                        this.storeyColors[i].color = cc.color().fromHEX('#000000')
                        this.storeyColors2[i].color = cc.color().fromHEX('#000000')

                    } else if (data3[i][1] == 0) {

                        this.blockMask[i].active = false
                        this.blockMask2[i].active = false
                    }
                }

            }
            fun2(data2)

            if (index >= 16) {
                fun2(this.data)

                for (let i = 0; i < 3; i++) {//判断最顶层是否黑色，黑色就解锁
                    if (this._data[i][0] != 0) {
                        if (this._data[i][1] == 1) {
                            this._data[i][1] = 0
                            this.blockMask[i].active = false
                            this.blockMask2[i].active = false

                            this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                            this.storeyColors2[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                            this.an1[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                            this.an2[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)


                        }

                        break
                    }
                }
                this.isPourWater = false

                this.unschedule(fun)

            }

        }
        fun()
        let time = 0.02
        // if (arr.length == 2) time = 0.02
        this.schedule(fun, time)



    }

    /**是否已经完成 */
    isComplete() {
        let isComplete = 1
        let color = 0
        color = this._data[3][0]
        if (color == ColorType.NONE) return
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == ColorType.NONE || this._data[i][1] == 1 || color != this._data[i][0]) {
                isComplete = 0
                break
            }
        }

        this._data.complete = isComplete

    }
    /**黑色块解锁 */
    blackUnlock() {
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                if (this._data[i][1] == 1) {
                    this._data[i][1] = 0
                    if (this._data[i][0] != 0) {
                        this.storeyColors[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.storeyColors2[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.an1[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                        this.an2[i].color = cc.color().fromHEX(GameControl.ints.colorList[this._data[i][0]].dark)
                    }
                    this.blast.active = true
                    this.blast.getComponent(sp.Skeleton).setAnimation(0, 'bao', false)
                    this.blast.getComponent(sp.Skeleton).setCompleteListener(() => {
                        this.blast.active = false
                    })
                    this.blast.y = this.storeys[i].y + 47

                    cc.tween(this.blockMask[i])
                        .to(0.3, { opacity: 0 })
                        .start()
                    cc.tween(this.blockMask2[i])
                        .to(0.3, { opacity: 0 })
                        .start()

                }
                break
            }
        }
    }

    /**获得最上层颜色id */
    getTopColorId() {
        let colorId = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                colorId = this._data[i][0]
                break
            }
        }

        return colorId
    }
    /**获得上层空位有多少 */
    getEmpty() {
        let empty = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] == 0) {
                empty++
            }
        }

        return empty
    }
    /**获得上层相同颜色层 */
    getTopColor(): number[] {
        let index = []
        let colorId = 0
        for (let i = 0; i < 4; i++) {
            if (this._data[i][0] != 0) {
                if (colorId == 0) colorId = this._data[i][0]
                if (this._data[i][0] == colorId && this._data[i][1] != 1) {
                    index.push(i)
                } else {
                    break
                }
            }
        }
        return index
    }

    /**倒水时长 */
    protected pourWaterTime: number = 0.2
    // /**倾斜时长 */
    // protected inclineTime: number = 0.3

    /**移动到瓶子位置 */
    async pourWater(selectItem: bottle) {
        GameControl.ints.selectItem = null
        selectItem.light.active = false

        this.block.parent = GameControl.ints.gameView.topMap
        this.block.zIndex = 10
        // let otherNode: cc.Node = selectItem.node.parent
        // otherNode.parent = GameControl.ints.gameView.topMap



        // this.light.active = true
        // cc.Tween.stopAllByTarget(this.light)
        // this.light.opacity = 255

        let time = this.pourWaterTime//0.15






        let index = this.getEmpty()
        let index2 = index
        let topColor = selectItem.getTopColor()
        let topColorlength = topColor.length
        let topColorlength2 = topColorlength
        let colorId = selectItem.getTopColorId()
        clog.log(topColor, topColorlength, colorId);

        let endId = 0
        if (index2 >= topColorlength2) {
            endId = topColor[0] + topColorlength2 - 1
        } else {
            endId = topColor[0] + index2 - 1
        }
        clog.log(index2, topColorlength2, topColor[0], endId);



        if (!GameControl.ints.lastBottle) {
            GameControl.ints.lastBottle = { addBottle: null, reduceBottle: null, num: 0, coloId: ColorType.NONE }
        }
        GameControl.ints.lastBottle.addBottle = this
        GameControl.ints.lastBottle.reduceBottle = selectItem
        GameControl.ints.lastBottle.num = 0
        GameControl.ints.lastBottle.coloId = colorId
        let startId = -1
        let endId2 = -1

        for (let i = 3; i >= 0; i--) {
            if (this._data[i][0] == 0) {
                if (startId == -1) startId = i
                this._data[i][0] = colorId

                index--
                topColorlength--
                GameControl.ints.lastBottle.num++
            }

            if (index <= 0 || topColorlength <= 0) {
                endId2 = i
                break
            }
        }

        for (let i = topColor[0]; i <= endId; i++) {
            selectItem.data[i][0] = 0
        }






        if (startId - endId2 + 1 < topColor.length) {
            selectItem.clickBottle(2)
        }
        selectItem.isPourWater = false

        selectItem.blackUnlock()




        let moveFun = () => {
            return new Promise((resolve, reject) => {

                for (let i = 0; i < startId - endId2 + 1; i++) {

                    selectItem.storeys[topColor[i]].active = false
                    cc.Tween.stopAllByTarget(selectItem.storeys[topColor[i]])
                    selectItem['storeys2'][topColor[i]].active = false
                    cc.Tween.stopAllByTarget(selectItem['storeys2'][topColor[i]])
                    selectItem['an1'][topColor[i]].active = false
                    selectItem['an2'][topColor[i]].active = false
                    selectItem.storeyColors[topColor[i]].active = true
                    selectItem['storeyColors2'][topColor[i]].active = true
                    selectItem['isUp'] = false

                    let pos = NodeControl.ints.nodeConvertLocalPointAR(selectItem.block, this.node)
                    this.storeys[index2 - 1 - i].active = true
                    this.storeys[index2 - 1 - i].x = pos.x
                    this.storeys[index2 - 1 - i].y = pos.y + this._storeysTopPos[startId - endId2 - i].y

                    this.storeys2[index2 - 1 - i].active = true
                    this.storeys2[index2 - 1 - i].x = pos.x
                    this.storeys2[index2 - 1 - i].y = pos.y + this._storeysTopPos[startId - endId2 - i].y

                    this.storeyColors[index2 - 1 - i].color = cc.color().fromHEX(GameControl.ints.colorList[colorId].dark)
                    this.storeyColors2[index2 - 1 - i].color = cc.color().fromHEX(GameControl.ints.colorList[colorId].dark)
                    this.an1[index2 - 1 - i].color = cc.color().fromHEX(GameControl.ints.colorList[colorId].dark)
                    this.an2[index2 - 1 - i].color = cc.color().fromHEX(GameControl.ints.colorList[colorId].dark)
                    cc.tween(this.storeys[index2 - 1 - i])
                        .to(i * 0.05, { y: pos.y + this._storeysTopPos[startId - endId2].y })
                        .to(time + i * 0.05, { x: 0, y: this._storeysTopPos[startId - endId2].y })
                        .call(() => {
                            if (i == 0) {
                                this.light.active = false
                                StateControl.ints.playEffect('螺母放下')
                            }
                        })
                        .to(time, { y: this.storeysPos[index2 - 1 - i].y })
                        .call(() => {
                            if (i == startId - endId2) {
                                resolve(true)
                            }

                            this.booms[index2 - 1 - i].active = true
                            this.booms[index2 - 1 - i].getComponent(sp.Skeleton).setCompleteListener(() => {
                                this.booms[index2 - 1 - i].active = false
                            })
                            this.booms[index2 - 1 - i].getComponent(sp.Skeleton).setAnimation(0, 'bao', false)
                        })
                        .start()

                    cc.tween(this.storeys2[index2 - 1 - i])
                        .to(i * 0.05, { y: pos.y + this._storeysTopPos[startId - endId2].y })
                        .to(time + i * 0.05, { x: 0, y: this._storeysTopPos[startId - endId2].y })
                        .call(() => {

                        })
                        .to(time, { y: this.storeysPos[index2 - 1 - i].y })
                        .call(() => {

                        })
                        .start()
                }


            })
        }
        await moveFun()

        this.isComplete()

        if (this._data.complete == 1) {

            this.cover()
        } else {
            this.isPourWater = false
        }

        this.block.parent = GameControl.ints.gameView.mapNode
        this.block.zIndex = this._zIndex
        // for (let node of this.storeys) {
        //     node.children[0].children[0].active = false
        // }
        this.mask.enabled = false
        GameControl.ints.gameView.disturbInspect()


        // if (this._data.complete == 0) {
        GameControl.ints.gameView.backInspect()
        // }
        GameControl.ints.gameView.saveData()





    }

    protected _riseY: number = 80
    /**瓶子1上升2下降 */
    async clickBottle(direction: number) {
        let time = 0.2

        if (direction == 1) {
            this.isUp = true
            this._lightForever.start()
            StateControl.ints.playEffect('螺母拔起')

            // this.node.parent.parent = GameControl.ints.gameView.topMap
            // this.node.parent.zIndex = 10

            let TopColor = this.getTopColor()
            for (let i = 0; i < TopColor.length; i++) {
                this.booms[TopColor[i]].active = false
                this.an1[TopColor[i]].active = true
                this.an1[TopColor[i]].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
                this.an2[TopColor[i]].active = true
                this.an2[TopColor[i]].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
                this.storeyColors[TopColor[i]].active = false
                this.storeyColors2[TopColor[i]].active = false

                cc.Tween.stopAllByTarget(this.storeys[TopColor[i]])
                cc.tween(this.storeys[TopColor[i]])
                    .to(time + i * 0.05, { y: this._storeysTopPos[TopColor.length - 1 - i].y }, cc.easeOut(3.0))
                    .call(() => {
                        if (i == TopColor.length - 1) {
                            // this.light.active = true
                        }
                        this.an1[TopColor[i]].active = false
                        this.an2[TopColor[i]].active = false
                        this.storeyColors[TopColor[i]].active = true
                        this.storeyColors2[TopColor[i]].active = true
                    })
                    .start()
                cc.Tween.stopAllByTarget(this.storeys2[TopColor[i]])
                cc.tween(this.storeys2[TopColor[i]])
                    .to(time + i * 0.05, { y: this._storeysTopPos[TopColor.length - 1 - i].y }, cc.easeOut(3.0))

                    .start()
            }


        } else {


            this.block.parent = GameControl.ints.gameView.mapNode
            this.block.zIndex = this._zIndex
            this.light.active = false
            let TopColor = this.getTopColor()
            StateControl.ints.playEffect('螺母放下')

            for (let i = TopColor.length - 1; i >= 0; i--) {

                this.an1[TopColor[i]].active = true
                this.an1[TopColor[i]].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
                this.an2[TopColor[i]].active = true
                this.an2[TopColor[i]].getComponent(sp.Skeleton).setAnimation(0, 'idle', true)
                this.storeyColors[TopColor[i]].active = false
                this.storeyColors2[TopColor[i]].active = false

                cc.Tween.stopAllByTarget(this.storeys[TopColor[i]])
                cc.tween(this.storeys[TopColor[i]])
                    .to(time + (TopColor.length - 1 - i) * 0.05, { y: this.storeysPos[TopColor[i]].y })
                    .call(() => {
                        if (i == TopColor.length - 1) {
                            // this.light.active = true
                            this.isUp = false
                        }
                        this.booms[TopColor[i]].active = true
                        this.booms[TopColor[i]].getComponent(sp.Skeleton).setCompleteListener(() => {
                            this.booms[TopColor[i]].active = false
                        })
                        this.booms[TopColor[i]].getComponent(sp.Skeleton).setAnimation(0, 'bao', false)
                        this.an1[TopColor[i]].active = false
                        this.an2[TopColor[i]].active = false
                        this.storeyColors[TopColor[i]].active = true
                        this.storeyColors2[TopColor[i]].active = true
                    })
                    .start()
                cc.Tween.stopAllByTarget(this.storeys2[TopColor[i]])
                cc.tween(this.storeys2[TopColor[i]])
                    .to(time + (TopColor.length - 1 - i) * 0.05, { y: this.storeysPos[TopColor[i]].y })
                    .start()
            }


        }

    }







    adTouchStart(event: cc.Event.EventTouch) {
        if (this._data.ad == 1) {
            GameControl.ints.gameView.finger.active = false
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1.2 })
                .start()
        }

    }

    adTouchEnd() {
        if (this._data.ad == 1) {
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()

            if (GameControl.ints.useProp) {
                ViewControl.ints.showTip('正在使用道具')
                return
            }
            GameControl.ints.useProp = true

            let data = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                pos_ext: '主关卡',
                pos_sub_ext: ZTSDKControl.ints.version,
                why: '解锁空瓶',
                pos_index: GameControl.ints.gameView.data.level + 1,
            }
            ZTSDKControl.ints.onAdRequest(data);


            StateControl.ints.playEffect('btn_0')
            ADControl.ints.showVideo({
                successFun: () => {

                    this.node.off(cc.Node.EventType.TOUCH_END, this.adTouchEnd, this);
                    this.node.off(cc.Node.EventType.TOUCH_START, this.adTouchStart, this);
                    this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.adTouchCancel, this);
                    this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
                    GameControl.ints.gameView.finger.active = false
                    this.video.active = false
                    this._data.ad = 0
                    this.openCover()
                    GameControl.ints.gameView.saveData()
                    ZTSDKControl.ints.onAdFinish(data);
                },
                closeFun: () => {
                    GameControl.ints.useProp = false
                    ZTSDKControl.ints.onAdCancel(data);
                }
            })
            return
        }
    }

    adTouchCancel() {
        if (this._data.ad == 1) {
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()
        }
    }

    async touchStart(event: cc.Event.EventTouch) {
        ADControl.ints.checkFeedSubscribeStatus()
        clog.log(this._data);
        GameControl.ints.gameView.showFinger()
        if (this._data.lock[0]) {

            let txt = GameControl.ints.getTipLab(this._data.lock[0], this._data.lock[1])

            ViewControl.ints.showTip(txt)
        }
        if ((this._data.complete == 1 || this.getEmpty() == 4 && GameControl.ints.selectItem == null) && this._data.ad != 1 && !this._isPourWater) {
            if (this._data.complete == 1) {
                StateControl.ints.playEffect('点击满螺母')
                if (!this.appear3.active) {
                    this.appear3.active = true
                    this.appear3.getComponent(sp.Skeleton).setCompleteListener(() => {
                        this.appear3.active = false
                    })
                    this.appear3.getComponent(sp.Skeleton).setAnimation(0, 'idle', false)
                }


            } else if (this.getEmpty() == 4) {
                StateControl.ints.playEffect('点击螺丝')
            }
            cc.Tween.stopAllByTarget(this.node)

            cc.tween(this.node)
                .to(0.05, { angle: -5 })
                .to(0.05, { angle: 5 })
                .to(0.05, { angle: -5 })
                .to(0.05, { angle: 0 })
                .call(() => {
                })
                .start()

            return
        }
        if (GuideControl.ints.guide[1] == 3) {
            GuideControl.ints.closeGuide()
        }
        if (GuideControl.ints.guide[1] == 2) {
            let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[1].node.parent, GameControl.ints.gameView.node)
            pos.y += 105
            let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
            let txt = '放入同色螺丝中'
            if (window['__guide'] == 2) {
                txt = '放入空螺母中'
            }

            GuideControl.ints.showGuide({ type: 1, pos: pos, tipePos, width: 100, height: 210, id: 1, txt })
        }





        clog.log(this.isPourWater, this._data.complete, this.getEmpty() == 4, this._data.lock[0], GameControl.ints.loadGameOver);
        if (!GameControl.ints.loadGameOver) return
        if (GameControl.ints.useProp && this.disturb.active) {
            this.disturbAn()
            return
        }



        if (GameControl.ints.useProp && !this.disturb.active) {
            return
        }


        if (this.isPourWater || this._data.complete == 1 || (this.getEmpty() == 4 && GameControl.ints.selectItem == null) || this._data.lock[0]) return

        if (GameControl.ints.selectItem == null) {
            GameControl.ints.selectItem = this
            cc.Tween.stopAllByTarget(this.node)
            cc.Tween.stopAllByTarget(this.shadow)
            this.clickBottle(1)
        } else if (GameControl.ints.selectItem == this) {
            cc.Tween.stopAllByTarget(this.node)
            cc.Tween.stopAllByTarget(this.shadow)
            this.clickBottle(2)
            GameControl.ints.selectItem = null
        } else if (GameControl.ints.selectItem != this) {



            if ((this.getTopColorId() == GameControl.ints.selectItem.getTopColorId() && this.getEmpty() != 0) || this.getEmpty() == 4) {
                this.isPourWater = true
                GameControl.ints.selectItem.isPourWater = true


                this.pourWater(GameControl.ints.selectItem)

            } else {
                cc.Tween.stopAllByTarget(GameControl.ints.selectItem.node)
                cc.Tween.stopAllByTarget(GameControl.ints.selectItem.shadow)
                GameControl.ints.selectItem.clickBottle(2)
                GameControl.ints.selectItem = this
                this.clickBottle(1)
            }



        }

    }

    // update (dt) {}
}
