import ADControl from "../../adSdk/ADControl";
import ZTSDKControl from "../../adSdk/ZTSDKControl";
import GameControl, { SkinType } from "../../manage/control/controlData/GameControl";
import GuideControl from "../../manage/control/controlData/GuideControl";
import NodeControl from "../../manage/control/controlNode/NodeControl";
import EventControl from "../../manage/control/event/EventControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { EventName } from "../../manage/enum/EventEnum";
import { Pages, Storey } from "../../manage/enum/Integrate";
// import { PosType } from "../../ZTSDK/GaComponent";
import bottle from "./bottle";


const { ccclass, property } = cc._decorator;

@ccclass
export default class boxItem extends cc.Component {

    @property(cc.Node)
    bottle: cc.Node = null;
    @property(cc.Node)
    bottle3: cc.Node = null;

    @property(cc.Node)
    bottleTop: cc.Node = null;
    @property(cc.Node)
    body: cc.Node = null;
    @property(cc.Node)
    body3: cc.Node = null;
    @property(cc.Node)
    color: cc.Node = null;
    @property(cc.Node)
    color2: cc.Node = null;

    @property(cc.Node)
    video: cc.Node = null;

    @property(cc.Node)
    plug: cc.Node = null;
    @property(cc.Node)
    plug3: cc.Node = null;

    @property(cc.Label)
    numLab: cc.Label = null;

    @property(sp.Skeleton)
    cover: sp.Skeleton = null;

    @property(cc.Node)
    shadow: cc.Node = null;




    /**是否已经准备好 */
    private _isPrepare: boolean = false
    private _isAd: number = 0
    private _colorId: number = 0
    /**盒子状态 0没有盒子，1看视频，2不用看视频/等待瓶子放入 3不可看视频解锁，4结束收集的盒子*/
    get isAd() {
        return this._isAd
    }

    get coloId() {
        return this._colorId
    }
    /**是否已经准备好 */
    get isPrepare() {
        return this._isPrepare
    }

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);

    }

    setData(isAd: number, colorId: number) {
        this._isAd = isAd
        this._colorId = colorId
        this.initData()
    }

    initData() {

        this.takeOverNum = 0
        this.numLab.node.scale = 1
        this.numLab.node.active = false
        this.bottleTop.active = true
        this.plug.active = true
        this.plug3.active = true
        this.video.active = this._isAd == 1 || this._isAd == 3
        this.node.active = this._isAd != 0
        this.bottle.active = false
        this.bottle.y = 110
        this.bottle3.active = false
        this.bottle3.y = 110


        this.node.y = 0
        if (this.node.active) {
            this.shadow.scale = 1
        } else {
            this.shadow.scale = 0
        }
        this._isPrepare = true
        if (this._colorId) {
            let TopColorId = GameControl.ints.colorList[this._colorId]
            this.stopAtFrame(1)
            this.color.color = cc.color().fromHEX(TopColorId.dark)
            this.color2.color = cc.color().fromHEX(TopColorId.bottom)
            this.node.color = cc.color().fromHEX('#FFFFFF')
            this.cover.node.color = cc.color().fromHEX('#FFFFFF')
            this.cover.setSkin('a_0' + this._colorId)

        } else {
            this.stopAtFrame(1)
            this.color.color = cc.color().fromHEX('#7f7f7f')
            this.color2.color = cc.color().fromHEX('#7f7f7f')
            this.node.color = cc.color().fromHEX('#7f7f7f')
            this.cover.node.color = cc.color().fromHEX('#7f7f7f')
            this.cover.setSkin('a_08')
        }
        if (this._isAd == 4) {
            let TopColorId = GameControl.ints.colorList[8]
            this.stopAtFrame(1)
            this.color.color = cc.color().fromHEX('e5e5e5')
            this.color2.color = cc.color().fromHEX(TopColorId.bottom)
            this.node.color = cc.color().fromHEX('#FFFFFF')
            this.cover.node.color = cc.color().fromHEX('#FFFFFF')
            this.cover.setSkin('a_08')
        }
    }

    /**
    * 停止在指定帧。1是开始，-1是最后
    * @param frame 帧数
    */
    stopAtFrame(frame: number) {
        this.cover.setAnimation(0, 'he', false)
        const te = this.cover.getCurrent(0) as sp.spine.TrackEntry;

        // 算出帧对应的时间
        let time;
        if (frame === -1) {
            time = te.animation.duration; // 最后一帧
        } else if (frame > 1) {
            time = (frame - 1) / 30;  // 根据帧率算出对应时间，spine帧率是30
        } else {
            time = 0; // 首帧
        }
        // 对time作限制
        if (time < 0) time = 0;
        if (time >= te.animation.duration) time = te.animation.duration - 0.01; // 太精确的话，动画会停在首帧，所以要减一点

        te.timeScale = 0; // 让动画停止
        te.trackTime = time;
    }

    /**箱子落下 */
    fall(isOver: boolean = false) {
        // if (isOver) {
        //     this._isAd = 4
        //     this.initData()
        // }



        this._isPrepare = false
        this.node.y = 2000

        let time = 0.3
        this.shadow.scale = 0
        cc.tween(this.shadow)
            .to(time, { scale: 1 })
            .start()

        cc.tween(this.node)
            .to(time, { y: 0 })
            .call(() => {
                // if (isOver) {

                //     EventControl.ints.emit(EventName.BoxInspect, null, true)
                // } else {
                    this._isPrepare = true
                    EventControl.ints.emit(EventName.BoxInspect)
                    if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 4) {
                        let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[2].node.parent, GameControl.ints.gameView.node)
                        pos.y += 100
                        let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
                        GuideControl.ints.showGuide({ type: 1, pos, tipePos, width: 100, height: 215, id: 1, txt: '选择一个瓶子' })
                        return
                    }
                    // if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 6) {
                    //     GuideControl.ints.GuideTxt({ pos: cc.v2(0, 350), id: 1, txt: '只有相同颜色的水可以倒入融合' })
                    //     return
                    // }
                // }

            })
            .start()

    }


    /**瓶子飞过来 */
    packBottle(data: bottle, isOver: boolean = false, isEnd: boolean = false) {
        let lastBottle = GameControl.ints.lastBottle
        if (lastBottle && (data == lastBottle.addBottle || data == lastBottle.reduceBottle)) {
            GameControl.ints.lastBottle = null
        }
        data.isPourWater = false
        !isOver && GameControl.ints.gameView.backInspect()
        data.block.parent = GameControl.ints.gameView.topMap
        data.isOperate = false
        this._isPrepare = false

        let time = 0.1
        let colorId = data.getTopColorId()
        if (colorId != 0) {
            let TopColorId = GameControl.ints.colorList[colorId]
            this.bottleTop.color = cc.color().fromHEX(TopColorId.bleak)
            if (GameControl.ints.useSkin == SkinType.WATER) {
                this.body.color = cc.color().fromHEX(TopColorId.dark)
            } else if (GameControl.ints.useSkin == SkinType.SCREW) {
                for (let node of this.body3.children) {
                    node.children[0].color = cc.color().fromHEX(TopColorId.dark)
                }
            }

        }


        cc.tween(data.node.parent)
            .to(0.13, { scaleY: 0.8 })
            .to(0.13, { scaleY: 1 })
            .to(time, { x: this.node.parent.x, y: this.node.parent.parent.y + this.node.parent.y + 50, scale: 0.8 })
            .call(() => {
                data.node.active = false


                if (isOver) {
                    this.takeOver(isEnd)
                } else {
                    this.take(data)

                }
            })
            .start()

    }
    private takeOverNum: number = 0
    /**空瓶子装进盒子 */
    takeOver(isEnd: boolean) {
        this.takeOverNum++
        this.numLab.node.active = true
        this.numLab.string = '+' + this.takeOverNum
        GameControl.ints.gameView.setScore()
        cc.tween(this.numLab.node)
            .to(0.15, { scale: 1.2 })
            .to(0.15, { scale: 1 })
            .call(() => {

            })
            .start()
        let bottle = null
        if (GameControl.ints.useSkin == SkinType.WATER) {
            this.bottle.active = true
            this.bottle.opacity = 255
            bottle = this.bottle
        } else if (GameControl.ints.useSkin == SkinType.SCREW) {
            this.bottle3.active = true
            this.bottle3.opacity = 255
            bottle = this.bottle3
            this.body3.active = false
        }

        this.bottleTop.active = false
        this.plug.active = false
        this.plug3.active = false

        if (isEnd) {
            this.cover.setCompleteListener(() => {
                this.fly()
                // let level = GameControl.ints.gameView.data.level
                // if (level == 3 && cc.sys.platform != cc.sys.WECHAT_GAME) {
                //     this.scheduleOnce(async () => {
                //         await ViewControl.ints.openView(Pages.AddDesktopView, Storey.ViewUI, { type: 2 })
                //     }, 0.3)

                // }
                // else if (level % 10 == 0) {
                //     this.scheduleOnce(async () => {
                //         await ViewControl.ints.openView(Pages.ShareView, Storey.ViewUI, { type: 2 })
                //     }, 0.3)
                // }
                // else {
                    GameControl.ints.gameView.gameOver()
                // }

            })
            StateControl.ints.playEffect('装箱结束')
        } else {
            StateControl.ints.playEffect('装箱')
        }



        cc.tween(bottle)
            .to(0.3, { y: -235, opacity: 0 })
            .call(() => {
                if (isEnd) {

                    StateControl.ints.playEffect('打包封箱')
                    this.cover.setAnimation(0, 'he', false)
                }
            })
            .start()
    }

    private _data: bottle = null
    /**瓶子装进盒子 */
    take(data: bottle) {

        this.cover.setCompleteListener(() => {
            // if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 4) {
            //     this._data = data
            //     let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.boxNode.children[1], GameControl.ints.gameView.node)
            //     let tipePos: cc.Vec2 = cc.v2(pos.x + 100, pos.y - 200)
            //     GuideControl.ints.showGuide({ type: 2, pos, tipePos, width: 138, height: 168, id: 1, txt: '充满的瓶子会自动收集到箱子里' })
            // } else {
            this.fly(data)
            // }
        })
        let bottle = null
        if (GameControl.ints.useSkin == SkinType.WATER) {
            this.bottle.active = true
            this.bottle.opacity = 255
            bottle = this.bottle
        } else if (GameControl.ints.useSkin == SkinType.SCREW) {
            this.bottle3.active = true
            this.bottle3.opacity = 255
            this.body3.active = true
            bottle = this.bottle3

        }


        cc.tween(bottle)
            .to(0.3, { y: -235 })
            .call(() => {
                StateControl.ints.playEffect('打包封箱')
                this.cover.setAnimation(0, 'he', false)
                GameControl.ints.gameView.fly(this.node.parent.x)
            })
            .start()

    }
    /**盒子飞出屏幕 */
    fly(data?: bottle) {

        let time = 0.3
        cc.tween(this.shadow)
            .to(time, { scale: 0 })
            .start()

        cc.tween(this.node)
            .to(time, { y: 2000 })
            .call(() => {
                if (data) {
                    GameControl.ints.bottleComplete(data.index)
                    EventControl.ints.emit(EventName.UnlockBottle, this._colorId)
                    GameControl.ints.gameView.addInspect()
                    this._isPrepare = true
                    this._colorId = 0
                    this._isAd = 0
                    GameControl.ints.winGame()
                    data.data.showBottle = 0
                    for (let i = 0; i < 4; i++) {
                        data.data[i][0] = 0
                    }
                    EventControl.ints.emit(EventName.BoxUpdate)

                }

            })
            .start()

    }


    touchStart(event: cc.Event.EventTouch) {
        if (this._isAd == 1) {
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1.2 })
                .start()
        }
    }

    touchCancel() {
        if (this._isAd == 1) {
            cc.Tween.stopAllByTarget(this.node.parent)
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()
        }
    }

    touchEnd(event: cc.Event.EventTouch) {
        clog.log(this._isAd);
        // if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 5) {
        //     this.fly(this._data)

        //     GuideControl.ints.showGuide({ type: 1, pos: null, tipePos: null, width: 150, height: 200, id: 1, txt: '' })
        //     return
        // }
        if (this._isAd == 3) {
            ViewControl.ints.showTip('没有更多的瓶子了')
            return
        }
        if (this._isAd == 1) {

            let data = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                pos_ext: '主关卡',
                pos_sub_ext: ZTSDKControl.ints.version,
                why: '解锁箱子',
                pos_index: GameControl.ints.gameView.data.level + 1,
            }
            ZTSDKControl.ints.onAdRequest(data);
            StateControl.ints.playEffect('btn_0')
            cc.tween(this.node.parent)
                .to(0.1, { scale: 1 })
                .start()
            ADControl.ints.showVideo({
                successFun: () => {
                    StateControl.ints.playEffect('btn_0')

                    this._isAd = 0
                    EventControl.ints.emit(EventName.BoxUpdate, 2)
                    EventControl.ints.emit(EventName.BoxInspect)
                    GameControl.ints.gameView.saveData()
                    ZTSDKControl.ints.onAdFinish(data);
                }, closeFun: () => {
                    ZTSDKControl.ints.onAdCancel(data);
                }
            })
        }
    }
    // update (dt) {}
}
