import inherit from "../control/root/inherit";
import mapConf from "./mapConf";


export default class ConfData extends inherit<ConfData>() {
    public readonly mapConf: mapConf = new mapConf()

    public parseJson(res: cc.JsonAsset) {

        let confName: string = res.name
        for (let i in this) {
            if (i.endsWith("Conf")) {
                let confParse: IConf = this[i] as IConf
                confParse.parseJson(confName, res.json)
            }
        }
    }

}

export interface IConf {
    parseJson(name: string, conf: any);
}