import ADControl from "../../adSdk/ADControl";
import { ResControl } from "../resUrl/bundles";
import BundleControl from "./controlBunle/BundleControl";
import StorageConreol from "./controlData/StorageConreol";
import inherit from "./root/inherit";

export default class StateControl extends inherit<StateControl>() {
    private _openMusic: boolean = true
    private _openEffect: boolean = true
    private _vibrate: boolean = true


    private _music: Map<string, cc.AudioClip> = new Map()
    private _musicID: Map<string, number> = new Map()
    private _useBgm: string = ''

    initData() {
        if (ADControl.ints.isStraight && StorageConreol.ints.isNewPlayer) return
        let setting = StorageConreol.ints.getStorage("setting")
        this._openMusic = setting.bgm == 1
        this._openEffect = setting.sound == 1
        this._vibrate = setting.vibrate == 1
    }
    private async music(name: string, isBGM: boolean, loop: boolean) {
        if (!name) return
        let music: cc.AudioClip = null
        music = this._music.get(name)

        if (!music) {
            music = await BundleControl.ints.getAsset('music/' + name, cc.AudioClip) as cc.AudioClip
            this._music.set(name, music)
            // clog.log('加载的音频', name, music)
        }


        if (music && isBGM && this._openMusic) {
            clog.warn('播放bgm', this._openMusic)
            let id = cc.audioEngine.playMusic(music, loop)
            this._musicID.set(name, id)
        }
        if (music && !isBGM && this._openEffect) {
            let id = cc.audioEngine.playEffect(music, loop)
            this._musicID.set(name, id)
        }

    }


    setStorage() {
        StorageConreol.ints.setStorage("setting", { bgm: this._openMusic ? 1 : 0, sound: this._openEffect ? 1 : 0, vibrate: this._vibrate ? 1 : 0 })
    }

    /**开启背景音乐 */
    public openBGM() {
        this._openMusic = true

        this.music(this._useBgm, true, true)
        this.setStorage()
    }
    /**关闭背景音乐 */
    public closeBGM() {
        this._openMusic = false
        cc.audioEngine.stopMusic()
        this.setStorage()
    }

    /**播放背景音乐 */
    public playBGM(bgm: string) {
        clog.warn('播放', bgm, this._openMusic)
        // if (this._useBgm != bgm) {
        this._useBgm = bgm
        // }
        this.music(bgm, true, true)
    }

    /**暂停bgm */
    public pauseMusic() {
        if (this._openMusic) {
            cc.audioEngine.pauseMusic()
        }
    }
    /**恢复bgm */
    public resumeMusic() {
        clog.log('音频恢复', this._openMusic);

        if (this._openMusic) {
            cc.audioEngine.resumeMusic()
        }
    }

    /**打开音效 */
    public openEffect() {
        this._openEffect = true
        this.setStorage()
    }
    /**关闭音效 */
    public closeEffect() {
        this._openEffect = false
        cc.audioEngine.stopAllEffects()
        this.setStorage()
    }
    /**播放音效 */
    public playEffect(name: string, loop: boolean = false) {
        clog.warn(name);

        this.music(name, false, loop)
    }
    /**停止音效 */
    public stopEffect(name: string) {
        let id = this._musicID.get(name)
        if (id) {
            cc.audioEngine.stopEffect(id)
        }
    }

    /**打开震动 */
    public openVibrate() {
        this._vibrate = true
        this.setStorage()
    }
    /**关闭震动 */
    public closeVibrate() {
        this._vibrate = false
        this.setStorage()
    }

    /**播放震动 */
    public playVibrate() {
        if (this._vibrate) {
            ADControl.ints.vibrateShort()
        }
    }




}