import { Pages, Prefabs, Storey } from "../enum/Integrate";
import { ResControl } from "../resUrl/bundles";
import ViewRoot from "../viewRoot/ViewRoot";
import BundleControl from "./controlBunle/BundleControl";
import inherit from "./root/inherit";


export default class ViewControl extends inherit<ViewControl>() {
    private Canvas: cc.Node = null
    //层级
    private BottomUI: cc.Node = null
    private ViewUI: cc.Node = null
    private TopUI: cc.Node = null
    private MaxUI: cc.Node = null
    private AdUI: cc.Node = null
    /**已显示页面列表 */
    private openViewList: Map<Pages, cc.Node> = new Map()
    private Pages: Map<Pages, cc.Node> = new Map
    private Prefabs: Map<Prefabs, cc.NodePool> = new Map
    private usePrefabList: Map<Prefabs, cc.Node> = new Map()

    public initData(node: cc.Node) {
        this.Canvas = node
        // this.addStorey(Storey.BottomUI)
        // this.addStorey(Storey.ViewUI)
        // this.addStorey(Storey.TopUI)
        // this.addStorey(Storey.MaxUI)
        // this.addStorey(Storey.AdUI)

    }

    /**获得预制体 */
    public async getPrefab(name: Prefabs) {
        let node: cc.Node = null
        if (this.Prefabs.get(name)) {
            clog.warn('获得预制体', Prefabs[name]);
            let NodePool = this.Prefabs.get(name)
            node = NodePool.get()
        } else {
            clog.warn(Prefabs[name], '没有,加载');
            let resData = ResControl.ints.Prefab.get(name)
            if (!resData) {
                clog.error(Prefabs[name], '未注册');
                return
            }
            let prefab: cc.Prefab = await BundleControl.ints.loadAsset(resData) as cc.Prefab
            if (!prefab) return node
            node = cc.instantiate(prefab);
            let NodePool = new cc.NodePool()
            NodePool.put(node)
            this.Prefabs.set(name, NodePool)
        }
        this.usePrefabList.set(name, node)
        return node
    }

    /**回收预制体 */
    public putPrefab(name: Prefabs) {
        let node = this.usePrefabList.get(name)
        if (!node) return
        let NodePool = this.Prefabs.get(name)
        NodePool.put(node)
        this.Prefabs.set(name, NodePool)
        this.usePrefabList.delete(name)
    }

    /**清理掉不再使用的预制体 */
    public delPrefab(name: Prefabs) {
        if (!this.Prefabs.has(name)) return
        this.Prefabs.delete(name)
    }


    private addStorey(name: Storey) {
        let node = new cc.Node
        node.height = this.Canvas.height
        node.width = this.Canvas.width
        node.name = name
        node.parent = this.Canvas
        this[name] = node
    }
    /**预加载页面 */
    public async loadView(names: Pages[]) {
        for (let i in names) {
            let resData = ResControl.ints.ResView.get(names[i])
            if (!resData) {
                clog.error(i, '未注册页面', names);
                return
            }
            let prefab: cc.Prefab = await BundleControl.ints.loadAsset(resData) as cc.Prefab
            let node = cc.instantiate(prefab);
            this.Pages.set(names[i], node)
        }
    }

    /**打开预制体窗口 */
    public async openView<T>(name: Pages, storey: Storey, data?: T, showWait: boolean = true) {
        if (this.openViewList.has(name)) {
            clog.warn('显示已显示', Pages[name]);
            return
        }
        let node: cc.Node = null
        if (this.Pages.has(name)) {
            clog.warn('显示页面', Pages[name]);
            node = this.Pages.get(name)
        } else {
            clog.warn(Pages[name], '没有,加载');
            let resData = ResControl.ints.ResView.get(name)
            if (!resData) {
                clog.error(Pages[name], '未注册');
                return
            }
            if (showWait) {
                this.setWaitView(true)
            }
            let prefab: cc.Prefab = await BundleControl.ints.loadAsset(resData) as cc.Prefab
            node = cc.instantiate(prefab);
            this.Pages.set(name, node)
            if (showWait) {
                this.setWaitView(false)
            }

        }

        let script = node.getComponent(ViewRoot)

        if (!script) {
            script = node.getComponent(Pages[name])
        }

        script && script.initView && script.initView(data)
        this.addView(name, node, storey)
        script && script.showView && script.showView(data)

    }

    private addView(name: Pages, node: cc.Node, storey: Storey) {
        node.active = true

        this.Canvas.addChild(node)
        // this[storey]
        this.openViewList.set(name, node)
    }

    private setWaitView(show: boolean) {
        if (show) {
            let node = this.Pages.get(Pages.WaitView)
            this.addView(Pages.WaitView, node, Storey.MaxUI)
        } else {
            this.closeView(Pages.WaitView)
        }

    }




    /**关闭预制体窗口 */
    public closeView(name: Pages) {
        let node = this.openViewList.get(name)
        if (!node) return
        let script = node.getComponent(ViewRoot)
        if (!script) {
            script = node.getComponent(Pages[name])
        }
        script && script.closeView && script.closeView()

        node.active = false
        node.parent = null
        this.openViewList.delete(name)

    }

    public showWaitView(show: boolean) {
        this.setWaitView(show)
    }

    public async showTip(string: string) {
        if (this.openViewList.has(Pages.TipLab)) {
            let node = this.openViewList.get(Pages.TipLab)
            node.getComponent(ViewRoot).showView(string)
            return
        }
        await this.openView(Pages.TipLab, Storey.TopUI, string, false)

    }



}