
import { bundles } from "../../enum/Integrate";
import { resRoot } from "../../resUrl/bundles";
import DateControl from "../controlData/DateControl";
import inherit from "../root/inherit";


export default class BundleControl extends inherit<BundleControl>() {

    /**已经加载了的资源 */
    private resData: Map<string, cc.Asset | cc.Asset[]> = new Map()
    /**已经加载了的子包 */
    private bundles: Map<bundles, cc.AssetManager.Bundle> = new Map()
    /**加载远程资源 */
    public loadRemote(url: string) {
        return new Promise((resolve, reject) => {
            cc.assetManager.loadRemote(url, (err, res) => {
                if (err) {
                    clog.log('远程资源获取失败', err, url);

                    resolve(null)
                    return
                }
                // clog.log('远程资源获', res)
                resolve(res)
            })
        })

    }

    /**加载本地资源 */
    public async getAsset(url: string, type: typeof cc.Asset, bundle?: bundles) {
        if (this.resData.has(url)) {
            let data = this.resData.get(url)
            return data
        }
        let bund: cc.AssetManager.Bundle = await this.loadBundle(bundle) as cc.AssetManager.Bundle
        return new Promise((resolve, reject) => {
            bund.load(url, type, (err, res) => {
                if (err) {
                    clog.error('资源加载失败', url, err);
                    resolve(null)
                    return
                }
                this.resData.set(url, res)
                resolve(res)
            })
        })
    }

    /**加载本地资源 */
    public async loadAsset<T>(data: resRoot<T>) {
        return await this.getAsset(data.url, data.type, data.bundle)
    }

    /**加载本地资源 */
    public async loadSpr<T>(data: resRoot<T>) {
        let spr = await this.getAsset(data.url, cc.SpriteFrame, data.bundle) as cc.SpriteFrame
        return spr
    }

    /**加载子包 */
    private loadBundle(name: bundles, complete?: Function): Promise<cc.AssetManager.Bundle> {
        if (!name) {
            return Promise.resolve(cc.resources)
        }
        if (this.bundles.has(name)) {
            let bundle: cc.AssetManager.Bundle = this.bundles.get(name)
            return Promise.resolve(bundle)
        }
        return new Promise((resolve, reject) => {
            cc.assetManager.loadBundle(name, cc.AssetManager.Bundle, async (err, bundle: cc.AssetManager.Bundle) => {
                let _bundle = bundle
                if (err) {
                    clog.error('子包加载失败', name, err);

                    resolve(null)

                    complete && complete()
                    return
                    // await DateControl.ints.Delay(0.5)
                    // _bundle = await this.loadBundle(name, complete)
                }
                this.bundles.set(name, _bundle)
                complete && complete()
                resolve(_bundle)
            })
        })
    }

    /**加载分包 */
    public async loadSub(name: bundles, complete: Function) {
        await this.loadBundle(name, complete)
    }

}