import inherit from "../root/inherit";

export default class DateControl extends inherit<DateControl>() {
    /**判断两个时间戳日期相差几天 */
    DayJudge(time: number, time2: number) {
        let nowDate = new Date(time)
        let lastTime = new Date(time2)
        let nowDateFullYear = nowDate.getFullYear()
        let nowDateMonth = nowDate.getMonth()
        let nowDateDate = nowDate.getDate()

        let lastTimeFullYear = lastTime.getFullYear()
        let lastTimeMonth = lastTime.getMonth()
        let lastTimeDate = lastTime.getDate()

        let time3 = Date.UTC(nowDateFullYear, nowDateMonth, nowDateDate)
        let time4 = Date.UTC(lastTimeFullYear, lastTimeMonth, lastTimeDate)
        clog.log(time4, time3);

        let diff = Math.abs(time4 - time3)
        const oneDay = 24 * 60 * 60 * 1000; // 每天的毫秒数
        let day = Math.floor(diff / oneDay)
        return day
    }

    /**
     * 
     * @param time 时间转换成时分秒string
     * @param type type=1：时:分:秒，type=2：时:分 ,type=3：分:秒 type=4显示时:分，时为0时显示分:秒，type=5返回{ hours:时, minutes:分, seconds:秒 }
     * @param interval interval=1 0:0:0 interval=2 0时0分0秒
     * @returns 
     */
    TimeConvert(time: number, type: number = 1, interval: number = 1): string | { hours: number, minutes: number, seconds: number } {
        let total = Math.floor(time)
        const hours = Math.floor(total / 60 / 60)
        const minutes = Math.floor(total / 60 % 60)
        const seconds = Math.floor(total % 60)
        let str = ''
        let hoursinter = ':'
        let minutesinter = ':'
        let secondsinter = ''

        if (interval == 2) {
            hoursinter = '时'
            minutesinter = '分'
            secondsinter = '秒'
        }

        let fun = (time: number) => {
            let stri = ((time > 9 || interval == 1) ? time : `0${time}`)
            return stri
        }


        if (type == 1) {
            str = fun(hours) + `${hoursinter}` + fun(minutes) + `${minutesinter}` + fun(seconds) + `${secondsinter}`
        } else if (type == 2) {
            str = fun(hours) + `${hoursinter}` + fun(minutes) + `${minutesinter}`
        } else if (type == 3) {
            str = fun(minutes) + `${minutesinter}` + fun(seconds) + `${secondsinter}`
        } if (type == 4) {
            if (hours > 0) {
                str = fun(hours) + `${hoursinter}` + fun(minutes) + `${minutesinter}`
            } else {
                str = fun(minutes) + `${minutesinter}` + fun(seconds) + `${secondsinter}`
            }
        } else if (type == 5) {
            return { hours, minutes, seconds }
        }
        return str
    }
    /**延迟s秒 */
    Delay(time: number) {
        return new Promise((resolve, reject) => {
            let a = { b: 0 }
            cc.tween(a)
                .delay(time)
                .call(() => {
                    resolve(true)
                })
                .start()
        })
    }
}