import ADControl from "../../../adSdk/ADControl"
import ZTSDKControl from "../../../adSdk/ZTSDKControl"
import bottle from "../../../game/item/bottle"
import GameView from "../../../view/GameView"
import { EventName } from "../../enum/EventEnum"
import { Pages, Prefabs } from "../../enum/Integrate"
import ArrayUtil from "../../utils/ArrayUtil"
import MathUtil from "../../utils/MathUtil"
import EventControl from "../event/EventControl"
import inherit from "../root/inherit"
import ViewControl from "../ViewControl"
import DateControl from "./DateControl"
import RankControl from "./RankControl"
import StorageConreol from "./StorageConreol"


export default class GameControl extends inherit<GameControl>() {

    /**主页是否有弹窗 */
    haveView: boolean = false

    /**是否开启体力 */
    public useEnergy: boolean = false
    /**打开游戏就进入游戏界面 */
    public firstGame: boolean = true

    /**是否比例改变 */
    public changeRatio: boolean = false
    public ratio: number = 1

    public HideBtn: boolean = false

    config: game_config = {
        "level_version": {
            "data": {
                "percent": 100,
            }
        }
    }


    Scene: Pages = Pages.None

    /**兑换码 */
    rewardCode: string[] = ['MJDS888']




    public loadGameOver: boolean = false


    public isWin: boolean = false

    public gameOver: boolean = false

    private _operate: number = 0


    /**正在使用道具 */
    useProp: boolean = false
    /**是否可以使用道具 */
    get isUseProp() {
        clog.log(this._operate);

        return this._operate == 0
    }
    /**操作一个瓶子+1，操作完-1 */
    set operate(value: number) {
        this._operate += value
        if (this._operate < 0) this._operate = 0
    }

    /**上一次操作的两个瓶子，addBottle加水的瓶子，reduceBottle减水的瓶子,num数量，colorId颜色 */
    lastBottle: { addBottle: bottle, reduceBottle: bottle, num: number, coloId: ColorType } = null



    public colorList: Record<number, ColorValue> = {
        1: { dark: '#fe040a', bleak: "#fe6468", bottom: "#760610" }, //红
        2: { dark: '#00b800', bleak: "#61f261", bottom: "#015c05" }, //绿
        3: { dark: '#069db6', bleak: "#65dcf0", bottom: "#046e68" }, //青
        4: { dark: '#d8d302', bleak: "#fefe62", bottom: "#9b7a09" }, //黄
        5: { dark: '#3f006e', bleak: "#9261b7", bottom: "#530478" }, //紫色
        6: { dark: '#f08402', bleak: "#fec862", bottom: "#774602" }, //橙色
        7: { dark: '#003ad5', bleak: "#618efe", bottom: "#064577" }, //蓝色
        8: { dark: '#a8b4cd', bleak: "#e5effe", bottom: "#505050" }, //灰色
    }

    /**超过最大关卡后使用的随机关卡 */
    exceedLevel: number[] = []




    gameView: GameView = null
    /**游戏时长 */
    time: number = 0


    selectItem: bottle = null
    /**地图坐标 */
    private map_pos7_16: cc.Vec2[][] = []
    /**地图坐标 */
    private map_pos6_16: cc.Vec2[][] = []

    mapType: number = 0
    /**关卡数据 */
    mapData: BottleData[][] = []
    /**格子数量 */
    bottleBlockNum: number = 0
    /**需要完成的关卡数据 */
    bottleNum: number = 0
    colorNum: Record<ColorType, number> = null

    /**完成的关卡数据 */
    private _bottleCompleteNum: number = 0
    /**完成的关卡数据 */
    get bottleCompleteNum() {
        return this._bottleCompleteNum
    }

    /**商店皮肤排序 */
    private _skinZindex: number[] = [1, 3]
    /**皮肤价格 */
    public skinGlod: number[] = [500, 500]
    public skinName: Record<number, string> = { '1': '水彩缤纷', '3': '齿轮律动' }
    get skinZindex() {
        return this._skinZindex
    }

    useSkin: number = 1

    private _items = [Prefabs.block, Prefabs.block2, Prefabs.block3]

    get item() {
        return this._items[this.useSkin - 1]
    }


    private _block: Record<number, cc.NodePool> = {}

    async initData() {
        if (ADControl.ints.isStraight && StorageConreol.ints.isNewPlayer) return

        let firstPos = cc.v2(-300, 100)//cc.v2(-300, 130)
        let firstPos2 = cc.v2(-250, 100)//cc.v2(-300, 130)
        let width = 100//80
        let height = 55

        let se = ADControl.ints.getLaunchOptionsSync();
        if (se.safeArea && se.safeArea.top) {
            firstPos.y -= se.safeArea.top
        }

        for (let i = 0; i < 16; i++) {
            if (!this.map_pos7_16[i]) this.map_pos7_16[i] = []
            if (!this.map_pos6_16[i]) this.map_pos6_16[i] = []
            for (let j = 0; j < 7; j++) {
                this.map_pos7_16[i].push(cc.v2(firstPos.x + width * j, firstPos.y - height * i))
            }
            for (let j = 0; j < 6; j++) {
                this.map_pos6_16[i].push(cc.v2(firstPos2.x + width * j, firstPos2.y - height * i))
            }
        }
        this.exceedLevel = StorageConreol.ints.getStorage('exceedLevel')
        clog.log(this.exceedLevel);

        if (this.exceedLevel.length < this.mapData.length - 2) {
            for (let i = 2; i < this.mapData.length; i++) {
                this.exceedLevel.push(i)
            }
            ArrayUtil.shuffle(this.exceedLevel)
            StorageConreol.ints.setStorage('exceedLevel', this.exceedLevel)
        }
        this.useSkin = StorageConreol.ints.getStorage('useSkin')



        let item = await ViewControl.ints.getPrefab(this._items[this.useSkin - 1])
        if (!item) {
            let index = this._skinZindex.indexOf(this.useSkin)
            this._skinZindex.splice(index)
            this.skinGlod.splice(index)
            this.useSkin = 1
            StorageConreol.ints.setStorage('useSkin', this.useSkin)
            item = await ViewControl.ints.getPrefab(this._items[this.useSkin - 1])
        }
        this._block[this.useSkin] = new cc.NodePool()
        for (let i = 0; i < 20; i++) {
            let node = cc.instantiate(item)
            this._block[this.useSkin].put(node)
        }
        ViewControl.ints.putPrefab(this._items[this.useSkin - 1])



        let data_ = {
            // pos_type: PosType.POS_TYPE_MOD,
            pos_name: '使用皮肤',
            pos_ext: '皮肤',
            pos_sub_ext: "使用皮肤" + this.skinName[this.useSkin],
        }
        ZTSDKControl.ints.onModEnter(data_);

        let rewardCode = StorageConreol.ints.getStorage('rewardCode')
        for (let i = 0; i < rewardCode.length; i++) {
            if (!this.rewardCode.includes(rewardCode[i])) {
                rewardCode.splice(i)
                i--
            }
        }
        let gameData = StorageConreol.ints.getStorage('gameData')
        let score = StorageConreol.ints.getStorage('score')
        if (score == 0 && gameData.level > 1) {
            for (let i = 0; i < gameData.level; i++) {
                let max = 7 + i
                let mini = 5 + i
                if (i > 10) max = 18
                if (i > 5) mini = 10

                let num = MathUtil.randomRangeInt(mini, max)
                score += num
            }
            StorageConreol.ints.setStorage('score', score)
        }

    }

    getTipLab(colorId: number, num: number) {
        let color = ''
        switch (colorId) {
            case 1:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶红色'

                        break
                    case SkinType.SCREW:
                        color = '串红色螺丝'

                        break
                }
                break
            case 2:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶绿色'

                        break
                    case SkinType.SCREW:
                        color = '串绿色螺丝'

                        break
                }
                break
            case 3:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶青色'

                        break
                    case SkinType.SCREW:
                        color = '串青色螺丝'

                        break
                }
                break
            case 4:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶黄色'

                        break
                    case SkinType.SCREW:
                        color = '串黄色螺丝'

                        break
                }
                break
            case 5:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶紫色'

                        break
                    case SkinType.SCREW:
                        color = '串紫色螺丝'

                        break
                }
                break
            case 6:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶橙色'

                        break
                    case SkinType.SCREW:
                        color = '串橙色螺丝'

                        break
                }
                break
            case 7:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶蓝色'

                        break
                    case SkinType.SCREW:
                        color = '串蓝色螺丝'

                        break
                }
                break
            case 8:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶灰色'

                        break
                    case SkinType.SCREW:
                        color = '串灰色螺丝'

                        break
                }
                break
            case 100:
                switch (this.useSkin) {
                    case SkinType.WATER:
                        color = '瓶任意色'

                        break
                    case SkinType.SCREW:
                        color = '串任意色螺丝'

                        break
                }
                break
        }


        let txt = '消除' + num + color

        return txt
    }


    getPos(pos: number[]) {
        if (this.mapType == 0) {
            return this.map_pos7_16[pos[1]][pos[0]]
        }
        if (this.mapType == 1) {
            return this.map_pos6_16[pos[1]][pos[0]]
        }

    }
    /**完成瓶子+1 */
    bottleComplete(index: number) {
        this._bottleCompleteNum++
        this.gameView.bottleState[index] = 1
        this.gameView.data.score++
        this.gameView.setScore()
        if (this.gameView.data.level == 0 && this._bottleCompleteNum > 1) {
            let data_ = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: '完成瓶子' + this._bottleCompleteNum,
                pos_ext: '新手引导',
                pos_sub_ext: ZTSDKControl.ints.version,
                pos_index: (90003 + this._bottleCompleteNum),
            }
            ZTSDKControl.ints.onLevelStart(data_);
        }
    }
    /**检查游戏是否结束 */
    winGame() {
        if (this.bottleNum <= this._bottleCompleteNum) {
            this.isWin = true
            this.gameOver = true
            clog.log('完成了');
            EventControl.ints.emit(EventName.GameWin)
        }
    }

    setGameView(gameView: GameView) {
        if (this.gameView == null) {
            this.gameView = gameView
        }
    }



    initGame() {
        this.useProp = false
        this._operate = 0
        this.time = 0

        this.isWin = false
        this.gameOver = false
        this.selectItem = null
        this.bottleNum = 0
        this.bottleBlockNum = 0
        this._bottleCompleteNum = 0
        this.colorNum = {} as null
        this.lastBottle = null
        this.loadGameOver = false
    }


    gamePause() {
        EventControl.ints.emit(EventName.pause)
    }

    gameRun() {
        EventControl.ints.emit(EventName.run)
    }

    ///***增加初始化类注意适配抖音直玩 */
    /**loading结束后需要加载的资源或者东西 */
    async loadOverInte() {
        this.addNodePool()
        // ADControl.ints.getUpdateManager()
        if (ADControl.ints.isStraight) return

    }

    async getUserInfoData() {
        let key = 'scope.userInfo'
        let result = await ADControl.ints.getSetting(key)
        if (result) {
            let data = await ADControl.ints.getUserData()
            let avatarUrl = StorageConreol.ints.getStorage('avatarUrl')
            let nickName = StorageConreol.ints.getStorage('nickName')

            if (avatarUrl == '') {
                avatarUrl = data.avatarUrl
                nickName = data.nickName
                StorageConreol.ints.setStorage('nickName', nickName)
                StorageConreol.ints.setStorage('avatarUrl', avatarUrl)
                RankControl.ints.setRankData()
                return
            }

            if (nickName != data.nickName) {
                nickName = data.nickName
                StorageConreol.ints.setStorage('nickName', nickName)
            }

            if (avatarUrl != data.avatarUrl) {
                avatarUrl = data.avatarUrl
                StorageConreol.ints.setStorage('avatarUrl', avatarUrl)
            }

        }
    }

    async addNodePool() {

        for (let i = 0; i < this._skinZindex.length; i++) {
            if (!this._block[this._skinZindex[i]]) {
                this._block[this._skinZindex[i]] = new cc.NodePool()
                let item = await ViewControl.ints.getPrefab(this._items[this._skinZindex[i] - 1])
                if (item) {
                    for (let j = 0; j < 25; j++) {
                        let node = cc.instantiate(item)
                        this._block[this._skinZindex[i]].put(node)
                    }
                    ViewControl.ints.putPrefab(this._items[this._skinZindex[i] - 1])
                } else {
                    this._skinZindex.splice(i)
                    this.skinGlod.splice(i)
                    i--
                }

            }

        }

    }

    getBlockNodePool() {
        return this._block[this.useSkin]
    }
}

export interface ColorValue {
    /**深色 */
    dark: string,
    /**浅色 */
    bleak: string,
    /**盒子底 */
    bottom: string
}

/**瓶子数据 */
export interface BottleData {
    /**0表示位置空，对应id对应颜色 ，第二位表示是否有黑色遮挡1是0否*/
    0: number[],
    /**0表示位置空，对应id对应颜色 ，第二位表示是否有黑色遮挡1是0否*/
    1: number[],
    /**0表示位置空，对应id对应颜色 ，第二位表示是否有黑色遮挡1是0否*/
    2: number[],
    /**0表示位置空，对应id对应颜色 ，第二位表示是否有黑色遮挡1是0否*/
    3: number[],
    /**0不锁定，对应id对应颜色，100所有色都可以解锁，第二位表示解锁需要的数量 */
    lock: number[]
    /**位置 */
    pos: number[]
    /**是否看广告解锁的空瓶子1是0否 */
    ad: number
    /**出现顺序 */
    appear?: number
    /**是否已完成 */
    complete?: number
    /**是否显示瓶子 */
    showBottle?: number
}

export enum PropType {
    /**打乱 */
    Disturb = 0,
    /**回退 */
    Back = 1,
    /**加空位 */
    AddBottle = 2
}


export enum SkinType {
    /**水 */
    WATER = 1,
    /**方块 */
    BLOCK = 2,
    /**螺丝 */
    SCREW = 3
}


export enum ColorType {
    /**空位 */
    NONE = 0,
    /**红 */
    RED = 1,
    /**绿 */
    GREEN = 2,
    /**青 */
    CYAN = 3,
    /**黄色 */
    YELLOW = 4,
    /**紫色 */
    PURPLE = 5,
    /**橙色 */
    ORANGE = 6,
    /**蓝色 */
    BLUE = 7,
    /**灰色 */
    GREY = 8,
    /**所有都可以解锁的颜色 */
    BLACK = 100,
}

/** 游戏配置数据 */
export class game_config {
    /** 当前存在版本 */
    level_version: Record<string, {
        /**分流比例 */
        percent: number,
    }>;
}





