import ADControl from "../../../adSdk/ADControl";
import ZTSDKControl from "../../../adSdk/ZTSDKControl";
// import { PosType } from "../../../ZTSDK/GaComponent";
import { EventName } from "../../enum/EventEnum";
import { Pages, Storey } from "../../enum/Integrate";
import EventControl from "../event/EventControl";
import inherit from "../root/inherit";
import ViewControl from "../ViewControl";
import StorageConreol from "./StorageConreol";


export default class GuideControl extends inherit<GuideControl>() {
    private _isGuide:boolean = false
    private _guide: Record<number, number> = {}

    get guide() {
        return this._guide
    }
    /**正在指引 */
    get isGuide() {
        return this._isGuide
    }

    initData() {
        if(ADControl.ints.isStraight && StorageConreol.ints.isNewPlayer) return
        this._guide = StorageConreol.ints.getStorage('guide')
        if (!this._guide[1]) this._guide[1] = 1
    }

    async showGuide(data: { type: number, pos: cc.Vec2, tipePos: cc.Vec2, width: number, height: number, id: number, txt: string }) {
        this._isGuide = true
        let pos_name = ''
        let pos_index = 0
        let have = false
        switch (this._guide[1]) {
            case 2:
                pos_name = '点击瓶子'
                pos_index = 90001
                have = true
                break
            case 3:
                pos_name = '点击倒水'
                pos_index = 90002
                have = true
                break
            case 5:
                pos_name = '二次点击瓶子'
                pos_index = 90003
                have = true
                break
            case 6:
                pos_name = '点击空瓶'
                pos_index = 90004
                have = true
                break
        }
        if (have) {
            let data_ = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: pos_name,
                pos_ext: '新手引导',
                pos_sub_ext: ZTSDKControl.ints.version,
                pos_index: pos_index,
            }
            ZTSDKControl.ints.onLevelStart(data_);
        }


        this._guide[data.id]++

        await ViewControl.ints.openView(Pages.GuideView, Storey.ViewUI)
        EventControl.ints.emit(EventName.ShowGuide, data)
    }

    GuideTxt(data: { pos: cc.Vec2, id: number, txt: string }) {
        this._guide[data.id]++
        EventControl.ints.emit(EventName.GuideTxt, data)
    }

    closeGuide() {
        this._guide[1] = 1
        this._isGuide = false
        ViewControl.ints.closeView(Pages.GuideView)
        StorageConreol.ints.setStorage('guide', this._guide)

    }

}