import inherit from "../root/inherit";

/**随机数类，可以生产随机数组，随机打乱数组顺序 */
export default class RandomControl extends inherit<RandomControl>() {


    /**获得mini到max范围中的一个随机数 */
    getRangeRandom(mini: number, max: number) {
        if (mini > max) {
            let value = max
            max = mini
            mini = value
        }
        return Math.floor(Math.random() * (max - mini) + mini);
    }

    /**获得mini到max范围中的num个不重复的随机数的数组
     * @mini 最小范围
     * @max 最大范围
     * @num 返回几个随机数
     */
    getMultipleRandom(mini: number, max: number, num: number) {
        if ((max - mini) < num) {
            clog.error('返回个数大于数值范围数！！');
            return
        }
        if (mini > max) {
            let value = max
            max = mini
            mini = value
        }
        let vaules: number[] = []
        let vauleObj: object = {}
        let nums: number = 0
        for (let i = 0; i < num; i++) {
            let value = this.getRangeRandom(mini, max)
            if (vauleObj[value] == undefined || vauleObj[value] == null) {
                vaules[nums] = value
                vauleObj[value] = value
                nums++
            } else {
                i--
            }
        }
        return vaules
    }

    /**传入一个一维数组，返回打乱顺序后的一维数组,效率最快 */
    Disrupt<T>(array: T[]) {

        let length: number = array.length
        let nums: number[] = this.getMultipleRandom(0, length, length)
        let _array: T[] = []
        for (let i = 0; i < length; i++) {
            _array[i] = array[nums[i]]
        }

        return _array
    }

    /**传入一个二维数组，返回打乱顺序后的二维数组 */
    getArrayDimension(array: unknown[][]) {

        let summary = new Array()
        let long: number = array.length * array[0].length


        for (let i = 0; i < long; i++) {
            summary[i] = i
        }
        // clog.log(summary);
        summary = this.Disrupt(summary)

        // this.test(summary)
        // clog.log(summary);
        for (let i = 0; i < array.length; i++) {
            for (let j = 0; j < array[i].length; j++) {
                let subscript = summary[j + i * array.length]
                let value = array[Math.floor(subscript / array.length)][subscript % array.length]
                array[Math.floor(subscript / array.length)][subscript % array.length] = array[i][j]
                array[i][j] = value

            }
        }
        return array

    }

    /**传入一个多维数组，返回打乱顺序后的数组 ,效率最慢*/
    getManyArrayDimension(array: any) {

        let long: number = 0
        let oneArray: unknown[] = []

        let ergodic = (array, retType: string) => {
            let oneArrays: unknown[] = oneArray
            for (let i = 0; i < array.length; i++) {
                if (array[i].length != undefined) {
                    ergodic(array[i], retType)
                } else {
                    switch (retType) {
                        case 'oneArrays':
                            oneArrays[long] = array[i]
                            break;
                        case 'arrays':
                            let value = array[i]
                            array[i] = oneArrays[long]
                            oneArrays[long] = value
                            break
                    }
                    long++
                }
            }

            switch (retType) {
                /**返回一维数组 */
                case 'oneArrays':
                    return oneArrays
                /**返回打乱后的多维数组 */
                case 'arrays':
                    return array
            }

        }
        /**多维数组转换为一维数组 */
        let nowOneArray: any
        nowOneArray = ergodic(array, 'oneArrays')

        oneArray = this.Disrupt(nowOneArray)
        long = 0

        let retErgodic = ergodic(array, 'arrays')
        ergodic = null
        // clog.log(retErgodic);

        return retErgodic


    }



    /* 测试**********************************************************
 
 
     // /**一维数组打乱概率统计 */
    // test(num){
    //     let Summary:unknown = []
    //     for (let i = 0; i < num.length; i++) {
    //         Summary[i] = []
    //         for (let j = 0; j < num.length; j++) {
    //             Summary[i][j] = 0
    //         }
    //     }
    //     for (let k = 0; k < 50000; k++) {
    //         let nums = this.Disrupt(num)
    //         for (let i = 0; i < nums.length; i++) {
    //             for(let j=0 ; j< num.length ; j++){
    //                 if(nums[i] == num[j]){
    //                     Summary[i][nums[i]]++
    //                     break
    //                 }
    //             }

    //         }
    //     } 
    //     clog.log(Summary);
    // }
    // /**二维数组打乱概率统计 */
    // towTest(num: unknown[][]){
    //     let Summary:unknown = []

    //     for (let i = 0; i < num.length*num[0].length; i++) {
    //         Summary[i] = []
    //         for (let j = 0; j < num.length; j++) {
    //             Summary[i][j] = []
    //             for(let k=0 ; k<num.length; k++){
    //                 Summary[i][j][k] = 0
    //             }
    //         }
    //     }
    //     for (let k = 0; k < 50000; k++) {
    //         let nums: any = this.getArrayDimension(num)
    //         for (let i = 0; i < nums.length * num[0].length; i++) {
    //             for (let j = 0; j < nums.length; j++) {
    //                 for (let l = 0; l < nums.length; l++) {

    //                     if (nums[j][l] == i) {
    //                         Summary[i][j][l]++
    //                     }
    //                 }
    //             }
    //         }
    //     }
    //     clog.log(Summary);
    // }

    // manyTest(array) {

    //     let long: number = 0
    //     let nums = this.getManyArrayDimension(array)
    //     clog.log(nums);

    //     let oneArray: unknown[] = []
    //     let ergodic = (array) => {
    //         for (let i = 0; i < array.length; i++) {
    //             if (array[i].length != undefined) {
    //                 ergodic(array[i])
    //             } else {
    //                 oneArray[long] = array[i]
    //                 long++
    //             }
    //         }
    //         return oneArray
    //     }
    //     oneArray = ergodic(nums)
    //     clog.log(oneArray);

    //     let Summary: unknown = []
    //     for (let i = 0; i < oneArray.length; i++) {
    //         Summary[i] = []
    //         for (let j = 0; j < oneArray.length; j++) {
    //             Summary[i][j] = 0
    //         }
    //     }

    //     for (let k = 0; k < 50000; k++) {
    //         let long: number = 0
    //         let nums = this.getManyArrayDimension(array)
    //         let oneArray: unknown[] = []
    //         let ergodic = (array) => {
    //             for (let i = 0; i < array.length; i++) {
    //                 if (array[i].length != undefined) {
    //                     ergodic(array[i])
    //                 } else {
    //                     oneArray[long] = array[i]
    //                     long++
    //                 }
    //             }
    //             return oneArray
    //         }
    //         oneArray = ergodic(nums)
    //         let numss = this.Disrupt(oneArray)
    //         for (let i = 0; i < numss.length; i++) {
    //             for (let j = 0; j < oneArray.length; j++) {
    //                 if (numss[i] == oneArray[j]) {
    //                     Summary[i][numss[i]]++
    //                     break
    //                 }
    //             }

    //         }
    //     }

    //     clog.log(Summary);

    //     }


    //     array1(){
    //         // let num = [0,1,2,3,4,5,6,7,8,9]
    //         let num = ['0','1','2','3','4','5','6','7','8','9']
    //         // let num = [0,1,1]
    //         // let num = [0,1,2,3,4,5,6,7,8,9,1,1,1,1,1]
    //         let ran:Random = new Random

    //         // clog.log(ran.Disrupt(num));

    //         ran.test(num)
    //     }

    //     array2(){
    //         let ran:Random = new Random
    //         let num:unknown[][] = []


    //         num[0] = [0,1,2]
    //         num[1] = [3,4,5]
    //         num[2] = [6,7,8]
    //         // num[0] = ['你','好','呀']
    //         // num[1] = ['我','爱','你']
    //         // num[2] = ['你','在','哪']
    //         clog.log(num);

    //         clog.log(ran.getArrayDimension(num))

    //         ran.towTest(num)




    //     }

    //     array3(){
    //         // let nums:any = [0,1,[2,[3,[4,[5]]],6],7,[8,[[9,10],11,[12,[13,14]]]],15]
    //         // let nums:any = [[0,1,2]]
    //         // let nums = [0,1,2]
    //         let nums = [0,1,2,3,4,5,6,7,8,9]
    //         clog.log(nums,'-------->');

    //         let ran:Random = new Random
    //         clog.log(ran.getManyArrayDimension(nums))
    //         // clog.log(nums);


    //         ran.manyTest(nums)



    //     }



}