import ADControl, { platformType } from "../../../adSdk/ADControl";
import MathUtil from "../../utils/MathUtil";
import BundleControl from "../controlBunle/BundleControl";
import inherit from "../root/inherit";
import StorageConreol from "./StorageConreol";


export default class RankControl extends inherit<RankControl>() {

    _rankDataOk: boolean = false

    _rankData: RankType[] = []
    // [
    //     { ranked: 1, nickName: '222', score: 110, openId: '123', avatar: null },
    //     { ranked: 2, nickName: '222', score: 100, openId: '123', avatar: null },
    //     { ranked: 3, nickName: '222', score: 90, openId: '123', avatar: null },
    //     { ranked: 4, nickName: '222', score: 80, openId: '123', avatar: null },
    //     { ranked: 5, nickName: '222', score: 70, openId: '123', avatar: null },
    //     { ranked: 6, nickName: '222', score: 60, openId: '123', avatar: null },
    //     { ranked: 7, nickName: '222', score: 50, openId: '123', avatar: null }
    // ]



    get myRankData() {
        return this._myRankData
    }

    get rankDataOk() {
        return this._rankDataOk
    }

    get rankData() {
        return this._rankData
    }

    private _myRankData: RankType = {} as RankType

    async initData(rankData: RankType[]) {
        if (!cc.sys.isBrowser) {
            this._rankData = []
        }

        let avatarUrl = StorageConreol.ints.getStorage('avatarUrl')
        let nickName = StorageConreol.ints.getStorage('nickName')
        let score = StorageConreol.ints.getStorage('score')
        this._myRankData.nickName
        this._myRankData.ranked = 0
        this._myRankData.nickName = nickName
        this._myRankData.score = score
        this._myRankData.openId = ADControl.ints.openId
        this._myRankData.avatar = null
        if (avatarUrl != '') {
            this._myRankData.avatar = await this.getAvatar(avatarUrl)
        }
        clog.log('获得头像', this._myRankData.avatar, rankData)



        let fun = async (v: RankType, index: number) => {
            let data: RankType = {} as RankType
            data.ranked = v.ranked
            data.nickName = v.nickName
            data.score = v.score
            data.openId = v.openId
            data.avatarUrl = v.avatarUrl
            this._rankData.push(data)
            if (index == rankData.length - 1) {
                // clog.log('排行榜加载完了', this._rankData)

                this._rankData.sort((a, b) => {
                    return b.score - a.score
                })

                if (this._rankData.length > 20) {
                    this._rankData.length = 20
                }

                for (let i = 0; i < this._rankData.length; i++) {
                    if (this._rankData[i].score <= 0) {
                        this._rankData.splice(i)
                        i--
                        continue
                    }
                    this._rankData[i].ranked = i + 1
                }


            }
        }

        for (let i = 0; i < rankData.length; i++) {
            fun(rankData[i], i)
        }

        let _index = 0
        let fun2 = async (index: number) => {
            this._rankData[index].avatar = await this.getAvatar(this._rankData[index].avatarUrl)
            _index++
            if (_index == this._rankData.length) {
                this._rankDataOk = true
                // clog.log('排行榜加载完了', this._rankData)
            }
        }

        for (let i = 0; i < this._rankData.length; i++) {
            fun2(i)
        }

        if (rankData.length == 0) {
            this._rankDataOk = true
        }
        // this._rankDataOk = true

    }

    getRankNum() {
        let index = 0
        let score = this._rankData[this._rankData.length - 1].score - this._myRankData.score
        index = Math.floor(score / 20)
        return 21 + index
    }

    async setRankData() {
        let avatarUrl = StorageConreol.ints.getStorage('avatarUrl')
        let nickName = StorageConreol.ints.getStorage('nickName')
        this._myRankData.nickName = nickName
        if (avatarUrl != '') {

            if (!this._myRankData.avatar) {
                this._myRankData.avatar = await this.getAvatar(avatarUrl)
            }

            let score = StorageConreol.ints.getStorage('score')

            let have = false
            for (let v of this._rankData) {
                if (v.nickName == nickName) {
                    v.score = score
                    have = true
                }
            }

            if (!have) {
                this._myRankData.score = score
                this._rankData.push(this._myRankData)
            }


            this._rankData.sort((a, b) => {
                return b.score - a.score
            })
            if (this._rankData.length > 20) {
                this._rankData.length = 20
            }

            for (let i = 0; i < this._rankData.length; i++) {

                if (this._rankData[i].openId == ADControl.ints.openId) {
                    this._myRankData.ranked = i + 1

                }

                if (this._rankData[i].score <= 0) {
                    this._rankData.splice(i)
                    i--
                    continue
                }

                this._rankData[i].ranked = i + 1

            }
            if (this._myRankData.score == 0) {
                this._myRankData.ranked = 0
            }

            if (!this._rankData.includes(this._myRankData) && this._myRankData.score > 0) {
                this._myRankData.ranked = this.getRankNum()
            }


            // clog.log(this._rankData)
        } else {
            this._myRankData.nickName = nickName
        }
    }

    async getAvatar(url: string) {
        let spr = await this.createImage(url)
        return spr
    }


    async createImage(url: string): Promise<cc.SpriteFrame> {
        return new Promise(async (resolve, reject) => {
            if (ADControl.ints.type == platformType.WX) {
                let image = wx['createImage']();
                image.onload = function () {
                    let texture = new cc.Texture2D();
                    texture.initWithElement(image);
                    texture.handleLoadedTexture();
                    resolve(new cc.SpriteFrame(texture))
                };
                image.src = url;
            } else {
                let data = await BundleControl.ints.loadRemote(url) as cc.Texture2D
                let spr = new cc.SpriteFrame(data)
                resolve(spr)
            }

        })

    }


}


export interface RankType {
    avatar: cc.SpriteFrame
    avatarUrl?: string
    ranked: number,
    nickName: string,
    score: number,
    openId: string,

}