import ADControl from "../../../adSdk/ADControl"
import ZTSDKControl from "../../../adSdk/ZTSDKControl"
import ArrayUtil from "../../utils/ArrayUtil"
import inherit from "../root/inherit"
import ViewControl from "../ViewControl"
import DateControl from "./DateControl"
import { BottleData } from "./GameControl"

export default class StorageConreol extends inherit<StorageConreol>() {

    private userData: UserStorage = null

    /**用户数据 */
    private name: string = 'user'

    private _isNewPlayer: boolean = false

    /**是否新用户 */
    get isNewPlayer() {
        return this._isNewPlayer
    }

    /**默认用户数据 */
    private initUser: UserStorage = {
        userId: 1,
        gameData: {
            level: 0,
            mapData: [],
            boxState: [],
            ratio: 0,
            bottleNum: 0,
            score: 0
        },
        firstLoginTime: Date.now(),
        lastTimeLogin: Date.now(),
        isNew: 0,
        gold: 0,
        energy: 5,
        setting: {
            bgm: 1,
            sound: 1,
            vibrate: 1
        },
        cebianlan: 0,
        showCebianlan: 0,
        guide: {},
        energyTime: 0,
        exceedLevel: [],
        useSkin: 1,
        skins: [1],
        // version:''
        goldNum: 3,
        propNum: [0, 0, 0],
        rewardCode: [],
        score: 0,
        avatarUrl: '',
        nickName: ''
    }


    /**需要每日刷新的值 */
    private everyDayRefData = {
        cebianlan: 0,
        showCebianlan: 0,
        goldNum: 3
    }


    checkUserData(userData, initUserData) {
        let isSave = false
        let data: { userData?, isSave: boolean } = { isSave: false }
        for (let v in initUserData) {
            if (typeof (initUserData[v]) == 'object') {
                if (userData[v] == undefined) {
                    userData[v] = initUserData[v]
                    isSave = true
                } else {
                    let key = Object.keys(userData[v])
                    if (initUserData[v].length == undefined && key.length == 0) {
                        userData[v] = initUserData[v]
                        isSave = true
                    } else {
                        data = this.checkUserData(userData[v], initUserData[v])
                    }
                }

            } else {

                if (userData[v] == undefined) {
                    userData[v] = initUserData[v]
                    isSave = true
                }
            }

        }

        if (data.isSave) {
            isSave = true
        }
        return { userData, isSave }
    }



    public async intiData() {
        let initUser = ArrayUtil.deepClone(this.initUser)
        if (ADControl.ints.isStraight) {
            this.userData = this.read()

            let checkUserData = this.checkUserData(this.userData, initUser)
            if (checkUserData.isSave) {
                this.userData = checkUserData.userData
            }

            if (this.userData.isNew == 0) {
                this._isNewPlayer = true
            }
            return
        }
        clog.log('用户数据初始化');


        let data: UserStorage = null
        // if (!cc.sys.isBrowser) {
        //     let isNewPlay = cc.sys.localStorage.getItem('isNewPlay')
        //     cc.sys.localStorage.removeItem('isNewPlay')
        //     clog.log('isNewPlay', isNewPlay)
        //     data = await ZTSDKControl.ints.getGameDataFromServer(isNewPlay) as UserStorage
        // }

        clog.log('远程数据', data);
        this.userData = this.read()
        clog.log('本地数据', this.userData);

        if (data) {
            if (data.gameData.level > this.userData.gameData.level) {
                this.userData = data
            }
        }


        let checkUserData = this.checkUserData(this.userData, initUser)
        if (checkUserData.isSave) {
            this.userData = checkUserData.userData

            clog.warn('远程数据字段改变保存')
            this.save(this.userData)
        }


        if (this.userData.isNew == 0) {
            clog.log('新用户');
            this.userData.isNew = 1
            this._isNewPlayer = true
            clog.warn('新用户保存')
            this.save(this.userData)
        } else {
            this._isNewPlayer = false
            this.everyDayRef()
        }


        this.userData.useSkin = window['__skin'] || 1
        ADControl.ints.sidebar()
        clog.log('用户数据=====>', this.userData);
    }
    /**每日刷新 */
    everyDayRef() {
        let nowDate = Date.now()
        let day = DateControl.ints.DayJudge(nowDate, this.userData.lastTimeLogin)
        clog.log(9999, day, nowDate, this.userData.lastTimeLogin);

        if (day >= 1) {
            clog.warn('新的一天');

            let everyDayRefData = ArrayUtil.deepClone(this.everyDayRefData)

            let checkUserData = this.checkUserData(this.userData, everyDayRefData)
            this.userData = checkUserData.userData


            this.userData.lastTimeLogin = nowDate
            clog.warn('每日刷新保存')
            this.save(this.userData)
        } else {
            clog.warn('不是新的一天');
        }

    }

    public setStorage<T extends keyof UserStorage>(name: T, data: UserStorage[T]) {
        this.userData[name] = data
        clog.warn(name, '保存')
        this.save(this.userData)
    }

    public getStorage<T extends keyof UserStorage>(name: T) {

        return this.userData[name]
    }

    private _isReport: boolean = true
    private async save(data: UserStorage) {
        // let value = JSON.stringify(data)
        // cc.sys.localStorage.setItem(this.name, value)

        // if (this._isReport && !cc.sys.isBrowser) {
        //     this._isReport = false
        //     ZTSDKControl.ints.saveDataToServer(value)
        //     await DateControl.ints.Delay(10)
        //     this._isReport = true
        // }


    }

    /**读取数据 */
    private read(): UserStorage {

        // let user = cc.sys.localStorage.getItem(this.name)
        // clog.log('读取数据data,', user);
        let initUser = ArrayUtil.deepClone(this.initUser)

        // if (user == null || user == 'null' || user == '') {
        //     user = initUser
        // } else {
        //     user = JSON.parse(user)
        // }


        return initUser
    }

    private _CleanData: boolean = true
    async CleanData() {
        // cc.sys.localStorage.clear()
        // let value = JSON.stringify(this.initUser)
        // cc.sys.localStorage.setItem(this.name, value)
        // ViewControl.ints.showTip('重启游戏')
        // if (this._CleanData && !cc.sys.isBrowser) {
        //     this._CleanData = false
        //     ZTSDKControl.ints.saveDataToServer(value)
        //     await DateControl.ints.Delay(10)
        //     this._CleanData = true
        // }
    }

    removeItem() {
        // if (!cc.sys.isBrowser) {
        //     cc.sys.localStorage.removeItem(this.name)
        //     cc.sys.localStorage.setItem('isNewPlay', 1)
        //     ViewControl.ints.showTip('重启游戏')
        // } else {
        //     ViewControl.ints.showTip('打包后使用')
        // }

    }
}

export interface GameData {
    level: number
    /**继续游戏关卡数据 */
    mapData: BottleData[],
    /**继续游戏盒子数据 */
    boxState: number[][]
    /**完成度 */
    ratio: number
    /**需要完成的数量 */
    bottleNum: number,
    /**关卡获得分数 */
    score: number
}


export interface UserStorage {
    userId: number
    /**首次登陆时间戳 */
    firstLoginTime: number
    gameData: GameData,
    /**金币 */
    gold: number,
    /**体力 */
    energy: number
    setting: { bgm: number, sound: number, vibrate: number }
    /**上一次登录的时间 */
    lastTimeLogin: number
    /**是否新玩家 */
    isNew: number
    /**侧边栏奖励0未完成，1未领取，2已领取 */
    cebianlan: number
    /**是否显示了侧边栏 */
    showCebianlan: number
    /**是否进行了引导 */
    guide: Record<number, number>
    energyTime: number
    /**超过最大关卡使用的随机数据 */
    exceedLevel: number[],
    /**使用的皮肤 */
    useSkin: number
    /**拥有的皮肤 */
    skins: number[]
    /**游戏数据版本 */
    // version:string
    /**购买金币剩余次数 */
    goldNum: number
    /**道具数量 */
    propNum: number[]
    /**已经使用的兑换码 */
    rewardCode: string[]
    /**用户总分 */
    score: number,
    /**用户头像url */
    avatarUrl: string
    /**用户昵称 */
    nickName: string
}
