import inherit from "../root/inherit";
import NodeControl from "./NodeControl";


export default class MultipleController extends inherit<MultipleController>() {

    private clickPos: cc.Vec2;
    /**滑动开关 */
    private slideIsOpen: boolean = true

    private _prohibit: boolean = false
    /**闪烁动画 */
    public opacity(node: cc.Node, time: number) {
        cc.tween(node)
            .repeatForever(
                cc.tween(node)
                    .to(time, { opacity: 0 })
                    .to(time, { opacity: 255 })
            )
            .start()
    }

    /**滑动开关 */
    public slideControl(isOpen: boolean) {
        this.slideIsOpen = isOpen
    }
    /**短暂禁止滑动 */
    public prohibit() {
        this._prohibit = true
        setTimeout(() => { this._prohibit = false }, 200)
    }
    /**旋转晃动*/
    public wobble(node: cc.Node, left: number, right: number, time: number, num: number = 2) {

        let i = 0
        let fun = () => {
            return cc.tween(node)
                .to(time, { angle: left })
                .to(time, { angle: right })
                .call(() => {
                    i++
                    if (i < num) {
                        fun().start()
                    } else {
                        cc.tween(node)
                            .to(time, { angle: 0 })
                            .call(() => {
                                i = 0
                            })
                            .start()
                    }

                })
        }

        return fun()//.start()

    }

    /**呼吸效果 initial原始尺寸进行呼吸*/
    public Breathing(node: cc.Node, max: number, mini: number, time: number, initial: boolean = false) {
        let scaleX = 1
        let scaleY = 1
        if (initial) {
            scaleX = node.scaleX
            scaleY = node.scaleY
        }
        return cc.tween(node)
            .repeatForever(
                cc.tween(node)
                    .to(time, { scaleX: max * scaleX, scaleY: max * scaleY })
                    .to(time, { scaleX: mini * scaleX, scaleY: mini * scaleY })
            )
            .start()
    }
    /**方块显示速度 */
    private anNodeSpeed = 0.2
    public setAnNodeSpeed(speed: number) {
        this.anNodeSpeed = speed
    }
    /**依次显示方块 delayTime延迟几秒执行方法*/
    public showBlock(nodes: cc.Node[], scale: number, time: number = 0.1, funs?: Function, delayTime: number = 0) {
        this.anNodeSpeed = time
        let num = 0
        let fun = (node: cc.Node) => {
            node.active = true
            cc.tween(node)
                .to(this.anNodeSpeed, { scale: scale, opacity: 255 })
                .call(() => {
                    num++
                    if (nodes[num] != undefined) {
                        fun(nodes[num])
                    } else {
                        this.anNodeSpeed = 0.2
                        setTimeout(() => {
                            funs && funs()
                        }, delayTime * 1000)
                    }

                })
                .start()
        }
        if (nodes[num]) {
            fun(nodes[num])
        } else {
            funs && funs()
        }
    }

    /**结算弹出 */
    public finishEject(node: cc.Node, time: number = 0.2, fun?: Function) {
        cc.tween(node)
            .to(time, { scaleX: 2, scaleY: 0.02 }, cc.easeOut(3.0))
            .to(time, { scaleX: 1, scaleY: 1.3 }, cc.easeIn(3.0))
            .to(time, { scaleX: 1, scaleY: 1 })
            .call(() => {
                fun && fun()
            })
            .start()

    }
    /**弹出框效果 */
    public eject(node: cc.Node, bg?: cc.Node) {
        return new Promise((resolve, reject) => {
            let oldScale = node.scale
            let setScale = oldScale * 1.1
            node.scale = 0
            if (bg) {
                bg.opacity = 0
                cc.tween(bg)
                    .to(0.2, { opacity: 190 })
                    .start()
            }

            cc.tween(node)
                .to(0.1, { scale: setScale })
                .to(0.1, { scale: oldScale })
                .call(() => {
                    resolve(true)
                })
                .start()
        })

    }
    /**旋转 */
    public rotate(node: cc.Node, time: number = 2) {
        cc.tween(node)
            .repeatForever(
                cc.tween(node)
                    .to(time, { angle: 360 })
                    .call(() => { node.angle = 0 })
            )
            .start()
    }
    /**
     * 
     * @param node 
     * @param thar 
     * @param offSlideFun 是否注销滑动后执行的方法
     */
    public offSlide(node: cc.Node, thar: any, offSlideFun?: boolean) {
        node.off(cc.Node.EventType.TOUCH_START, this.ClickDown, thar);
        node.off(cc.Node.EventType.TOUCH_END, this.ClickUp, thar);
        node.off(cc.Node.EventType.TOUCH_CANCEL, this.ClickUp, thar);
        if (offSlideFun && this.slideFun) {
            this.slideFun = null
        }
    }

    /**注册的滑动事件后需要执行的方法 */
    private slideFun: { Up?: Function, Down?: Function, Left?: Function, Right?: Function } = null//{ Up: null, Down: null, Left: null, Right: null }
    private _isSlide: boolean = false
    /**
     * 
     * @param node 注册的节点
     * @param thar 类
     * @param fun 滑动后执行的方法
     */
    public onSlide(node: cc.Node, thar: any, fun?: { Up?: Function, Down?: Function, Left?: Function, Right?: Function }) {

        node.on(cc.Node.EventType.TOUCH_START, this.ClickDown, thar);
        // node.on(cc.Node.EventType.TOUCH_MOVE, this.ClickDown, thar);
        node.on(cc.Node.EventType.TOUCH_END, this.ClickUp, thar);
        node.on(cc.Node.EventType.TOUCH_CANCEL, this.ClickUp, thar);
        if (fun) {
            if (!this.slideFun) {
                this.slideFun = fun
            } else {
                clog.warn('滑动方法已注册');

            }
        }
    }

    /**重新注册滑动后执行的方法 */
    public onSlideFun(fun: { Up?: Function, Down?: Function, Left?: Function, Right?: Function }) {
        this.slideFun = fun
    }

    /**触摸时间 */
    // private clickTime: number = 0
    // private clickFun
    // private maxClickTime: number = 100

    /**初始到结束的距离超过多少像素才属于滑动 */
    private miniDistance: number = 100
    private ClickDown(event: cc.Event.EventTouch) {
        if (!this.clickPos) {
            this._isSlide = true
            this.clickPos = event.getLocation();
        }
        // clog.time('click');
        // this.clickTime = 0
        // this.clickFun = setInterval(() => {
        //     this.clickTime++
        //     if (this.maxClickTime < this.clickTime) {
        //         clearInterval(this.clickFun)
        //     }
        // })
    }

    private ClickUp(event: cc.Event.EventTouch) {
        // clearInterval(this.clickFun)

        // clog.log(this.clickTime * 4);

        // clog.timeEnd('click');
        let clickPos = this.clickPos
        this.clickPos = null
        if (!this._isSlide) return
        this._isSlide = false

        let thar = MultipleController.ints

        //特殊情况
        // let itemBlock: item = event.currentTarget.getComponent(item)
        // if (itemBlock && event.type == cc.Node.EventType.TOUCH_END) {
        //     itemBlock.clickBlock(event)
        // }

        // clog.log(thar._prohibit, !thar.slideIsOpen, this.clickPos);

        if (thar._prohibit || !thar.slideIsOpen || clickPos == null) return

        let type: SlideType = null
        let distance = clickPos.sub(event.getLocation()).mag();
        // clog.log("滑动距离distance:", distance);

        if (distance < thar.miniDistance) return
        let angle = NodeControl.ints.getAngle(clickPos, event.getLocation())

        // clog.log("滑动距离角度", angle);

        let deflection = 20
        if (0 - deflection <= angle && angle <= 0 + deflection) {
            type = SlideType.Right
        } else if (90 - deflection <= angle && angle <= 90 + deflection) {
            type = SlideType.Up
        } else if (180 - deflection <= angle && angle <= 180 + deflection) {
            type = SlideType.Left
        } else if ((270 - deflection <= angle && angle <= 270) || (angle >= -90 && angle <= -90 + deflection)) {
            type = SlideType.Down
        }
        switch (type) {
            case SlideType.Up:
                clog.log('Up');
                thar.slideFun.Up && thar.slideFun.Up()
                break
            case SlideType.Down:
                clog.log('Down');
                thar.slideFun.Down && thar.slideFun.Down()
                break
            case SlideType.Left:
                clog.log('Left');
                thar.slideFun.Left && thar.slideFun.Left()
                break
            case SlideType.Right:
                clog.log('Right');
                thar.slideFun.Right && thar.slideFun.Right()
                break
        }
    }
}

export enum SlideType {
    None,
    Up,
    Down,
    Left,
    Right,
}
