import inherit from "../root/inherit";

/**坐标点类*/
export default class NodeControl extends inherit<NodeControl>() {

    /**计算两点距离 */
    public getDistance(p1: cc.Vec2, p2: cc.Vec2): number {
        let A: number = p1.x - p2.x;
        let B: number = p1.y - p2.y;
        let C: number = Math.sqrt(A * A + B * B)
        return C
    }

    /**计算p2点在p1点的角度，三点钟方向为0度,-90到270度，两点需要在相同原点坐标系下
     * @p1 坐标1，需要计算角度的基准点
     * 
     * @p2 坐标2，需要计算角度的点
     * 
     * O p2
     * 
     * |
     * 
     * |  90°
     * 
     * O p1———— */
    public getAngle(p1: cc.Vec2, p2: cc.Vec2): number {
        let angle: number = Math.atan((p2.y - p1.y) / (p2.x - p1.x)) * 180 / Math.PI
        if (p1.x > p2.x) {
            angle += 180
        }
        return angle
    }

    /**世界坐标转换为节点坐标
     * 
     * @node 需要转换到的节点
     * 
     * @worldPoint 需要转换的世界坐标
     * 
     */
    public worldConvertLocalPointAR(node: cc.Node, worldPoint: cc.Vec2): cc.Vec2 {
        if (node) {
            return node.convertToNodeSpaceAR(worldPoint);
        }
        clog.error('世界坐标转换失败，数据为空！');
        return null
    }

    /**节点坐标转换到另一个节点坐标
     * 
     * node1转换到node2 */
    public nodeConvertLocalPointAR(node1: cc.Node, node2: cc.Node): cc.Vec2 {
        if (node1 && node2) {
            let world = node1.parent.convertToWorldSpaceAR(node1.getPosition())
            return this.worldConvertLocalPointAR(node2, world)
        }
        clog.error('节点坐标转换失败，数据为空！');
        return cc.v2(0, 0)
    }

    /**根据角度和距离获得相对坐标,90度朝上-90度朝下,
     * @angle 角度
     * @distance 距离
     * @datum 基准点
     */
    public getCoordinate(angle: number, distance: number, datum: cc.Vec2 = cc.v2(0, 0)): cc.Vec2 {
        let coordinate: cc.Vec2 = cc.v2(0, 0)
        coordinate.x = Math.cos(Math.PI / 180 * angle) * distance + datum.x
        coordinate.y = Math.sin(Math.PI / 180 * angle) * distance + datum.y
        return coordinate
    }






}