import { EventName } from "../../enum/EventEnum";
import inherit from "../root/inherit";

/**自定义事件类 */
export default class EventControl extends inherit<EventControl>() {

    private eventLists: Map<EventName, { events: Event[] }> = new Map()

    on(name: EventName, fun: Function, thar: any) {
        this.onAll(name, fun, thar, false)
    }

    onec(name: EventName, fun: Function, thar: any) {
        this.onAll(name, fun, thar, true)
    }

    emit(name: EventName, ...value: any) {
        if (this.eventLists.has(name)) {
            let data = this.eventLists.get(name)
            data.events.forEach((v) => {
                let fun = v.fun.bind(v.thar)
                fun(...value)
                if (v.isOnec) {
                    this.off(name)
                }
            })

        }
        clog.log(this.eventLists);

    }


    private onAll(name: EventName, fun: Function, thar: any, isOnec: boolean) {

        let event: Event = { name, fun, thar, isOnec }
        let data = this.eventLists.get(name)
        if (data) {
            for (let v of data.events) {
                if (v.thar == thar) {
                    clog.warn('已注册同名的其他事件', name);
                    return
                }
            }
        }

        if (!data) {
            data = { events: [] }
        }
        data.events.push(event)
        this.eventLists.set(name, data)

    }


    off(name: EventName, fun?: Function, thar?: any) {
        let data = this.eventLists.get(name)
        let index = -1
        if (data && data.events.length != 0 && thar) {
            for (let i = 0; i < data.events.length; i++) {
                if (data.events[i].thar == thar) {
                    index = i
                    break
                }
            }
            if (index != -1) {
                data.events.splice(index, 1)
                this.eventLists.set(name, data)
                if (data.events.length == 0) {
                    this.eventLists.delete(name)
                }
                return
            }
        } else if (data && data.events.length != 0 && fun) {
            index = -1
            for (let i = 0; i < data.events.length; i++) {
                if (data.events[i].fun == fun) {
                    index = i
                    break
                }
            }

            if (index != -1) {
                data.events.splice(index, 1)
                this.eventLists.set(name, data)
                if (data.events.length == 0) {
                    this.eventLists.delete(name)
                }
                return
            }
        }
        this.eventLists.delete(name)

    }

}

interface Event {
    name: EventName
    fun: Function
    thar: any
    isOnec: boolean
}
