import inherit from "../control/root/inherit";
import { Pages, Prefabs, bundles, Spriteframe } from "../enum/Integrate";

export class ResControl extends inherit<ResControl>() {
    time:number = 0


    private _ResView: Map<Pages, ResView> = new Map()
    private _Prefab: Map<Prefabs, Prefab> = new Map()
    private _Sprite: Map<Spriteframe, Sprite> = new Map()
    get ResView() {
        return this._ResView
    }
    get Prefab() {
        return this._Prefab
    }

    get Sprite() {
        return this._Sprite
    }

    public initData() {
        this._ResView = this.loadRes(ResView)
        this._Prefab = this.loadRes(Prefab)
        this._Sprite = this.loadRes(Sprite)
    }

    private loadRes<T>(data: resRoot<T>[]) {
        let res: Map<T, resRoot<T>> = new Map()
        data.forEach((value) => {
            res.set(value.name, value)
        })
        return res
    }
}

const ResView: ResView[] =
    [
        { name: Pages.WinView, url: 'view/WinView', type: cc.Prefab, bundle: bundles.prefab },
        { name: Pages.WaitView, url: 'view/WaitView', type: cc.Prefab, bundle: bundles.prefab },
        { name: Pages.TipLab, url: 'view/TipLab', type: cc.Prefab, bundle: bundles.prefab },
        { name: Pages.TipBubble, url: 'view/TipBubble', type: cc.Prefab, bundle: bundles.prefab },
        { name: Pages.GuideView, url: 'view/GuideView', type: cc.Prefab, bundle: bundles.prefab },
        { name: Pages.GMView, url: 'view/GMView', type: cc.Prefab, bundle: bundles.prefab },

    ]

const Prefab: Prefab[] =
    [
        { name: Prefabs.block, url: 'game/item/block', type: cc.Prefab, bundle: bundles.prefab },
        { name: Prefabs.block2, url: 'game/item/block2', type: cc.Prefab, bundle: bundles.prefab },
        { name: Prefabs.block3, url: 'game/item/block3', type: cc.Prefab, bundle: bundles.prefab },
    ]


const Sprite: Sprite[] =
    [
        // { name: Spriteframe.combo_1, url: 'image/game/combo/1', type: cc.Prefab, bundle: bundles.res },

    ]


interface ResView extends resRoot<Pages> {
    name: Pages
}

interface Prefab extends resRoot<Prefabs> {
    name: Prefabs
}

interface Sprite extends resRoot<Spriteframe> {
    name: Spriteframe
}

export interface resRoot<T> {
    name: T
    url: string
    type: typeof cc.Asset
    bundle: bundles
}
