import MathUtil from "./MathUtil";

export default class ArrayUtil {
    /**l
     * 
     * @param arr 数组乱序
     */
    public static shuffle(arr: any[]) {
        if (arr == null || arr.length == 0)
            return arr;
        let length = arr.length;
        for (let i = 0; i < length; i++) {
            let j = MathUtil.randomRangeInt(0, length)
            let temp = arr[i];
            arr[i] = arr[j]
            arr[j] = temp;
        }
        return arr;
    }

    /**
     * 
     * @param arr 浅拷贝
     */
    public static clone<T>(arr: T[], out?: T[]) {
        if (!arr) {
            return []
        }
        if (!out) {
            out = []
        }
        for (let i = 0, len = arr.length; i < len; i++) {
            out.push(arr[i])
        }
        return out;
    }
    /**
     * 
     * @param arr 浅拷贝
     */
    public static isEmpty(arr: any[]) {
        return !arr || arr.length == 0;
    }

    /**删除指定元素*/
    public static splice<T>(arr: T[], target: T) {
        if (arr && arr.length > 0 && arr.includes(target)) {
            let index = arr.indexOf(target)
            arr.splice(index, 1)
        }
    }

    /**深拷贝 */
    public static deepClone(obj) {
        let _obj = JSON.stringify(obj),
            objClone = JSON.parse(_obj);
        return objClone
    }

}
