import ZTSDKControl from "../../adSdk/ZTSDKControl";
import StateControl from "../control/StateControl";

const { ccclass, property } = cc._decorator;

@ccclass
export default class ViewRoot extends cc.Component {

    protected onBtnList: cc.Node[] = []


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
    }
    /**页面显示前 */
    initView<T>(data?: T) {
        clog.log('initView', this.name);

    }


    /**页面显示后 */
    showView<T>(data?: T) {
        clog.log('showView', this.name);

    }
    /**页面关闭前 */
    closeView() {
        clog.log('closeView', this.name);
        while (this.onBtnList.length > 0) {
            this.offBtn(this.onBtnList[0])
        }
    }

    /**
     * 
     * @param node 注册的节点
     * @param callback 点击执行的方法
     * @param target 对象
     * @param palyClickEffect 是否播放点击音效，默认是
     * @param effectName 播放的点击音效，默认CLICK
     */
    onBtn(node: cc.Node, callback: Function, target?: any, palyClickEffect: boolean = true) {
        if (!node) return
        let fun = () => {
            if (palyClickEffect) {
                StateControl.ints.playEffect('click')
            }

            callback.call(target)
        }
        let btuton = node.getComponent(cc.Button)
        if (!btuton) {
            btuton = node.addComponent(cc.Button)
            btuton.target = node
            btuton.interactable = true
            btuton.transition = cc.Button.Transition.SCALE
        }

        node.on('click', fun, target)
        if (!this.onBtnList.includes(node)) {
            this.onBtnList.push(node)
        }

    }

    offBtn(node: cc.Node) {
        node.off('click')
        let index = this.onBtnList.indexOf(node)
        if (index != -1) {
            this.onBtnList.splice(index, 1)
        }
        // clog.log(this.onBtnList);

    }

    // update (dt) {}
}
