// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class testBlock extends cc.Component {

    @property(cc.Node)
    block: cc.Node = null;
    @property(cc.Node)
    btnEmpty: cc.Node = null;

    @property(cc.Node)
    bottleTop: cc.Node = null;

    @property(cc.Label)
    posLab: cc.Label = null;



    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    setData(data) {
        this.block.active = false
        this.posLab.string = data[0] + '-' + data[1]
        this.onBtn()
    }

    onBtn() {
        this.node.on('click', () => {
            this.block.active = !this.block.active
        })
        this.btnEmpty.on('click', () => {
            this.bottleTop.active = !this.bottleTop.active
        })
    }

    offBtn() {
        this.node.off('click')
        this.btnEmpty.off('click')
    }

    changeMap() {
        this.node.getComponent(cc.Sprite).enabled = !this.node.getComponent(cc.Sprite).enabled
        this.posLab.node.active = !this.posLab.node.active
        this.btnEmpty.active = !this.btnEmpty.active

        if (!this.posLab.node.active) {
            this.offBtn()
        } else {
            this.onBtn()
        }
    }



    protected onDisable(): void {
        this.offBtn()
    }

    // update (dt) {}
}
