import ADControl from "../adSdk/ADControl";
import GameControl from "../manage/control/controlData/GameControl";
import RankControl from "../manage/control/controlData/RankControl";
import StorageConreol from "../manage/control/controlData/StorageConreol";
import EventControl from "../manage/control/event/EventControl";
import ViewControl from "../manage/control/ViewControl";
import { EventName } from "../manage/enum/EventEnum";
import { Pages, Storey } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";
import testBlock from "../test/testBlock";

const { ccclass, property } = cc._decorator;

@ccclass
export default class GMView extends ViewRoot {

    @property(cc.Node)
    home: cc.Node = null;
    @property(cc.Node)
    game: cc.Node = null;

    @property(cc.Label)
    nameLab: cc.Label = null;
    @property(cc.Label)
    urlLab: cc.Label = null;
    @property(cc.Label)
    scoreLab: cc.Label = null;

    @property(cc.Node)
    btnWinGame: cc.Node = null;
    @property(cc.Node)
    btnNotAd: cc.Node = null;
    @property(cc.Node)
    btnNotAd2: cc.Node = null;

    @property(cc.Node)
    btnSelLv: cc.Node = null;
    @property(cc.EditBox)
    EditBoxSelLv: cc.EditBox = null;

    @property(cc.Node)
    btnNextLv: cc.Node = null;

    @property(cc.Node)
    btnCleanData: cc.Node = null;
    @property(cc.Node)
    btnCleanData2: cc.Node = null;
    @property(cc.Node)
    btnAddGold: cc.Node = null;
    @property(cc.Node)
    btnAddGold2: cc.Node = null;

    @property(cc.Node)
    btnTest: cc.Node = null;

    @property(cc.Node)
    btnTestMap: cc.Node = null;
    @property(cc.Node)
    btnDeadlock: cc.Node = null;

    @property(cc.Node)
    btnShowLock: cc.Node = null;
    @property(cc.Node)
    btnSetMap: cc.Node = null;
    @property(cc.Node)
    btnChangeMap: cc.Node = null;

    @property(cc.Node)
    btnRemoveItem: cc.Node = null;
    @property(cc.Node)
    btnRemoveItem2: cc.Node = null;

    @property(cc.Node)
    btnShowDebug: cc.Node = null;
    @property(cc.Node)
    btnGetProp: cc.Node = null;

    @property(cc.Node)
    btnDebug: cc.Node = null;
    @property(cc.Node)
    btnHideBtn: cc.Node = null;
    @property(cc.Node)
    btnEnter: cc.Node = null;
    @property(cc.Node)
    btnPostMessage: cc.Node = null;
    @property(cc.Node)
    btnAddScore: cc.Node = null;
    @property(cc.EditBox)
    EditBoxScore: cc.EditBox = null;




    @property(cc.Node)
    btnClose: cc.Node = null;




    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    showView<T>(data?: T): void {
        super.showView()
        this.onBtn(this.btnClose, this.onBtnClose, this)
        this.onBtn(this.btnWinGame, this.onBtnWinGame, this)
        this.onBtn(this.btnNotAd, this.onBtnNotAd, this)
        this.onBtn(this.btnNotAd2, this.onBtnNotAd, this)
        this.onBtn(this.btnSelLv, this.onBtnSelLv, this)
        this.onBtn(this.btnNextLv, this.onBtnNextLv, this)
        this.onBtn(this.btnCleanData, this.onBtnCleanData, this)
        this.onBtn(this.btnCleanData2, this.onBtnCleanData, this)
        this.onBtn(this.btnAddGold, this.onBtnAddGold, this)
        this.onBtn(this.btnAddGold2, this.onBtnAddGold, this)
        this.onBtn(this.btnTest, this.onBtnTest, this)
        this.onBtn(this.btnTestMap, this.onBtnTestMap, this)
        this.onBtn(this.btnDeadlock, this.onBtnDeadlock, this)
        this.onBtn(this.btnShowLock, this.onBtnShowLock, this)
        this.onBtn(this.btnSetMap, this.onBtnSetMap, this)
        this.onBtn(this.btnChangeMap, this.onBtnChangeMap, this)
        this.onBtn(this.btnRemoveItem, this.onBtnRemoveItem, this)
        this.onBtn(this.btnRemoveItem2, this.onBtnRemoveItem, this)
        this.onBtn(this.btnShowDebug, this.onBtnShowDebug, this)
        this.onBtn(this.btnGetProp, this.onBtnGetProp, this)
        this.onBtn(this.btnDebug, this.onBtnDebug, this)
        this.onBtn(this.btnHideBtn, this.onBtnHideBtn, this)
        this.onBtn(this.btnEnter, this.onBtnEnter, this)
        this.onBtn(this.btnPostMessage, this.onBtnPostMessage, this)
        this.onBtn(this.btnAddScore, this.onBtnAddScore, this)

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);

        let nickName = StorageConreol.ints.getStorage('nickName')
        let avatarUrl = StorageConreol.ints.getStorage('avatarUrl')

        this.nameLab.string = '用户昵称：' + nickName

        this.urlLab.string = '头像链接：' + (avatarUrl == '' ? '没有' : '有')
        this.scoreLab.string = '积分：' + RankControl.ints.myRankData.score + '分'

        this.home.active = data == 1
        this.game.active = data == 2
    }

    closeView(): void {
        super.closeView()
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        EventControl.ints.emit(EventName.showWxBtn)
    }

    onKeyDown(event) {
        clog.log(event.keyCode);

        switch (event.keyCode) {
            case cc.macro.KEY.a:
                this.onBtnWinGame()
                break;
            case cc.macro.KEY.d:
                this.onBtnNextLv()
                break;
        }
    }



    onBtnWinGame() {
        EventControl.ints.emit(EventName.GameWin)
        ViewControl.ints.closeView(Pages.GMView)
    }

    onBtnNotAd() {
        let notAD = ADControl.ints.notAD()
        if (notAD) {
            this.btnNotAd.children[0].children[0].getComponent(cc.Label).string = '免广:开'
            this.btnNotAd2.children[0].children[0].getComponent(cc.Label).string = '免广:开'
        } else {
            this.btnNotAd.children[0].children[0].getComponent(cc.Label).string = '免广:关'
            this.btnNotAd2.children[0].children[0].getComponent(cc.Label).string = '免广:关'
        }
    }

    onBtnSelLv() {
        let lv = this.EditBoxSelLv.string
        let level = Math.floor(parseInt(lv))
        if (level <= 0 || lv == '') return
        let data = StorageConreol.ints.getStorage('gameData')
        data.level = level - 1
        data.boxState = []
        data.mapData = []
        data.ratio = 0
        data.score = 0
        StorageConreol.ints.setStorage('gameData', data)
        GameControl.ints.gameView.init()
        ViewControl.ints.closeView(Pages.GMView)
    }

    onBtnNextLv() {
        ADControl.ints.keyID++
        let data = StorageConreol.ints.getStorage('gameData')
        data.level++
        data.boxState = []
        data.mapData = []
        data.ratio = 0
        data.score = 0
        StorageConreol.ints.setStorage('gameData', data)
        GameControl.ints.gameView.init()
        ViewControl.ints.closeView(Pages.GMView)
    }

    onBtnCleanData() {
        StorageConreol.ints.CleanData()
    }

    onBtnRemoveItem() {
        StorageConreol.ints.removeItem()
    }

    onBtnShowDebug() {//显示合批
        cc.sys.localStorage.setItem('showDebug', 1)
    }

    async onBtnGetProp() {
        await ViewControl.ints.openView(Pages.StraightView, Storey.TopUI)
        ViewControl.ints.closeView(Pages.GMView)
    }

    onBtnDebug() {//显示打印
        cc.sys.localStorage.setItem('__debug', 1)
        ViewControl.ints.showTip('重启游戏生效')
    }

    onBtnHideBtn() {
        GameControl.ints.HideBtn = true
        EventControl.ints.emit(EventName.OpenGM)
    }

    onBtnEnter() {
        // let enter = cc.sys.localStorage.getItem('__enter')
        // if (enter == 1) {
        //     enter = 2
        //     this.btnEnter.children[0].children[0].getComponent(cc.Label).string = '进入游戏页'
        // } else {
        //     enter = 1
        //     this.btnEnter.children[0].children[0].getComponent(cc.Label).string = '进入主页'
        // }
        // cc.sys.localStorage.setItem('__enter', enter)

    }

    onBtnPostMessage() {
        let score = StorageConreol.ints.getStorage('score')
        ADControl.ints.postMessage([{ key: 'score', value: JSON.stringify(score) }])
        ADControl.ints.setUserCloudStorage([{ key: 'score', value: score + '' }])
    }

    onBtnAddScore() {
        let score = this.EditBoxScore.string
        let sc = Math.floor(parseInt(score))
        if (score == '' || Number.isNaN(sc)) return
        StorageConreol.ints.setStorage('score', sc)
        RankControl.ints.myRankData.score = sc
        ADControl.ints.postMessage([{ key: 'score', value: JSON.stringify(sc) }])
        ADControl.ints.setUserCloudStorage([{ key: 'score', value: score + '' }])
        this.scoreLab.string = '积分：' + sc + '分'
    }

    onBtnAddGold() {
        let Gold = StorageConreol.ints.getStorage('gold')

        StorageConreol.ints.setStorage('gold', Gold + 10000)
        EventControl.ints.emit(EventName.ChangeItemCommon)
        EventControl.ints.emit(EventName.RedDrop)

    }

    onBtnTest() {
        let data = GameControl.ints.gameView.updataWeight()
        console.log(data);
        if (cc.sys.isBrowser) {
            console.log(GameControl.ints.lastBottle);

        }
        GameControl.ints.gameView.saveData()
    }

    onBtnTestMap() {
        let data = StorageConreol.ints.getStorage('gameData')
        data.boxState = []
        data.mapData = []
        data.ratio = 0
        data.score = 0
        StorageConreol.ints.setStorage('gameData', data)
        GameControl.ints.gameView.init(1)
        ViewControl.ints.closeView(Pages.GMView)

    }

    onBtnDeadlock() {
        GameControl.ints.gameView.deadlock()

    }

    onBtnShowLock() {
        let bottle = GameControl.ints.gameView.bottle
        for (let key in bottle) {
            bottle[key].showBlock()
        }
        ViewControl.ints.closeView(Pages.GMView)
    }

    onBtnSetMap() {
        if (!cc.sys.isBrowser) return
        GameControl.ints.gameView.init(2)
        ViewControl.ints.closeView(Pages.GMView)
    }

    onBtnChangeMap() {
        for (let node of GameControl.ints.gameView.mapNode.children) {
            let test = node.getComponent(testBlock)
            if (!test) {
                ViewControl.ints.showTip('没有测试地图不要点！！!')
                break
            }
            test.changeMap()
        }
    }

    async onBtnClose() {
        ViewControl.ints.closeView(Pages.GMView)
    }

    // update (dt) {}
}
