import StateControl from "../manage/control/StateControl";
import ViewControl from "../manage/control/ViewControl";
import GameControl, { BottleData, ColorType, PropType, SkinType } from "../manage/control/controlData/GameControl";
import { bundles, Pages, Prefabs, Spriteframe, Storey } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";
import EventControl from "../manage/control/event/EventControl";
import { EventName } from "../manage/enum/EventEnum";
import ArrayUtil from "../manage/utils/ArrayUtil";
import DateControl from "../manage/control/controlData/DateControl";
import bottle from "../game/item/bottle";
import StorageConreol, { GameData } from "../manage/control/controlData/StorageConreol";
import boxItem from "../game/item/boxItem";
import ADControl, { platformType } from "../adSdk/ADControl";
import GuideControl from "../manage/control/controlData/GuideControl";
import NodeControl from "../manage/control/controlNode/NodeControl";
// import { PosType } from "../ZTSDK/GaComponent";
import ZTSDKControl from "../adSdk/ZTSDKControl";
import MathUtil from "../manage/utils/MathUtil";
import BundleControl from "../manage/control/controlBunle/BundleControl";
import { ResControl } from "../manage/resUrl/bundles";
import testBlock from "../test/testBlock";
import MultipleController from "../manage/control/controlNode/MultipleController";
import RankControl from "../manage/control/controlData/RankControl";


const { ccclass, property } = cc._decorator;

@ccclass
export default class GameView extends ViewRoot {

    @property(cc.Sprite)
    bg: cc.Sprite = null;


    @property(cc.Node)
    btnSetting: cc.Node = null;
    @property(cc.Node)
    btnDisturb: cc.Node = null;
    @property(cc.Node)
    btnBack: cc.Node = null;
    @property(cc.Node)
    btnAddBottle: cc.Node = null;

    @property(cc.Node)
    mapNode: cc.Node = null;

    @property(cc.Node)
    topMap: cc.Node = null;

    @property(cc.Node)
    boxNode: cc.Node = null;
    @property(cc.Node)
    gameNode: cc.Node = null;
    @property(cc.Label)
    level: cc.Label = null;

    @property(cc.Node)
    btnOpenGM: cc.Node = null;

    @property(cc.Node)
    combo: cc.Node = null;

    @property(cc.Node)
    finger: cc.Node = null;

    @property(cc.Node)
    btnPlayNow: cc.Node = null;

    @property(cc.Node)
    showPlayNow_Node: cc.Node = null;
    // @property(cc.Node)
    // problem: cc.Node = null;


    // @property(cc.Node)
    // scoreNode: cc.Node = null;
    // @property(cc.Label)
    // scoreLab: cc.Label = null;




    @property([cc.SpriteFrame])
    btns1: cc.SpriteFrame[] = [];
    @property([cc.SpriteFrame])
    btns2: cc.SpriteFrame[] = [];

    @property([cc.SpriteFrame])
    bgs: cc.SpriteFrame[] = [];




    private mapData: BottleData[] = []
    /**瓶子状态，1完成，0未完成 */
    public bottleState: number[] = []
    /**瓶子 */
    private _bottle: Record<number, bottle> = {}
    /**有颜色锁定的瓶子 */
    private _unLockBottle: Record<number, { data: bottle, num: number }> = {}
    /**是否有锁定的瓶子 */
    private _haveUnLockBottle: boolean = false

    private useColorNum: Record<number, number> = {}

    private weight: Record<number, number[]> = null
    private weightNum: number = 40
    /**盒子状态 0没有盒子，1看视频，2不用看视频/等待瓶子放入 3不可看视频解锁，4结束收集的盒子*/
    private boxState: number[] = [2, 2, 2, 2]
    /**提示时间 */
    public tipTime: number = 0
    private _data: GameData = null
    /**连击持续时间 */
    private _comboDuration: number = 5
    /**连击剩余时间 */
    private _comboTime: number = 5
    /**是否开始连击 */
    private _comboStart: boolean = false
    /**连击次数 */
    private _comboNum: number = 0
    /**是否卡死 */
    private _isDeadlock: boolean = false

    private _block: cc.NodePool = null

    private score: number = 0

    get data() {
        return this._data
    }
    get bottle() {
        return this._bottle
    }

    // LIFE-CYCLE CALLBACKS:

    async onLoad() {
        console.error("GameView onLoad");
        //物理系统
        // cc.director.getPhysicsManager().enabled = true;

        // cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_aabbBit |
        //     cc.PhysicsManager.DrawBits.e_pairBit |
        //     cc.PhysicsManager.DrawBits.e_centerOfMassBit |
        //     cc.PhysicsManager.DrawBits.e_jointBit |
        //     cc.PhysicsManager.DrawBits.e_shapeBit
        //     ;

        // 碰撞系统
        // cc.director.getCollisionManager().enabled = true
        // cc.director.getCollisionManager().enabledDebugDraw = true
        // cc.director.getCollisionManager().enabledDrawBoundingBox  = true
        GameControl.ints.setGameView(this)

        // let items = [Prefabs.block, Prefabs.block2]
        // for (let i = 1; i <= GameControl.ints.skinNum; i++) {
        //     this._block[i] = new cc.NodePool()
        //     let item = await ViewControl.ints.getPrefab(items[i - 1])
        //     for (let i = 0; i < 20; i++) {
        //         let node = cc.instantiate(item)
        //         this._block[i].put(node)
        //     }
        //     ViewControl.ints.putPrefab(items[i - 1])
        // }



        // 
        this.finger.active = false
       // this.bg.spriteFrame = this.bgs[window['__bgID'] || 0]
       
       EventControl.ints.on(EventName.showPlayNow, this.showPlayNow, this);
       this.scheduleOnce(this.showPlayNow, 20);
    }
    showPlayNow(){
         ViewControl.ints.closeView(Pages.GuideView);
        this.showPlayNow_Node.active = true;
    }

    playNow(){
        /////曾杰同学看这里 ！！！
        console.log("曾杰同学看这里");
    }

    start() {
        // MultipleController.ints.Breathing(this.btnBox.children[0], 1.1, 1, 1, true)
        MultipleController.ints.Breathing(this.btnPlayNow, 1.1, 1, 0.5, true);
    }

    update(dt) {

    }

    async gameWin() {

        let data_ = {
            // pos_type: PosType.POS_TYPE_LEVEL,
            pos_name: '第' + (this._data.level + 1) + '关',
            pos_ext: '主玩法',
            pos_sub_ext: ZTSDKControl.ints.version,
            pos_index: (this._data.level + 1),
            dur: GameControl.ints.time,
        }


        ZTSDKControl.ints.onLevelSuccess(data_);

        if (this._data.level == 0) {
            let data_ = {
                // pos_type: PosType.POS_TYPE_LEVEL,
                pos_name: '完成第1关',
                pos_ext: '新手引导',
                pos_sub_ext: ZTSDKControl.ints.version,
                pos_index: 90007,
            }
            ZTSDKControl.ints.onLevelStart(data_);
        }

        let bottle = 0
        for (let key in this._bottle) {
            if (this._bottle[key].node.active) {
                bottle++
            }
        }

        let score = StorageConreol.ints.getStorage('score')
        score += this._data.score
        score += bottle


        ADControl.ints.postMessage([{ key: 'score', value: JSON.stringify(score) }])
        ADControl.ints.setUserCloudStorage([{ key: 'score', value: score + '' }])
        RankControl.ints.myRankData.score = score
        StorageConreol.ints.setStorage('score', score)

        this._data.level++
        this._data.mapData = []
        this._data.boxState = []
        this._data.ratio = 0
        this._data.score = 0

        StorageConreol.ints.setStorage('gameData', this._data)
        this.unschedule(this.setTime)

        await DateControl.ints.Delay(0.5)
        ViewControl.ints.closeView(Pages.PropView)
        cc.tween(this.boxNode)
            .to(0.2, { x: -800 })
            .call(() => {
                this.boxNode.x = 800
                for (let i = 1; i < this.boxState.length; i++) {
                    this.boxNode.children[i].active = false
                }
                this.boxNode.children[0].getChildByName('item').getComponent(boxItem).setData(4, 0)
            })
            .to(0.2, { x: -200 })
            .to(0.1, { x: 0 })
            .start()



        await DateControl.ints.Delay(0.5)

        EventControl.ints.emit(EventName.BoxInspect, null, true)

    }

    async gameOver() {
        while (this.mapNode.childrenCount > 0) {
            this._block.put(this.mapNode.children[0])
        }
        while (this.topMap.childrenCount > 0) {
            this._block.put(this.topMap.children[0])
        }
        // await ViewControl.ints.openView(Pages.WinView, Storey.ViewUI)
    }

    async gameFail() {
        this.unschedule(this.setTime)
        StateControl.ints.playEffect('fail')
        // await DateControl.ints.Delay(0.5)
        await ViewControl.ints.openView(Pages.FailView, Storey.ViewUI)
    }

    public tipBottle: bottle[] = []
    /**卡死判断 */
    deadlock() {
        let isLock = true
        // for (let key in this._bottle) {//先判断一遍
        //     if (this._bottle[key].getEmpty() == 4 && this._bottle[key].data.ad == 0 && !this._bottle[key].complete) {
        //         // clog.log(this._bottle[key], key, this._bottle[key].getEmpty() == 4, this._bottle[key].data.ad == 0, !this._bottle[key].complete)
        //         isLock = false
        //         break
        //     }
        // }
        this.tipBottle = []
        if (isLock) {
            for (let key in this._bottle) {
                // if (this._bottle[key].getEmpty() == 4 && this._bottle[key].data.ad == 0 && !this._bottle[key].complete) {
                //     isLock = false

                //     break
                // }
                if (!this._bottle[key].complete && this._bottle[key].data.ad == 0 && this._bottle[key].data.lock[0] == 0) {
                    for (let key2 in this._bottle) {
                        if (
                            this._bottle[key2].data.lock[0] == 0 &&
                            !this._bottle[key2].complete &&
                            this._bottle[key2].data.ad == 0 &&
                            this._bottle[key2] != this._bottle[key] &&
                            (this._bottle[key2].getEmpty() == 4 || this._bottle[key2].getTopColorId() == this._bottle[key].getTopColorId()) &&
                            this._bottle[key2].getEmpty() >= this._bottle[key].getTopColor().length &&
                            this._bottle[key].getTopColor().length != 0
                        ) {
                            this.tipBottle[0] = this._bottle[key]
                            this.tipBottle[1] = this._bottle[key2]
                            isLock = false
                            break


                        }
                    }
                    if (!isLock) {

                        break
                    }
                }
            }
        }


        if (isLock) {
            clog.log('卡死了');
            this._isDeadlock = true
        } else {
            clog.log('没有卡死了');
            this._isDeadlock = false
        }

    }

    initView<T>(data?: T): void {
        GameControl.ints.Scene = Pages.GameView
    }


    async showView() {
        super.showView()
        this.onBtn(this.btnSetting, this.onBtnSetting, this)
        this.onBtn(this.btnDisturb, this.onBtnDisturb, this)
        this.onBtn(this.btnBack, this.onBtnBack, this)
        this.onBtn(this.btnAddBottle, this.onBtnAddBottle, this)
        this.onBtn(this.btnOpenGM, this.onBtnOpenGM, this)

        this.node.on(cc.Node.EventType.TOUCH_START, this.TOUCH_START, this)
        EventControl.ints.on(EventName.GameWin, this.gameWin, this)
        EventControl.ints.on(EventName.GameFail, this.gameFail, this)

        EventControl.ints.on(EventName.BoxUpdate, this.boxUpdate, this)
        EventControl.ints.on(EventName.BoxInspect, this.boxInspect, this)
        EventControl.ints.on(EventName.UnlockBottle, this.UnlockBottle, this)
        EventControl.ints.on(EventName.OpenGM, this.OpenGM, this)

        this._data = StorageConreol.ints.getStorage('gameData')
        // let showDebug = cc.sys.localStorage.getItem('showDebug')
        // if (showDebug == 1) {
        //     cc.dynamicAtlasManager.showDebug(true);
        //     cc.sys.localStorage.removeItem('showDebug')
        // }
        // this.bg.spriteFrame = await BundleControl.ints.getAsset('image/game/bg/bg' + GameControl.ints.useSkin, cc.SpriteFrame, bundles.res) as cc.SpriteFrame
        this.OpenGM()
        this.init()

    }

    OpenGM() {

        //this.btnOpenGM.active = window['__GM'] == 101
       // this.btnOpenGM.children[0].active = !GameControl.ints.HideBtn

    }

    async init(test: number = 0) {


        // this.scoreNode.active = this._data.level > 0
        // cc.Tween.stopAllByTarget(this.scoreNode)
        // this.scoreNode.x = -90
        let PropNum = StorageConreol.ints.getStorage('propNum')
        this.setPropNum(PropNum)
        this._block = GameControl.ints.getBlockNodePool()

        this.unschedule(this.setTime)
        GameControl.ints.initGame()
        //this.btnOpenGM.active = window['__GM'] == 101
        this.boxNode.active = true
        this.boxNode.children[0].active = false
        this.finger.active = false
        this._comboTime = this._comboDuration
        this._comboStart = false
        this._comboNum = 0
        this.tipTime = 0
        this.combo.scale = 0
        this._isDeadlock = false
        this.mapNode.removeAllChildren()
        this.topMap.removeAllChildren()
        this.schedule(this.setTime, 1)

        // this.level.string = '第' + (+ 1) + '关'

        let data_ = {
            // pos_type: PosType.POS_TYPE_LEVEL,
            pos_name: '第' + (this._data.level + 1) + '关',
            pos_ext: '主玩法',
            pos_sub_ext: ZTSDKControl.ints.version,
            pos_index: (this._data.level + 1),
        }
        ZTSDKControl.ints.onLevelStart(data_);

        clog.log("关卡", this._data);

        // this.problem.active = this.data.level == 12
        // if (this.problem.active) {
        // this.problem.x = -900
        //     cc.tween(this.problem)
        //         .to(0.2, { x: 200 })
        //         .to(0.1, { x: 0 })
        //         .delay(1)
        //         .to(0.1, { x: -200 })
        //         .to(0.2, { x: 900 })
        //         .call(() => {
        //             this.problem.active = false
        //         })
        //         .start()

        // }


        // let maxLv = GameControl.ints.mapData.length
        // if (this._data.level < maxLv) {
        if (!cc.sys.isBrowser) {
            this._data.level = ADControl.ints.keyID
        }
        
        this.mapData = ArrayUtil.deepClone(GameControl.ints.mapData[this._data.level])

        // } else {

        //     let level = GameControl.ints.exceedLevel[this._data.level % (maxLv - 3)]
        //     this.mapData = ArrayUtil.deepClone(GameControl.ints.mapData[level])
        // }




        // if (this._data.mapData.length != 0) {
        //     this.mapData = this._data.mapData
        // }
        // else if (this.data.level != 0) {

        //     let mapData: BottleData[] = []
        //     let mapData1: BottleData[] = []
        //     let mapData2: BottleData[] = []
        //     let mapData3: BottleData[] = []


        //     for (let i = 0; i < this.mapData.length; i++) {
        //         if (this.mapData[i].ad == 0 && this.mapData[i].lock[0] == 0) {
        //             let isAdd = true
        //             let num = 0
        //             for (let j = 0; j < 4; j++) {
        //                 if (this.mapData[i][j][1] == 1) {
        //                     num++
        //                 }
        //                 if (this.mapData[i][j][0] == 0) {
        //                     isAdd = false
        //                     num = 0
        //                     break
        //                 }

        //             }
        //             if (isAdd) {
        //                 switch (num) {
        //                     case 0:
        //                         mapData.push(this.mapData[i])
        //                         break
        //                     case 1:
        //                         mapData1.push(this.mapData[i])
        //                         break
        //                     case 2:
        //                         mapData2.push(this.mapData[i])
        //                         break
        //                     case 3:
        //                         mapData3.push(this.mapData[i])
        //                         break
        //                 }


        //             }

        //         }
        //     }
        //     mapData = ArrayUtil.deepClone(mapData)
        //     mapData1 = ArrayUtil.deepClone(mapData1)
        //     mapData2 = ArrayUtil.deepClone(mapData2)
        //     mapData3 = ArrayUtil.deepClone(mapData3)
        //     ArrayUtil.shuffle(mapData)
        //     ArrayUtil.shuffle(mapData1)
        //     ArrayUtil.shuffle(mapData2)
        //     ArrayUtil.shuffle(mapData3)


        //     for (let i = 0; i < this.mapData.length; i++) {
        //         if (this.mapData[i].ad == 0 && this.mapData[i].lock[0] == 0) {
        //             let isAdd = true
        //             let num = 0
        //             for (let j = 0; j < 4; j++) {
        //                 if (this.mapData[i][j][1] == 1) {
        //                     num++
        //                 }
        //                 if (this.mapData[i][j][0] == 0) {
        //                     isAdd = false
        //                     num = 0
        //                     break
        //                 }
        //             }
        //             if (isAdd) {
        //                 let data = null

        //                 switch (num) {
        //                     case 0:
        //                         data = mapData.shift()
        //                         break
        //                     case 1:
        //                         data = mapData1.shift()
        //                         break
        //                     case 2:
        //                         data = mapData2.shift()
        //                         break
        //                     case 3:
        //                         data = mapData3.shift()
        //                         break
        //                 }



        //                 for (let key in this.mapData[i]) {

        //                     if (key != 'appear' && key != 'pos') {
        //                         this.mapData[i][key] = data[key]
        //                     }
        //                 }
        //             }

        //         }
        //     }
        // }
        if (test == 1) {
            this.mapData =
                // [
                //     { 0: [1, 0], 1: [2, 0], 2: [2, 0], 3: [2, 0], lock: [0, 0], pos: [0, 5], ad: 0, appear: 1 },
                //     { 0: [0, 0], 1: [1, 0], 2: [2, 0], 3: [2, 0], lock: [0, 0], pos: [1, 5], ad: 0, appear: 2 },
                //     { 0: [0, 0], 1: [0, 0], 2: [1, 0], 3: [2, 0], lock: [0, 0], pos: [2, 5], ad: 0, appear: 3 },
                //     { 0: [0, 0], 1: [0, 0], 2: [0, 0], 3: [1, 0], lock: [0, 0], pos: [3, 5], ad: 0, appear: 4 },
                //     { 0: [0, 0], 1: [0, 0], 2: [2, 0], 3: [2, 0], lock: [0, 0], pos: [4, 15], ad: 0, appear: 5 },
                //     { 0: [0, 0], 1: [0, 0], 2: [0, 0], 3: [0, 0], lock: [0, 0], pos: [3, 10], ad: 0, appear: 6 },
                //     { 0: [0, 0], 1: [0, 0], 2: [0, 0], 3: [0, 0], lock: [0, 0], pos: [4, 10], ad: 0, appear: 7 },
                //     { 0: [0, 0], 1: [0, 0], 2: [0, 0], 3: [0, 0], lock: [0, 0], pos: [5, 10], ad: 0, appear: 8 },
                //     { 0: [0, 0], 1: [0, 0], 2: [0, 0], 3: [0, 0], lock: [0, 0], pos: [6, 10], ad: 0, appear: 9 }
                // ]
                [
                    { "0": [0, 0], "1": [4, 0], "2": [4, 0], "3": [1, 0], "lock": [0, 0], "pos": [0, 1], "ad": 0 },
                    { "0": [0, 0], "1": [4, 0], "2": [4, 0], "3": [1, 0], "lock": [0, 0], "pos": [2, 1], "ad": 0 },
                    { "0": [0, 0], "1": [0, 0], "2": [7, 0], "3": [2, 0], "lock": [0, 0], "pos": [4, 1], "ad": 0 },
                    { "0": [0, 0], "1": [0, 0], "2": [8, 0], "3": [2, 0], "lock": [0, 0], "pos": [6, 1], "ad": 0 },
                    { "0": [0, 0], "1": [0, 0], "2": [1, 0], "3": [1, 0], "lock": [0, 0], "pos": [0, 5], "ad": 0 },
                    { "0": [0, 0], "1": [2, 0], "2": [2, 0], "3": [6, 0], "lock": [0, 0], "pos": [2, 5], "ad": 0 },
                    { "0": [0, 0], "1": [6, 0], "2": [6, 0], "3": [6, 0], "lock": [0, 0], "pos": [4, 5], "ad": 0 },
                    { "0": [0, 0], "1": [0, 0], "2": [3, 0], "3": [3, 0], "lock": [0, 0], "pos": [6, 5], "ad": 0 },
                    { "0": [7, 0], "1": [7, 0], "2": [7, 0], "3": [5, 0], "lock": [0, 0], "pos": [0, 9], "ad": 0 },
                    { "0": [5, 0], "1": [5, 0], "2": [5, 0], "3": [3, 0], "lock": [0, 0], "pos": [2, 9], "ad": 0 },
                    { "0": [8, 0], "1": [8, 0], "2": [8, 0], "3": [3, 0], "lock": [0, 0], "pos": [4, 9], "ad": 0 },
                    { "0": [0, 0], "1": [0, 0], "2": [0, 0], "3": [0, 0], "lock": [0, 0], "pos": [6, 9], "ad": 1 }
                ]
        }

        if (test == 2) {
            let item = await BundleControl.ints.getAsset('game/item/testBlock', cc.Prefab, bundles.prefab) as cc.Prefab
            GameControl.ints.mapType == 0 ? GameControl.ints.mapType = 1 : GameControl.ints.mapType = 0
            let mapType = GameControl.ints.mapType
            let maxX = 0
            if (mapType == 0) {
                maxX = 7
            } else if (mapType == 1) {
                maxX = 6
            }
            for (let i = 0; i < maxX; i++) {
                for (let j = 0; j < 13; j++) {
                    let node = cc.instantiate(item)
                    node.parent = this.mapNode
                    let pos = GameControl.ints.getPos([i, j])
                    node.setPosition(pos)
                    node.getComponent(testBlock).setData([i, j])

                }
            }
            GameControl.ints.loadGameOver = true
            return
        }



        let item = await ViewControl.ints.getPrefab(GameControl.ints.item)
        let appears = {}
        this.useColorNum = {}
        this._unLockBottle = {}
        this._haveUnLockBottle = false
        let unlockColor = {}
        this.bottleState = []
        this._bottle = {}
        for (let i = 0; i < this.mapData.length; i++) {
            let node: cc.Node = null
            if (this._block.size() > 0) {
                node = this._block.get()
            } else {
                node = cc.instantiate(item)
            }


            if (this.mapData[i].appear) {
                appears[this.mapData[i].appear] = node

            }
            this._bottle[i] = node.getChildByName('bottle').getComponent(bottle)
            if (this._data.mapData.length == 0) {
                this.mapData[i].showBottle = 1
                this.mapData[i].complete = 0
            }

            node.getChildByName('bottle').getComponent(bottle).setData(this.mapData[i], i)
            if (this.mapData[i].lock[0] != ColorType.NONE && this.mapData[i].lock[0] != ColorType.BLACK) {
                if (!this.useColorNum[this.mapData[i].lock[0]]) this.useColorNum[this.mapData[i].lock[0]] = 0
                if (!unlockColor[this.mapData[i].lock[0]]) unlockColor[this.mapData[i].lock[0]] = 0
                this.useColorNum[this.mapData[i].lock[0]] += this.mapData[i].lock[1]
                unlockColor[this.mapData[i].lock[0]] += this.mapData[i].lock[1]
                this._unLockBottle[i] = { data: this._bottle[i], num: this.mapData[i].lock[1] }
            }
            if (!this._haveUnLockBottle && this.mapData[i].lock[0] != 0) {
                this._haveUnLockBottle = true
            }

            this.bottleState[i] = this.mapData[i].complete

        }
        clog.log(this.useColorNum);
        let key = Object.keys(appears)
        if (key.length < this.mapData.length) appears = {}


        ViewControl.ints.putPrefab(GameControl.ints.item)
        GameControl.ints.bottleNum = GameControl.ints.bottleBlockNum / 4
        if (GameControl.ints.bottleNum % 2 != 1 && GameControl.ints.bottleNum % 2 != 0) {
            clog.error('关卡出错了，检查一下');
        } else {
            for (let key in GameControl.ints.colorNum) {
                for (let i = 0; i < GameControl.ints.colorNum[key] / 4; i++) {
                    if (!this.useColorNum[parseInt(key)]) this.useColorNum[parseInt(key)] = 0
                    this.useColorNum[parseInt(key)] += this.weightValuNum
                }
            }
        }


        clog.log(this.useColorNum);
        // if (this._data.level == 0) {
        //     this.useColorNum = { /*1: this.weightValuNum - 1, 2: this.weightValuNum - 1,*/ 7: this.weightValuNum }
        // }

        if (this.boxNode.childrenCount < 4) {
            for (let i = 0; this.boxNode.childrenCount < 4; i++) {
                let node = cc.instantiate(this.boxNode.children[0])
                node.parent = this.boxNode
            }
        }


        let colorIds = [2, 1]
        clog.log(this.useColorNum);
        let before = 0


        let weight: Record<number, number[]> = {}
        for (let i = 0; i < this.weightNum; i++) {
            weight[i] = []
        }
        for (let key in unlockColor) {
            weight[unlockColor[key]].push(parseInt(key))
        }

        clog.log(weight);
        let maxIDs = []
        for (let i = this.weightNum - 1; i > 0; i--) {
            if (weight[i].length > 0) {
                ArrayUtil.shuffle(weight[i])
                while (true) {
                    maxIDs.push(weight[i].shift())
                    if (maxIDs.length >= 2 || weight[i].length <= 0) {
                        break
                    }
                }

            }
            if (maxIDs.length >= 2) {
                break
            }
        }

        for (let v of maxIDs) {
            this.useColorNum[v] += 20
        }
        // clog.log(this.useColorNum, this._unLockBottle);

        for (let i = 0; i < this.boxState.length; i++) {

            let isAd = this.boxState[i]
            let colorId = 0

            if (this._data.boxState.length != 0) {
                isAd = this._data.boxState[i][0]
                colorId = this._data.boxState[i][1]
                if (isAd == 2 && colorId != 0) {
                    this.useColorNum[colorId]--

                    let isLock = false
                    for (let key in this._unLockBottle) {
                        if (this._unLockBottle[key].data.data.lock[0] == colorId) {
                            isLock = true
                            this._unLockBottle[key].num--
                            if (this._unLockBottle[key].num <= 0) {
                                delete this._unLockBottle[key]
                            }

                            break
                        }
                    }
                    if (isLock) this.useColorNum[colorId]--

                    if (this.useColorNum[colorId] <= 0) {
                        delete this.useColorNum[colorId]
                    }
                }

            } else {
                // if (this._data.level == 0) {
                //     colorId = colorIds.shift()
                // } else {
                if (isAd == 2) {
                    colorId = this.getNextColor(before)
                }
                // }


                if (colorId == undefined && isAd == 1) {
                    colorId = 0
                    // isAd = 0
                }
                if (colorId == undefined) colorId = 0
                before = colorId
            }



            this.boxNode.children[i].active = true
            this.boxNode.children[i].getChildByName('item').getComponent(boxItem).setData(isAd, colorId)
        }
        for (let v of maxIDs) {
            this.useColorNum[v] -= 20
        }


        if (appears[1] != undefined) {
            let time = 0
            let appearTime = 0.05
            for (let i = 0; i < this.mapData.length; i++) {
                appears[i + 1].opacity = 0
                appears[i + 1].y += 50
                cc.tween(appears[i + 1])
                    .delay(time + 0.04 * i)
                    .to(appearTime, { y: appears[i + 1].y - 50, opacity: 255 })
                    .call(() => {
                        if (i >= this.mapData.length - 1) {
                            this.loadGameOver()
                        }
                    })
                    .start()
            }
        } else {
            this.gameNode.scale = 0
            cc.tween(this.gameNode)
                .to(0.15, { scale: 1.1 }, cc.easeOut(3.0))
                .to(0.1, { scale: 1 }, cc.easeOut(3.0))
                .call(() => {
                    this.loadGameOver()
                })
                .start()
        }





        this.showReward()
        this.disturbInspect()
        this.backInspect()
        this.addInspect(true)
    }

    /**加载完成开始游戏 */
    async loadGameOver() {
        GameControl.ints.loadGameOver = true
        EventControl.ints.emit(EventName.BoxInspect)
        this.deadlock()
        if (GuideControl.ints.guide[1] == 1 && window['__skin'] != 3) {
            let pos = NodeControl.ints.nodeConvertLocalPointAR(this._bottle[0].node.parent, this.node)
            pos.y += 105
            let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
            GuideControl.ints.showGuide({ type: 1, pos, tipePos, width: 100, height: 215, id: 1, txt: '点击选择瓶子' })

        }
        clog.log(this._haveUnLockBottle, this.data.level)
        if (this._haveUnLockBottle && this.data.level == 2) {




            for (let key in this.bottle) {
                if (this._bottle[key].data.lock[0] != 0) {

                    let txt = GameControl.ints.getTipLab(this._bottle[key].data.lock[0], this._bottle[key].data.lock[1])


                    let pos = this._bottle[key].block.getPosition()
                    pos.y += 210
                    if (GameControl.ints.useSkin == SkinType.SCREW) {
                        pos.y -= 50
                    }
                    await ViewControl.ints.openView(Pages.TipBubble, Storey.ViewUI, { str: txt, pos }, false)
                    this.scheduleOnce(() => {
                        ViewControl.ints.closeView(Pages.TipBubble)
                    }, 2)
                    break
                }

            }
        }

        this.score = this.data.score
        this.score--
        // cc.tween(this.scoreNode)
        //     .to(0.3, { x: 0 }, cc.easeOut(3.0))
        //     .start()
        // this.setScore()
    }

    setScore() {
        this.score++
        // this.scoreNode.scale = 1
        // cc.tween(this.scoreNode)
        //     .to(0.2, { scale: 1.1 })
        //     .to(0.2, { scale: 1 })
        //     .start()

        // this.scoreLab.string = this.score + ''
    }

    private isShowReward: boolean = false
    async showReward() {
        if (this.isShowReward) return
        if (ADControl.ints.type == platformType.TT) {
            let _data = ADControl.ints.getLaunchOptionsSync()
            clog.log('showReward启动参数', _data)

            if (_data.scene == '023040') { //平台卡
                await ViewControl.ints.openView(Pages.CodeView, Storey.TopUI, 1)
            }
        }
        if (cc.sys.isBrowser) {

        }
        this.isShowReward = true
    }






    setPropNum(PropNum: number[]) {
        this.btnDisturb.getChildByName('num').active = PropNum[0] > 0
        this.btnDisturb.getChildByName('num').getChildByName('lab').getComponent(cc.Label).string = PropNum[0] + ''
        this.btnBack.getChildByName('num').active = PropNum[1] > 0
        this.btnBack.getChildByName('num').getChildByName('lab').getComponent(cc.Label).string = PropNum[1] + ''
        this.btnAddBottle.getChildByName('num').active = PropNum[2] > 0
        this.btnAddBottle.getChildByName('num').getChildByName('lab').getComponent(cc.Label).string = PropNum[2] + ''
    }

    saveData() {
        if (GameControl.ints.gameOver) return
        if (this._data.mapData.length == 0) {
            this._data.mapData = []
            for (let v in this._bottle) {
                this._data.mapData[v] = this._bottle[v].data
            }
            this._data.boxState = []
            this._data.bottleNum = GameControl.ints.bottleNum
        }
        for (let i = 0; i < this.boxNode.childrenCount; i++) {
            if (!this._data.boxState[i]) this._data.boxState[i] = []
            let boxItems = this.boxNode.children[i].getChildByName('item').getComponent(boxItem)
            this._data.boxState[i][0] = boxItems.isAd
            this._data.boxState[i][1] = boxItems.coloId
        }

        let bottleNum = this._data.bottleNum - GameControl.ints.bottleNum

        let ratio = Math.floor((GameControl.ints.bottleCompleteNum + bottleNum) / this._data.bottleNum * 100)

        this._data.ratio = ratio
        StorageConreol.ints.setStorage('gameData', this._data)
        this.deadlock()

    }

    updataWeight() {
        this.weight = {}
        for (let i = 0; i < this.weightNum; i++) {
            this.weight[i] = []
        }
        for (let key in this.useColorNum) {
            this.weight[this.useColorNum[key]].push(parseInt(key))
        }

        let unLockBottle = this._unLockBottle
        if (!cc.sys.isBrowser) unLockBottle = {}
        return { weight: this.weight, useColorNum: this.useColorNum, unLockBottle: unLockBottle }
    }

    private weightValuNum: number = 1
    getNextColor(before: number = 0) {
        this.updataWeight()
        clog.log(this.weight);

        let colorId = undefined
        for (let i = this.weightNum - 1; i > 0; i--) {
            if (this.weight[i].length > 0) {
                ArrayUtil.shuffle(this.weight[i])
                colorId = this.weight[i][0]
                if (before != 0 && colorId == before) {
                    if (this.weight[i].length > 1) {
                        colorId = this.weight[i][1]
                        this.useColorNum[colorId]--

                        let isLock = false
                        for (let key in this._unLockBottle) {
                            if (this._unLockBottle[key].data.data.lock[0] == colorId) {
                                isLock = true
                                this._unLockBottle[key].num--
                                if (this._unLockBottle[key].num <= 0) {
                                    delete this._unLockBottle[key]
                                }

                                break
                            }
                        }
                        if (isLock) this.useColorNum[colorId]--
                        break
                    }
                } else {
                    this.useColorNum[colorId]--
                    let isLock = false
                    for (let key in this._unLockBottle) {
                        if (this._unLockBottle[key].data.data.lock[0] == colorId) {
                            isLock = true
                            this._unLockBottle[key].num--
                            if (this._unLockBottle[key].num <= 0) {
                                delete this._unLockBottle[key]
                            }
                            break
                        }
                    }
                    if (isLock) this.useColorNum[colorId]--
                    break
                }



            }
        }
        if (this.useColorNum[colorId] <= 0) {
            delete this.useColorNum[colorId]
        }
        // clog.log(colorId, this._unLockBottle);

        return colorId
    }

    /**盒子更新，isFall盒子是否需要飞走，1是0否 */
    boxUpdate(isFall: number = 1) {
        clog.log(this.useColorNum);
        clog.log(this.bottleState);


        for (let node of this.boxNode.children) {
            let box = node.getChildByName('item').getComponent(boxItem)

            if (box.isAd == 0 && box.isPrepare) {
                let colorId = this.getNextColor()
                if (colorId != undefined) {
                    box.setData(2, colorId)
                    if (isFall == 1) {
                        box.fall()
                    }
                } else {
                    box.setData(0, 0)
                }
            }
            let key = Object.keys(this.useColorNum)
            if (box.isAd == 1 && key.length == 0) {
                box.setData(3, 0)
            }

        }
        GameControl.ints.gameView.saveData()
    }



    /**检查是否有配对的瓶子和盒子 */
    async boxInspect(data: bottle, isOver: boolean = false) {
        if (isOver) {
            let box = this.boxNode.children[0].getChildByName('item').getComponent(boxItem)

            let isEnd = false
            let residual: bottle[] = []
            for (let key in this._bottle) {
                if (this._bottle[key].node.active) {
                    residual.push(this._bottle[key])
                }
            }
            let time = 0.1
            for (let i = 0; i < residual.length; i++) {
                await DateControl.ints.Delay(time)
                if (i == residual.length - 1) isEnd = true
                box.packBottle(residual[i], true, isEnd)
            }

        } else {
            for (let node of this.boxNode.children) {
                let box = node.getChildByName('item').getComponent(boxItem)
                if (box.isAd == 2 && box.isPrepare) {
                    if (data) {
                        if (data.isOperate && data.complete && data.getTopColorId() == box.coloId) {
                            box.packBottle(data)
                        }
                    } else {
                        for (let key in this._bottle) {
                            if (this._bottle[key].isOperate && this._bottle[key].complete && this._bottle[key].getTopColorId() == box.coloId) {
                                box.packBottle(this._bottle[key])
                                break
                            }
                        }
                    }

                }
            }
            if (data) {
                data.isPourWater = false
            }
        }

    }
    async fly(x: number) {
        this._comboStart = true
        this._comboNum++
        this._comboTime = this._comboDuration

        if (this._comboNum >= 2) {
            this.combo.active = true
            let num = (this._comboNum - 2) % 6 + 1


            let url = 'image/combo/' + num
            let data = { name: '', url, type: cc.SpriteFrame, bundle: bundles.res }
            this.combo.getComponent(cc.Sprite).spriteFrame = await BundleControl.ints.loadAsset(data) as cc.SpriteFrame
            cc.Tween.stopAllByTarget(this.combo)
            this.combo.scale = 1.5
            this.combo.opacity = 0
            // this.combo.x = x
            cc.tween(this.combo)
                .to(0.2, { scale: 1, opacity: 255 })
                .delay(0.5)
                .to(0.2, { scale: 0 })
                .start()
        }
    }
    /**解锁瓶子,每次消除时都判断 */
    async UnlockBottle(colorId: number) {
        let have = false
        for (let key in this._bottle) {
            if (this._bottle[key].data.lock[0] == ColorType.BLACK || this._bottle[key].data.lock[0] == colorId) {
                if (await this._bottle[key].unlock()) {
                    have = true
                }
            }
        }
        if (have) {
            GameControl.ints.gameView.saveData()
            StateControl.ints.playEffect('抽布')
        }

    }



    setTime() {

        if (this.tipTime < 8 && !GameControl.ints.useProp) {
            this.tipTime++
            if (this.tipTime >= 8 && !this.finger.active && !GuideControl.ints.isGuide) {
                console.log('没操作提示');

                this._isDeadlock = false
                this.deadlock()
                this.showFinger()
            }
        }
        if (this._comboStart) {
            this._comboTime--
            if (this._comboTime <= 0) {
                this._comboStart = false
                this._comboNum = 0
            }
        }
        GameControl.ints.time++
    }

    async showFinger() {



        let pos: cc.Vec2 = null
        let posX = 0
        // for (let key in this._bottle) {
        //     if (this._bottle[key].data.ad == 1) {
        //         pos = this._bottle[key].block_pos
        //         posX = this._bottle[key].data.pos[0]
        //         break
        //     }
        // }
        console.log(this.tipBottle.length);

        if (this.tipBottle.length == 0) {
            this.tipTime = 0
            this.finger.active = false
        }

        if (this.tipBottle.length > 0 && this.tipTime >= 8 && !GuideControl.ints.isGuide) {


            let data = this.tipBottle.shift()
            pos = data.block_pos
            posX = data.data.pos[0]

        } else {
            this.tipTime = 0
        }





        if (pos) {
            this.finger.active = true
            this.finger.children[0].active = true
            this.finger.x = pos.x + 10
            this.finger.y = pos.y + 50
            if (posX == 6) {
                this.finger.children[0].x = -20
            } else if (posX == 0) {
                this.finger.children[0].x = 20
            } else {
                this.finger.children[0].x = 0
            }
            await DateControl.ints.Delay(2)

            this.finger.children[0].active = false
        }


    }

    private _clickBtnDisturb: boolean = true
    /**检查是否可以使用打乱 */
    disturbInspect() {
        // this.btnDisturb.active = this.data.level != 0
        let result = this.getDisturb()
        // this.btnDisturb.getComponent(cc.Button).interactable = result
        this._clickBtnDisturb = result
        let PropNum = StorageConreol.ints.getStorage('propNum')
        if (result ) {
            this.btnDisturb.getComponent(cc.Sprite).spriteFrame = this.btns1[0]
            this.btnDisturb.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns1[1]
        } else {
            this.btnDisturb.getComponent(cc.Sprite).spriteFrame = this.btns2[0]
            this.btnDisturb.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns2[1]
        }

    }
    /**获得可以打乱的瓶子 */
    getDisturb(showTip: boolean = false) {
        let disturbList: bottle[] = []

        for (let key in this._bottle) {

            if (this._bottle[key].isOperate && this._bottle[key].getDisturb(showTip)) {
                disturbList.push(this._bottle[key])
            }
        }

        if (showTip && disturbList.length != 0) {
            for (let v of disturbList) {
                v.setDisturb()
            }
        }
        return disturbList.length != 0
    }
    /**打乱恢复 */
    restoreDisturb() {
        for (let key in this._bottle) {
            if (this._bottle[key].disturb.active) {
                this._bottle[key].disturb.active = false
            }
        }
        GameControl.ints.useProp = false
    }


    /**打乱 */
    useDisturb() {
        GameControl.ints.useProp = true
        this.getDisturb(true)
    }

    async onBtnSetting() {
        if (ADControl.ints.isPlayVideo) {
            ViewControl.ints.showTip('正在播放视频，请稍后...')
            return
        }
        if (GameControl.ints.gameOver) return
        await ViewControl.ints.openView(Pages.SettingView, Storey.ViewUI, 2)
    }

    async onBtnDisturb() {



        if (!GameControl.ints.loadGameOver || GameControl.ints.gameOver) return

        if (!this._clickBtnDisturb) {
            await ViewControl.ints.showTip('没有可打乱的了')
            return
        }

        this.finger.active = false
        this.tipTime = 0
        if (GameControl.ints.useProp) {
            await ViewControl.ints.showTip('正在使用道具，请稍后...')
            return
        }
        if (!GameControl.ints.isUseProp) {
            await ViewControl.ints.showTip('正在操作中，请稍后...')
            return
        }
        ViewControl.ints.showTip('选择一个打乱')
        this.useDisturb()
        return
        let PropNum = StorageConreol.ints.getStorage('propNum')
        if (PropNum[0] > 0) {
            this.useDisturb()
            PropNum[0]--
            StorageConreol.ints.setStorage('propNum', PropNum)
            this.setPropNum(PropNum)
            ViewControl.ints.showTip('选择一个打乱')
        } else {
            return
            let fun = async () => {

                let data = {
                    // pos_type: PosType.POS_TYPE_LEVEL,
                    pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                    pos_ext: '主关卡',
                    pos_sub_ext: ZTSDKControl.ints.version,
                    why: '打乱',
                    pos_index: this.data.level + 1,
                }
                ZTSDKControl.ints.onAdRequest(data);

                ADControl.ints.showVideo({
                    successFun: () => {

                        ViewControl.ints.showTip('选择一个打乱')
                        this.useDisturb()
                        ZTSDKControl.ints.onAdFinish(data);
                        GameControl.ints.gameView.saveData()
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    failFun: () => {
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    errFun: () => {
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    closeFun: () => {
                        ZTSDKControl.ints.onAdCancel(data);
                    }
                })
            }
            await ViewControl.ints.openView(Pages.PropView, Storey.ViewUI, { type: 1, fun })
        }

    }
    /**使用回退 */
    async useBack() {

        this._isDeadlock = false
        this.tipTime = 0
        this.btnBack.getComponent(cc.Sprite).spriteFrame = this.btns2[0]
        this.btnBack.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns2[2]

        let addBottle = GameControl.ints.lastBottle.addBottle
        let reduceBottle = GameControl.ints.lastBottle.reduceBottle
        let num1 = GameControl.ints.lastBottle.num
        let num2 = num1
        let num3 = num1
        GameControl.ints.useProp = true
        if (addBottle == GameControl.ints.selectItem) GameControl.ints.selectItem = null
        if (GameControl.ints.useSkin == SkinType.WATER) {
            for (let i = 0; i < 4; i++) {
                if (addBottle.data[i][0] != 0) {
                    addBottle.data[i][0] = 0
                    num2--
                    if (num2 <= 0) {
                        break
                    }
                }
            }
            addBottle.data.complete = 0
            addBottle.initData()

            reduceBottle.isPourWater = true
            reduceBottle.mask.enabled = true
            let time = 0.5
            for (let i = 3; i >= 0; i--) {
                if (reduceBottle.data[i][0] == 0) {
                    reduceBottle.addWater(i, GameControl.ints.lastBottle.coloId, time)
                    num1--
                    if (num1 <= 0) {
                        break
                    }
                }
            }
            await reduceBottle.enabledMask(time)
            reduceBottle.top.children[1].active = false
            reduceBottle.isPourWater = false
        } else if (GameControl.ints.useSkin == SkinType.BLOCK || GameControl.ints.useSkin == SkinType.SCREW) {
            let time = 0.15
            addBottle.isPourWater = true
            reduceBottle.isPourWater = true
            let TopColor = addBottle.getTopColor()
            let reduceIndex = reduceBottle.getEmpty()

            if (GameControl.ints.useSkin == SkinType.SCREW) {
                if (GameControl.ints.selectItem == reduceBottle || GameControl.ints.selectItem == addBottle) {
                    GameControl.ints.selectItem = null
                }
                if (reduceBottle['isUp']) {
                    let topColor = reduceBottle.getTopColor()
                    for (let i = topColor.length - 1; i >= 0; i--) {
                        reduceBottle.storeys[topColor[i]].y = reduceBottle['storeysPos'][topColor[i]].y
                        reduceBottle['storeys2'][topColor[i]].y = reduceBottle['storeysPos'][topColor[i]].y
                    }
                    reduceBottle['isUp'] = false
                }
                if (addBottle['isUp']) {

                    for (let i = TopColor.length - 1; i >= 0; i--) {
                        addBottle.storeys[TopColor[i]].y = addBottle['storeysPos'][TopColor[i]].y
                        addBottle['storeys2'][TopColor[i]].y = addBottle['storeysPos'][TopColor[i]].y
                    }
                    addBottle['isUp'] = false
                }

            }


            for (let i = 0; i < 4; i++) {
                if (addBottle.data[i][0] != 0) {
                    addBottle.data[i][0] = 0
                    num2--
                    if (num2 <= 0) {
                        break
                    }
                }
            }
            for (let i = 3; i >= 0; i--) {
                if (reduceBottle.data[i][0] == 0) {
                    reduceBottle.data[i][0] = GameControl.ints.lastBottle.coloId
                    num1--
                    if (num1 <= 0) {
                        break
                    }
                }
            }


            let fun = () => {
                return new Promise((resolve, reject) => {
                    StateControl.ints.playEffect('螺母拔起')
                    for (let i = 0; i < num3; i++) {
                        cc.Tween.stopAllByTarget(addBottle.storeys[TopColor[i]])
                        cc.tween(addBottle.storeys[TopColor[i]])
                            .to(time, { y: addBottle['storeysTopPos'][num3 - 1 - i].y })
                            .call(() => {
                                if (i == num3 - 1) {
                                    resolve(true)
                                }
                            })
                            .start()
                        if (GameControl.ints.useSkin == SkinType.SCREW) {
                            cc.Tween.stopAllByTarget(addBottle['storeys2'][TopColor[i]])
                            cc.tween(addBottle['storeys2'][TopColor[i]])
                                .to(time, { y: addBottle['storeysTopPos'][num3 - 1 - i].y })
                                .call(() => {

                                })
                                .start()
                        }
                    }
                })
            }
            await fun()
            addBottle.data.complete = 0
            addBottle.initData()
            reduceBottle.block.parent = this.topMap
            addBottle.isPourWater = false
            for (let i = 0; i < num3; i++) {

                addBottle.storeys[TopColor[i]].active = false
                cc.Tween.stopAllByTarget(addBottle.storeys[TopColor[i]])
                let pos = NodeControl.ints.nodeConvertLocalPointAR(addBottle.block, reduceBottle.node)

                reduceBottle.storeys[reduceIndex - 1 - i].active = true
                reduceBottle.storeys[reduceIndex - 1 - i].x = pos.x
                reduceBottle.storeys[reduceIndex - 1 - i].y = pos.y + reduceBottle['storeysTopPos'][num3 - 1 - i].y
                if (GameControl.ints.useSkin == SkinType.BLOCK) {
                    reduceBottle.storeyColors[reduceIndex - 1 - i].getComponent(cc.Sprite).spriteFrame = reduceBottle['icons'][GameControl.ints.lastBottle.coloId]
                }
                if (GameControl.ints.useSkin == SkinType.SCREW) {
                    reduceBottle['storeys2'][reduceIndex - 1 - i].active = true
                    reduceBottle['storeys2'][reduceIndex - 1 - i].x = pos.x
                    reduceBottle['storeys2'][reduceIndex - 1 - i].y = pos.y + reduceBottle['storeysTopPos'][num3 - 1 - i].y


                    reduceBottle.storeyColors[reduceIndex - 1 - i].color = cc.color().fromHEX(GameControl.ints.colorList[GameControl.ints.lastBottle.coloId].dark)
                    reduceBottle['storeyColors2'][reduceIndex - 1 - i].color = cc.color().fromHEX(GameControl.ints.colorList[GameControl.ints.lastBottle.coloId].dark)

                    cc.tween(reduceBottle['storeys2'][reduceIndex - 1 - i])
                        .to(i * 0.05, { y: pos.y + reduceBottle['storeysTopPos'][num3 - 1].y })
                        .to(time + i * 0.05, { x: 0, y: reduceBottle['storeysTopPos'][num3 - 1].y })
                        .call(() => {
                            if (i == 0) {
                                StateControl.ints.playEffect('螺母放下')
                            }
                        })
                        .to(time, { y: reduceBottle['storeysPos'][reduceIndex - 1 - i].y })
                        .call(() => {
                            reduceBottle['booms'][reduceIndex - 1 - i].active = true
                            reduceBottle['booms'][reduceIndex - 1 - i].getComponent(sp.Skeleton).setCompleteListener(() => {
                                reduceBottle['booms'][reduceIndex - 1 - i].active = false
                            })
                            reduceBottle['booms'][reduceIndex - 1 - i].getComponent(sp.Skeleton).setAnimation(0, 'bao', false)
                        })
                        .start()

                }


                cc.tween(reduceBottle.storeys[reduceIndex - 1 - i])
                    .to(i * 0.05, { y: pos.y + reduceBottle['storeysTopPos'][num3 - 1].y })
                    .to(time + i * 0.05, { x: 0, y: reduceBottle['storeysTopPos'][num3 - 1].y })
                    .call(() => {
                        if (i == 0) {

                        }
                    })
                    .to(time, { y: reduceBottle['storeysPos'][reduceIndex - 1 - i].y })
                    .call(() => {
                        if (i == num3 - 1) {
                            reduceBottle.isPourWater = false
                            reduceBottle.block.parent = this.mapNode
                            reduceBottle.block.zIndex = reduceBottle.zIndex
                        }
                    })
                    .start()
            }

            addBottle.initData()




        }

        GameControl.ints.useProp = false
        GameControl.ints.lastBottle = null
        this._clickBtnBack = false
        this.disturbInspect()
    }
    private _clickBtnBack: boolean = true
    /**回退检测 */
    backInspect() {
        // this.btnBack.active = this.data.level != 0
        let result = GameControl.ints.lastBottle != null
        this._clickBtnBack = result
        // this.btnBack.getComponent(cc.Button).interactable = result

        let PropNum = StorageConreol.ints.getStorage('propNum')
        if (result ) {
            this.btnBack.getComponent(cc.Sprite).spriteFrame = this.btns1[0]
            this.btnBack.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns1[2]
        } else {
            this.btnBack.getComponent(cc.Sprite).spriteFrame = this.btns2[0]
            this.btnBack.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns2[2]
        }
    }

    async onBtnBack() {

        if (!GameControl.ints.loadGameOver || GameControl.ints.gameOver) return

        if (!this._clickBtnBack) {
            await ViewControl.ints.showTip('没有可回退的操作')
            return
        }
        this.finger.active = false
        this.tipTime = 0
        if (GameControl.ints.useProp) {
            await ViewControl.ints.showTip('正在使用道具，请稍后...')
            return
        }
        if (!GameControl.ints.isUseProp) {
            await ViewControl.ints.showTip('正在操作中，请稍后...')
            return
        }

        this.useBack()
        return

        let PropNum = StorageConreol.ints.getStorage('propNum')
        if (PropNum[1] > 0) {
            this.useBack()
            GameControl.ints.gameView.saveData()
            PropNum[1]--
            StorageConreol.ints.setStorage('propNum', PropNum)
            this.setPropNum(PropNum)
        } else {
            return
            let fun = async () => {

                let data = {
                    // pos_type: PosType.POS_TYPE_LEVEL,
                    pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                    pos_ext: '主关卡',
                    pos_sub_ext: ZTSDKControl.ints.version,
                    why: '撤回',
                    pos_index: this.data.level + 1,
                }
                ZTSDKControl.ints.onAdRequest(data);

                ADControl.ints.showVideo({
                    successFun: async () => {
                        ViewControl.ints.closeView(Pages.PropView)
                        // await DateControl.ints.Delay(0.5)

                        this.useBack()

                        ZTSDKControl.ints.onAdFinish(data);
                        GameControl.ints.gameView.saveData()

                    },
                    failFun: () => {
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    errFun: () => {
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    closeFun: () => {
                        ZTSDKControl.ints.onAdCancel(data);
                    }
                })

            }
            await ViewControl.ints.openView(Pages.PropView, Storey.ViewUI, { type: 2, fun })
        }



    }
    /**增加空瓶子 */
    addBottle() {
        this._isDeadlock = false
        this.tipTime = 0

        for (let i = 0; i < this.bottleState.length; i++) {
            if (this.bottleState[i] == 1) {
                this.bottleState[i] = 0
                for (let j = 0; j < 4; j++) {
                    this._bottle[i].data[j][0] = 0
                }
                this._bottle[i].data.complete = 0
                this._bottle[i].data.showBottle = 1
                this._bottle[i].initData()
                this._bottle[i].node.y = -30
                this._bottle[i].node.opacity = 0
                cc.tween(this._bottle[i].node)
                    .to(0.1, { y: 50, opacity: 255 })
                    .to(0.2, { y: 0 })
                    .call(() => {
                        this._bottle[i].openCover()
                        this._bottle[i].appear.getComponent(sp.Skeleton).setCompleteListener(() => {
                            this._bottle[i].appear.active = false
                        })
                    })
                    .start()

                break
            }
        }
        this.addInspect()
    }
    /**检查是否可以加瓶子 */
    addBottleInspect(isInit: boolean = false) {
        let can = false
        for (let i = 0; i < this.bottleState.length; i++) {
            if ((!isInit && this.bottleState[i] == 1) || (isInit && this._bottle[i].data.showBottle == 0 && this.bottleState[i] == 1)) {
                can = true
                break
            }
        }

        return can
    }


    async onBtnAddBottle() {


        if (!GameControl.ints.loadGameOver || GameControl.ints.gameOver) return
        if (!this._clickBtnAddBottle) {
            await ViewControl.ints.showTip('没有空位可增加')
            return
        }
        this.finger.active = false
        this.tipTime = 0
        if (GameControl.ints.useProp) {
            await ViewControl.ints.showTip('正在使用道具，请稍后...')
            return
        }
        if (!GameControl.ints.isUseProp) {
            await ViewControl.ints.showTip('正在操作中，请稍后...')
            return
        }

        this.addBottle()
        return
        let PropNum = StorageConreol.ints.getStorage('propNum')
        if (PropNum[2] > 0) {
            this.addBottle()
            GameControl.ints.gameView.saveData()
            PropNum[2]--
            StorageConreol.ints.setStorage('propNum', PropNum)
            this.setPropNum(PropNum)
        } else {
            return
            let fun = async () => {


                let data = {
                    // pos_type: PosType.POS_TYPE_LEVEL,
                    pos_name: '第' + (GameControl.ints.gameView.data.level + 1) + '关',
                    pos_ext: '主关卡',
                    pos_sub_ext: ZTSDKControl.ints.version,
                    why: '增加瓶子',
                    pos_index: this.data.level + 1,
                }
                ZTSDKControl.ints.onAdRequest(data);

                ADControl.ints.showVideo({
                    successFun: () => {

                        this.addBottle()

                        GameControl.ints.gameView.saveData()
                        ZTSDKControl.ints.onAdFinish(data);
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    failFun: () => {
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    errFun: () => {
                        ViewControl.ints.closeView(Pages.PropView)
                    },
                    closeFun: () => {
                        ZTSDKControl.ints.onAdCancel(data);
                    }
                })
            }

            await ViewControl.ints.openView(Pages.PropView, Storey.ViewUI, { type: 3, fun })
        }





    }

    private _clickBtnAddBottle: boolean = true
    /**添加瓶子检测 */
    addInspect(isInit: boolean = false) {
        // this.btnAddBottle.active = this.data.level != 0
        let result = this.addBottleInspect(isInit)
        this._clickBtnAddBottle = result
        // this.btnAddBottle.getComponent(cc.Button).interactable = result
        let index = 0
        if (GameControl.ints.useSkin == SkinType.WATER) {
            index = 3
        } else if (GameControl.ints.useSkin == SkinType.SCREW) {
            index = 4
        }
        let PropNum = StorageConreol.ints.getStorage('propNum')
        if (result) {
            this.btnAddBottle.getComponent(cc.Sprite).spriteFrame = this.btns1[0]
            this.btnAddBottle.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns1[index]
        } else {
            this.btnAddBottle.getComponent(cc.Sprite).spriteFrame = this.btns2[0]
            this.btnAddBottle.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.btns2[index]
        }

    }

    TOUCH_START() {
        return
        let selectItem = GameControl.ints.selectItem
        if (selectItem && !GuideControl.ints.isGuide) {
            clog.log('落下1')
            cc.Tween.stopAllByTarget(selectItem.node)
            cc.Tween.stopAllByTarget(selectItem.shadow)
            selectItem.clickBottle(2)
            GameControl.ints.selectItem = null
        }

    }


    closeView() {
        super.closeView()
        while (this.mapNode.childrenCount > 0) {
            this._block.put(this.mapNode.children[0])
        }
        while (this.topMap.childrenCount > 0) {
            this._block.put(this.topMap.children[0])
        }

        EventControl.ints.off(EventName.GameWin)
        EventControl.ints.off(EventName.GameFail)
        EventControl.ints.off(EventName.BoxUpdate)
        EventControl.ints.off(EventName.BoxInspect)
        EventControl.ints.off(EventName.UnlockBottle)
        EventControl.ints.off(EventName.OpenGM, this.OpenGM, this)
        ViewControl.ints.closeView(Pages.TipBubble)
        this.node.off(cc.Node.EventType.TOUCH_START, this.TOUCH_START, this)
        this.mapData = null
        this.unschedule(this.setTime)
    }


    async onBtnOpenGM() {
        if (!GameControl.ints.loadGameOver) return
        await ViewControl.ints.openView(Pages.GMView, Storey.TopUI, 2)
    }



}
