
import GameControl, { PropType, SkinType } from "../manage/control/controlData/GameControl";
import StorageConreol from "../manage/control/controlData/StorageConreol";
import MultipleController from "../manage/control/controlNode/MultipleController";
import StateControl from "../manage/control/StateControl";
import ViewControl from "../manage/control/ViewControl";
import { Pages } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";

const { ccclass, property } = cc._decorator;

@ccclass
export default class GetPropView extends ViewRoot {

    @property(cc.Node)
    content: cc.Node = null;

    @property(cc.Node)
    btnOK: cc.Node = null;
    @property(cc.Node)
    iconNode: cc.Node = null;
    @property(cc.Node)
    item: cc.Node = null;


    @property([cc.SpriteFrame])
    icons: cc.SpriteFrame[] = [];

    private _data: { type: number, num: number }[] = []
    private _fun: Function = null

    private PropNum: number[] = null
    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    async showView<T>(data?: T): Promise<void> {
        super.showView()
        this._data = (data as any).data
        this._fun = (data as any).fun


        StateControl.ints.playEffect('首页出现声音')
        this.PropNum = StorageConreol.ints.getStorage('propNum')

        for (let i = 0; i < this._data.length; i++) {
            let node = this.iconNode.children[i]
            if (!node) {
                node = cc.instantiate(this.item)
                node.parent = this.iconNode
            }
            let ligt = node.getChildByName('ligt')
            cc.Tween.stopAllByTarget(ligt)

            cc.tween(ligt)
                .to(3, { angle: 360 })
                .call(() => {
                    ligt.angle = 0
                })
                .union()
                .repeatForever()
                .start()

            node.active = true
            node.getChildByName('num').getComponent(cc.Label).string = '+' + this._data[i].num
            let type = this._data[i].type
            this.PropNum[this._data[i].type] += this._data[i].num

            if (this._data[i].type == PropType.AddBottle) {
                switch (GameControl.ints.useSkin) {
                    case SkinType.WATER:
                        type = 2
                        break
                    case SkinType.SCREW:
                        type = 3
                        break
                }
            }
            node.getChildByName('icon').getComponent(cc.Sprite).spriteFrame = this.icons[type]
        }

        StorageConreol.ints.setStorage('propNum', this.PropNum)

        if (this._data.length < this.iconNode.childrenCount) {
            for (let i = this._data.length; i < this.iconNode.childrenCount; i++) {
                this.iconNode.children[i].active = false
            }
        }
        await MultipleController.ints.eject(this.content)
        this.onBtn(this.btnOK, this.onBtnOK, this)


    }

    closeView(): void {
        super.closeView()
        this._fun && this._fun()
    }

    private isClik: boolean = false
    async onBtnOK() {
        if (this.isClik) {
            ViewControl.ints.showTip('加载中请稍后...')
            return
        }
        this.isClik = true
        GameControl.ints.gameView && GameControl.ints.gameView.setPropNum(this.PropNum)
        ViewControl.ints.closeView(Pages.GetPropView)
        this.isClik = false
    }

    // update (dt) {}
}
