import GameControl from "../manage/control/controlData/GameControl";
import GuideControl from "../manage/control/controlData/GuideControl";
import NodeControl from "../manage/control/controlNode/NodeControl";
import EventControl from "../manage/control/event/EventControl";
import ViewControl from "../manage/control/ViewControl";
import { EventName } from "../manage/enum/EventEnum";
import { Pages } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";

const { ccclass, property } = cc._decorator;

@ccclass
export default class GuideView extends ViewRoot {

    @property(cc.BlockInputEvents)
    intercept: cc.BlockInputEvents = null;

    @property(cc.Node)
    bottleMask: cc.Node = null;

    @property(cc.Node)
    blockMask: cc.Node = null;

    @property(cc.Node)
    finger: cc.Node = null;

    @property(cc.Node)
    tipe: cc.Node = null;

    @property(cc.Label)
    tipeLab: cc.Label = null;



    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    showView<T>(data?: T): void {
        super.showView()
        EventControl.ints.on(EventName.ShowGuide, (_data: { type: number, pos: cc.Vec2, tipePos: cc.Vec2, width: number, height: number, txt: string }) => {

            this.intercept.enabled = _data.pos == null
            this.bottleMask.active = _data.pos != null

            this.finger.children[0].active = _data.pos != null
            this.tipe.active = _data.tipePos != null
            clog.log(_data.pos, _data.tipePos);
            if (_data.tipePos) {
                this.tipe.x = _data.tipePos.x
                this.tipe.y = _data.tipePos.y
            }

            // this.tipe.getPosition(_data.tipePos)

            this.tipeLab.node.active = _data.txt != ''
            this.tipeLab.string = _data.txt
            this.tipeLab.node.parent.getComponent(cc.Sprite).enabled = false
            if (this.bottleMask.active) {
                if (_data.type == 1) {
                    this.bottleMask.getComponent(cc.Mask).enabled = true
                    this.blockMask.getComponent(cc.Mask).enabled = false
                } else if (_data.type == 2) {
                    this.bottleMask.getComponent(cc.Mask).enabled = false
                    this.blockMask.getComponent(cc.Mask).enabled = true
                }
                this.bottleMask.width = _data.width
                this.bottleMask.height = _data.height
                this.blockMask.width = _data.width
                this.blockMask.height = _data.height

                this.bottleMask.setPosition(_data.pos)

                this.finger.setPosition(_data.pos)
            } else {
                this.finger.setPosition(cc.v2(0, 0))
            }

        }, this)

        EventControl.ints.on(EventName.GuideTxt, (data: { pos: cc.Vec2, id: number, txt: string }) => {
            this.intercept.node.once(cc.Node.EventType.TOUCH_END, () => {

                // if (GameControl.ints.gameView.data.level == 0 && GuideControl.ints.guide[1] == 7) {
                //     let pos = NodeControl.ints.nodeConvertLocalPointAR(GameControl.ints.gameView.bottle[2].node.parent, GameControl.ints.gameView.node)
                //     pos.y += 100
                //     let tipePos: cc.Vec2 = cc.v2(pos.x, pos.y + 150)
                //     GuideControl.ints.showGuide({ type: 1, pos, tipePos, width: 100, height: 210, id: 1, txt: '选择一个瓶子' })
                //     return
                // }
                

            })
            this.finger.setPosition(data.pos)

            this.tipe.active = true
            this.tipe.getPosition(data.pos)

            this.tipeLab.node.active = data.txt != ''
            this.tipeLab.node.parent.getComponent(cc.Sprite).enabled = true
            this.tipeLab.string = data.txt
            this.intercept.enabled = true
            this.bottleMask.active = false
            this.finger.children[0].active = false

        }, this)




    }


    closeView(): void {
        super.closeView()
        EventControl.ints.off(EventName.ShowGuide)
        EventControl.ints.off(EventName.GuideTxt)
    }

    // update (dt) {}
}
