import ViewControl from "../manage/control/ViewControl";
import GameControl from "../manage/control/controlData/GameControl";
import StorageConreol from "../manage/control/controlData/StorageConreol";
import { Pages, Storey, bundles } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";
import BundleControl from "../manage/control/controlBunle/BundleControl";
import ConfData from "../manage/conf/ConfData";
import EventControl from "../manage/control/event/EventControl";
import StateControl from "../manage/control/StateControl";
import ADControl, { platformType } from "../adSdk/ADControl";
import GuideControl from "../manage/control/controlData/GuideControl";
import MathUtil from "../manage/utils/MathUtil";
import ZTSDKControl from "../adSdk/ZTSDKControl";
import { ResControl } from "../manage/resUrl/bundles";
import DateControl from "../manage/control/controlData/DateControl";



const { ccclass, property } = cc._decorator;

@ccclass
export default class LoadView extends ViewRoot {


    @property(cc.Sprite)
    jdt_2: cc.Sprite = null;

    @property(cc.Label)
    tipLab: cc.Label = null;





    //预加载页面
    private Prefabs: Pages[] = [Pages.GameView, /*Pages.HomeView, Pages.WinView,*/ Pages.GetGold, Pages.WaitView]
    private loadOver: boolean = false

    private fillRange: boolean = true
    /**需要加载的数量 */
    private loadNum: number = 5
    /**已经加载的数量 */
    private alreadyLoadNum = 0

    private _time: number = 0

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.init()
    }



    private addNum = 0
    async init() {

        if (cc.sys.platform == cc.sys['BYTEDANCE_GAME']) {
            let _data = tt.getLaunchOptionsSync()
            if (_data.scene == '023041') {
                ADControl.ints.isStraight = true

            }
        }
        // ADControl.ints.isStraight = true

        this._time = Date.now()
        ADControl.ints.keyID = window['__keyID'] || 0
        this.schedule(() => {

            let txt = ''

            switch (this.addNum % 4) {
                case 0:
                    txt = ''
                    break
                case 1:
                    txt = '.'
                    break
                case 2:
                    txt = '..'
                    break
                case 3:
                    txt = '...'
                    break
            }
            this.addNum++
            this.tipLab.string = '加载中' + txt
        }, 0.5)

        this.jdt_2 && (this.jdt_2.fillRange = 0)
        // this.loadRemoteConfig()

        if (ADControl.ints.isStraight) {
            DateControl.ints.Delay(1)
            clog.log('延迟了1s')
        }
        this.loadBundle()
        let time = Date.now()
        ///***增加初始化类注意适配抖音直玩 */
        await ADControl.ints.initData()
        console.warn('------------------load over AD time-', Date.now() - time)
        await StorageConreol.ints.intiData()
        console.warn('------------------load over Storage time-', Date.now() - time)
        // this.dataComplete2()


        this.dataComplete()
        this.initControl()


    }

    // private _appName: string = 'tt_mjds'
    // async loadRemoteConfig() {

    //     switch (ADControl.ints.keyID) {
    //         case 1:
    //             this._appName = 'tt_mjds'
    //             break
    //         case 2:
    //             this._appName = 'tt_mjds'
    //             break
    //         case 3:
    //             this._appName = 'tt_mjds'
    //             break
    //     }
    //     let url_ = `https://game-res.tos-cn-beijing.volces.com/other-res/json/spx/${this._appName}/config.json`;
    //     let data = await BundleControl.ints.loadRemote(url_) as cc.JsonAsset
    //     if (data) {
    //         clog.warn('远程配置数据', data)
    //         GameControl.ints.config = data.json
    //         let key = Object.keys(GameControl.ints.config.level_version)
    //         if (key.length == 1) {
    //             this._version = key[0]
    //             this.dataComplete2()
    //         } else {
    //             let random = MathUtil.randomRangeInt(1, 101)
    //             let percent = 0
    //             for (let i = 0; i < key.length; i++) {
    //                 percent += GameControl.ints.config.level_version[key[i]].percent
    //                 if (random <= percent) {
    //                     this._version = key[i]
    //                     this.dataComplete2()
    //                     break
    //                 }
    //             }

    //         }
    //     } else {
    //         this.dataComplete2()
    //     }




    // }

    // async loadRemoteMapData() {

    //     let url_ = `https://game-res.tos-cn-beijing.volces.com/other-res/json/spx/${this._appName}/${this._version}.json`;
    //     let data = await BundleControl.ints.loadRemote(url_) as cc.JsonAsset
    //     if (data) {
    //         let json = data.json

    //     }
    // }




    async loadBundle() {
        let num = 0
        for (let v in bundles) {
            BundleControl.ints.loadSub(bundles[v], () => {
                num++
                if (num == 3) {
                    this.addLoadNum('loadBundle', 1)
                    let fun = async () => {
                        await this.loadPrefabs()
                    }
                    let fun2 = async () => {
                        await this.loadConf()
                    }
                    fun()
                    fun2()
                }
            })
        }



    }
    private async loadConf() {
        let data = await BundleControl.ints.getAsset("conf/map", cc.JsonAsset) as cc.JsonAsset
        ConfData.ints.parseJson(data)
        this.addLoadNum('loadConf', 2)
        this.dataComplete()
    }



    async loadPrefabs() {
        await ViewControl.ints.loadView(this.Prefabs)
        this.addLoadNum('loadPrefabs', 3)
        this.dataComplete()
    }
    ///***增加初始化类注意适配抖音直玩 */
    initControl() {

        StateControl.ints.initData()
        GuideControl.ints.initData()
        this.addLoadNum('initControl', 4)

    }


    private _dataCompleteNum = 0
    ///***增加初始化类注意适配抖音直玩 */
    /**用户数据和 本地地图数据加载完成后执行 */
    async dataComplete() {
        this._dataCompleteNum++
        if (this._dataCompleteNum == 3) {
            await GameControl.ints.initData()

            this.addLoadNum('dataComplete', 5)
        }

    }
    private _dataCompleteNum2 = 0
    private _version: string = ''

    /**用户数据和 远程地图数据加载完成后执行, */
    // async dataComplete2() {
    //     this._dataCompleteNum2++
    //     if (this._dataCompleteNum2 == 2) {
    //         if (this._version != '') {
    //             this.loadRemoteMapData()
    //         }
    //     }
    // }













    addLoadNum(name: string, index: number) {

        this.alreadyLoadNum++
        clog.timeEnd('------------------load over' + this.alreadyLoadNum)
        console.warn('------------------load over time-' + this.alreadyLoadNum, Date.now() - ResControl.ints.time)
        console.log(name)

        let data_ = {
            // pos_type: PosType.POS_TYPE_LEVEL,
            pos_name: '加载界面',
            pos_ext: '主关卡',
            pos_sub_ext: '加载' + name,
            pos_index: 80000 + index,
        }

        ZTSDKControl.ints.onLevelStart(data_);


    }


    // start () {

    // }


    async update(dt) {

        if (this.jdt_2) {
            if (this.alreadyLoadNum < this.loadNum && this.jdt_2.fillRange < this.alreadyLoadNum / this.loadNum) {
                this.jdt_2 && (this.jdt_2.fillRange += 0.01)
            }
        }


        if (this.fillRange && this.alreadyLoadNum == this.loadNum) {
            this.fillRange = false
            this.loadOver = true
            this.jdt_2 && (this.jdt_2.fillRange = 1)

        }
        if (this.loadOver) {
            this.loadOver = false
            clog.log('打开主页');

            StateControl.ints.playBGM('BGM')
            clog.timeEnd('------------------load over')
            console.warn('------------------load over time', Date.now() - ResControl.ints.time)

            let enter = cc.sys.localStorage.getItem('__enter')

            if (ADControl.ints.isStraight) {
                await ViewControl.ints.openView(Pages.StraightView, Storey.TopUI)
                if (!StorageConreol.ints.isNewPlayer) {
                    await ViewControl.ints.openView(Pages.GameView, Storey.ViewUI)
                }
            } else {
                if (enter == 2 || (GameControl.ints.firstGame && (enter == '' || enter == null || enter == undefined))) {
                    await ViewControl.ints.openView(Pages.GameView, Storey.ViewUI)
                } else {
                    await ViewControl.ints.openView(Pages.HomeView, Storey.ViewUI)
                }
            }


            if (cc.sys.platform == cc.sys['BYTEDANCE_GAME']) {
                let _data = tt.getLaunchOptionsSync()
                if (_data.scene == '023041') {
                    let costTime = Date.now() - this._time

                    tt.reportScene({
                        sceneId: 7001,
                        costTime: costTime,
                        success: (res) => {
                            clog.log('自定义数据上报成功', res)
                        },
                        fail: (res) => {
                            clog.log('自定义数据上报失败', res)
                        }
                    })

                }
            }


            clog.timeEnd('------------------load over' + (this.alreadyLoadNum + 1))
            console.warn('------------------load over time-' + (this.alreadyLoadNum + 1), Date.now() - ResControl.ints.time)
            this.node.destroy()
            GameControl.ints.loadOverInte()
        }
    }
}
