

import ADControl from "../adSdk/ADControl";
import GameControl, { SkinType } from "../manage/control/controlData/GameControl";
import MultipleController from "../manage/control/controlNode/MultipleController";
import ViewControl from "../manage/control/ViewControl";
import { Pages } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";

const { ccclass, property } = cc._decorator;

@ccclass
export default class PropView extends ViewRoot {

    @property(cc.Node)
    content: cc.Node = null;
    @property(cc.Node)
    btnClose: cc.Node = null;
    @property(cc.Node)
    btnVideo: cc.Node = null;

    @property(cc.Label)
    title: cc.Label = null;
    @property(cc.Label)
    describe: cc.Label = null;

    @property(cc.Sprite)
    icon: cc.Sprite = null

    @property([cc.SpriteFrame])
    icons: cc.SpriteFrame[] = [];


    _data: any = null
    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        MultipleController.ints.Breathing(this.btnVideo, 1.1, 1, 1, true)
    }

    async showView<T>(data?: T): Promise<void> {
        super.showView()
        this._data = data

        switch (this._data.type) {
            case 1:
                this.title.string = '打乱颜色'
                if (GameControl.ints.useSkin == SkinType.WATER) {
                    this.describe.string = '选择一个瓶子打乱排序'
                } else if (GameControl.ints.useSkin == SkinType.SCREW) {
                    this.describe.string = '选择一串螺丝打乱排序'
                }

                this.icon.spriteFrame = this.icons[0]
                break
            case 2:
                this.title.string = '回退操作'
                this.describe.string = '回退上一步操作'
                this.icon.spriteFrame = this.icons[1]
                break
            case 3:


                let index = 0
                if (GameControl.ints.useSkin == SkinType.WATER) {
                    this.title.string = '增加空瓶'
                    this.describe.string = '空位增加一个空瓶'
                    index = 2
                } else if (GameControl.ints.useSkin == SkinType.SCREW) {
                    this.title.string = '增加螺丝'
                    this.describe.string = '空位增加一个螺丝'
                    index = 3
                }

                this.icon.spriteFrame = this.icons[index]
                break
        }

        await MultipleController.ints.eject(this.content)
        this.onBtn(this.btnClose, this.onBtnClose, this)
        this.onBtn(this.btnVideo, this.onBtnVideo, this)

    }

    closeView(): void {
        super.closeView()
    }

    onBtnClose() {
        if (ADControl.ints.isPlayVideo) {
            ViewControl.ints.showTip('正在播放视频，请稍后...')
            return
        }
        ViewControl.ints.closeView(Pages.PropView)
    }

    onBtnVideo() {
        if (GameControl.ints.gameOver) return
        this._data.fun && this._data.fun()
    }

    // update (dt) {}
}
