import ViewControl from "../manage/control/ViewControl";
import { Pages } from "../manage/enum/Integrate";
import ViewRoot from "../manage/viewRoot/ViewRoot";


const { ccclass, property } = cc._decorator;

@ccclass
export default class TipLab extends ViewRoot {

    @property(cc.Node)
    content: cc.Node = null;

    @property(cc.Node)
    item: cc.Node = null;



    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        this.item.active = false
    }

    showView(data) {
        super.showView()
        if (this.content.childrenCount >= 5) return
        let node = cc.instantiate(this.item)
        node.y = 0
        node.parent = this.content
        node.active = true
        node.opacity = 255
        node.children[0].getComponent(cc.Label).string = data
        cc.tween(node)
            .to(2, { y: 200, opacity: 0 })
            .call(() => {
                node.destroy()
                if (this.content.childrenCount == 2) {
                    ViewControl.ints.closeView(Pages.TipLab)
                }
            })
            .call(() => {
                
            })
            .start()

    }

    closeView() {
        super.closeView()

    }

    // update (dt) {}
}
