import StorageConreol from "../../../script/manage/control/controlData/StorageConreol";
import EventControl from "../../../script/manage/control/event/EventControl";
import { EventName } from "../../../script/manage/enum/EventEnum";
import GameControl from "../../manage/control/controlData/GameControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { Pages, Storey } from "../../manage/enum/Integrate";

const { ccclass, property } = cc._decorator;

@ccclass
export default class itemCommon extends cc.Component {

    @property(cc.Label)
    numLab: cc.Label = null;
    @property(cc.Label)
    energyTimeLab: cc.Label = null;

    @property
    type: number = 0;

    private time: number = 600

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        if (this.type == 2) {
            this.node.active = GameControl.ints.useEnergy
        }

    }

    protected onEnable(): void {
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchEnd, this)

        EventControl.ints.on(EventName.ChangeItemCommon, this.initData, this)
        this.initData()
    }

    initData() {
        let left = ''
        let right = ''
        let value = 0
        if (this.type == 1) {
            value = StorageConreol.ints.getStorage('gold')
        } else if (this.type == 2) {
            value = StorageConreol.ints.getStorage('energy')
        }


        if (this.type == 1) {
            this.numLab.string = left + value + right
        } else if (this.type == 2) {

            // if (value < 5) {
                
            //     let energyTime = StorageConreol.ints.getStorage('energyTime')
            //     if (energyTime == 0) {
            //         energyTime = Date.now()
            //         StorageConreol.ints.setStorage('energyTime', energyTime)
            //     }
            //     this.endTime = energyTime + this.time * 1000
            //     this.addTime()
            //     value = StorageConreol.ints.getStorage('energy')
            //     if (value < 5) {
            //         this.schedule(this.addTime, 1)
            //     }
            // } else {
            //     this.energyTimeLab.string = '已满'
            //     StorageConreol.ints.setStorage('energyTime', 0)
            //     this.unschedule(this.addTime)
            // }
            // this.numLab.string = value +''

        }

    }

    private endTime: number = 0
    addTime() {
        let time = Date.now()


        let endTime = Math.floor((this.endTime - time) / 1000)
        if (endTime <= 0) {
            endTime = 0
            this.unschedule(this.addTime)
            let value = StorageConreol.ints.getStorage('energy')
            StorageConreol.ints.setStorage('energy', value + 1)
            if (value + 1 < 5) {
                StorageConreol.ints.setStorage('energyTime', time)
            }
            this.initData()
            return
        }
        let minute = Math.floor(endTime / 60)
        let second = Math.floor(endTime % 60)
        this.energyTimeLab.string = minute + ':' + (second > 9 ? second : "0" + second)


    }

    protected onDisable(): void {
        this.unschedule(this.addTime)
        this.node.off(cc.Node.EventType.TOUCH_START)
        EventControl.ints.off(EventName.ChangeItemCommon, this.initData, this)
    }




    async touchEnd(event: cc.Event.EventTouch) {
        if (this.type == 1) {
            StateControl.ints.playEffect('click')
            await ViewControl.ints.openView(Pages.ShopView, Storey.ViewUI, { type: 1 })
        }

    }

    // update (dt) {}
}
