import RankControl, { RankType } from "../../manage/control/controlData/RankControl";


const { ccclass, property } = cc._decorator;

@ccclass
export default class itemRank extends cc.Component {

    @property(cc.Label)
    rankLab: cc.Label = null;

    @property(cc.Sprite)
    icon: cc.Sprite = null;
    @property(cc.Label)
    nameLab: cc.Label = null;
    @property(cc.Label)
    scoreLab: cc.Label = null;
    @property(cc.Sprite)
    rankIcom: cc.Sprite = null;
    @property(cc.Node)
    iconDef: cc.Node = null;


    @property([cc.SpriteFrame])
    rankIcoms: cc.SpriteFrame[] = [];

    private _data: RankType = null
    private _index: number = 0
    /**1排行2底部自己 */
    private _type: number = 0

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    setData(data: RankType, index: number, type: number) {
        this._data = data
        this._index = index
        this._type = type
        this.initData()

    }

    initData() {
        let Sprite = this.node.getComponent(cc.Sprite)
        if (Sprite) {
            Sprite.enabled = this._index % 2 == 0
        }
        let ranked = this._data.ranked

        this.rankIcom.node.active = ranked < 4 && ranked > 0
        if (ranked < 4 && ranked > 0) {
            this.rankIcom.spriteFrame = this.rankIcoms[ranked - 1]
        }
        this.iconDef && (this.iconDef.active = false)
        if (this._type == 2 && this._data.avatar == null) {
            this.rankIcom.node.active = false
            this.nameLab.string = this._data.nickName
            this.iconDef && (this.iconDef.active = true)
            this.rankLab.string = '?'
        } else {
            let nameLab = this._data.nickName
            this.nameLab.string = nameLab.substring(0, 5)
            this.icon.spriteFrame = this._data.avatar

            this.rankLab.string = ranked + ''
        }

        if (this._type == 2 && ranked == 0) {
            this.rankLab.string = '?'
        }

        this.scoreLab.string = this._data.score + '分'
    }

    // update (dt) {}
}
