import ADControl from "../../adSdk/ADControl";
import ZTSDKControl from "../../adSdk/ZTSDKControl";
import GameControl from "../../manage/control/controlData/GameControl";
import StorageConreol from "../../manage/control/controlData/StorageConreol";
import EventControl from "../../manage/control/event/EventControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { EventName } from "../../manage/enum/EventEnum";
// import { PosType } from "../../ZTSDK/GaComponent";


const { ccclass, property } = cc._decorator;

@ccclass
export default class itemRes extends cc.Component {


    @property(cc.Node)
    video: cc.Node = null;
    @property(cc.Label)
    btnLab: cc.Label = null;

    @property(cc.Label)
    goldNumLab: cc.Label = null;

    @property(cc.Label)
    valueLab: cc.Label = null;

    @property(cc.Node)
    btnGet: cc.Node = null;


    @property(cc.Sprite)
    icon: cc.Sprite = null;

    @property([cc.SpriteFrame])
    icons: cc.SpriteFrame[] = [];


    private _data: { type: number, value: number }
    private _index: number = 0



    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    protected onEnable(): void {

        this.btnGet.on("click", this.touchEnd, this)



    }

    setData(data: { type: number, value: number }, index: number) {
        this._data = data
        this._index = index
        this.initData()
    }

    initData() {

        this.valueLab.string = this._data.value + ''



        if (this._index == 0) {
            let goldNum = StorageConreol.ints.getStorage('goldNum')
            this.btnGet.getComponent(cc.Button).interactable = goldNum > 0
            this.goldNumLab.string = '(' + goldNum + '/' + 3 + ')'
            this.video.active = goldNum > 0
            if (goldNum > 0) {
                this.btnLab.string = '免费'
                this.goldNumLab.node.active = true
            } else {
                this.goldNumLab.node.active = false
                this.btnLab.string = '明日再来'
            }
        }

        this.icon.spriteFrame = this.icons[this._index]
    }

    protected onDisable(): void {
        this.node.off("click")
    }

    async touchEnd(event: cc.Event.EventTouch) {
        StateControl.ints.playEffect('click')


        let data = {
            // pos_type: PosType.POS_TYPE_MOD,
            pos_name: '获取金币',
            pos_ext: '商店',
            pos_sub_ext: "成功获取免费金币",
            why: '获取金币',
        }
        if (this._index == 0) {
            data = {
                // pos_type: PosType.POS_TYPE_MOD,
                pos_name: '获取金币',
                pos_ext: '商店',
                pos_sub_ext: "成功获取免费金币",
                why: '获取金币',
            }
        }
        ZTSDKControl.ints.onAdRequest(data);
        ADControl.ints.showVideo({
            successFun: async () => {
                if (this._index == 0) {
                    let goldNum = StorageConreol.ints.getStorage('goldNum')
                    goldNum--
                    StorageConreol.ints.setStorage('goldNum', goldNum)
                    EventControl.ints.emit(EventName.ShopGet, { type: this._data.type, data: this.node.children[0], key: 'gold', value: this._data.value })
                    this.initData()
                }
                ZTSDKControl.ints.onAdFinish(data);
            }, closeFun: () => {
                if (this._index == 0) {

                }
                ZTSDKControl.ints.onAdCancel(data);
            }
        })
        // }

    }

    // update (dt) {}
}
