import ADControl from "../../adSdk/ADControl";
import ZTSDKControl from "../../adSdk/ZTSDKControl";
import GameControl from "../../manage/control/controlData/GameControl";
import StorageConreol from "../../manage/control/controlData/StorageConreol";
import EventControl from "../../manage/control/event/EventControl";
import StateControl from "../../manage/control/StateControl";
import ViewControl from "../../manage/control/ViewControl";
import { EventName } from "../../manage/enum/EventEnum";
import { Pages, Storey } from "../../manage/enum/Integrate";
// import { PosType } from "../../ZTSDK/GaComponent";


const { ccclass, property } = cc._decorator;

@ccclass
export default class itemSkin extends cc.Component {

    @property(cc.Label)
    nameLab: cc.Label = null;


    @property(cc.Label)
    valueLab: cc.Label = null;

    @property(cc.Node)
    btnGet: cc.Node = null;

    @property(cc.Label)
    btnLab: cc.Label = null;

    @property(cc.Sprite)
    icon: cc.Sprite = null;

    @property(cc.Node)
    money: cc.Node = null;

    @property([cc.SpriteFrame])
    icons: cc.SpriteFrame[] = [];

    @property([cc.SpriteFrame])
    btns: cc.SpriteFrame[] = [];


    private _data: { type: number, value: number }
    private _index: number = 0

    private skinId: number = 0
    private skins: number[] = []


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    protected onEnable(): void {

        this.btnGet.on("click", this.touchEnd, this)



    }

    setData(data: { type: number, value: number }, index: number) {
        this._data = data
        this._index = index
        this.initData()
    }

    initData() {

        this.valueLab.string = this._data.value + ''

        this.money.active = false
        this.skinId = GameControl.ints.skinZindex[this._index]
        this.skins = StorageConreol.ints.getStorage('skins')
        this.btnLab.node.active = true
        this.btnGet.getComponent(cc.Sprite).spriteFrame = this.btns[0]
        if (this.skins.includes(this.skinId)) {
            this.btnLab.string = '点击使用'
            this.btnLab.node.children[0].active = false
        } else {
            this.btnLab.node.active = false

            this.money.active = true
        }

        if (this.skinId == GameControl.ints.useSkin) {
            this.btnLab.string = ''//已使用
            this.btnGet.getComponent(cc.Sprite).spriteFrame = this.btns[1]
            this.btnLab.node.children[0].active = true
        }
        this.btnGet.getComponent(cc.Button).interactable = this.skinId != GameControl.ints.useSkin



        this.icon.spriteFrame = this.icons[this.skinId]
        this.nameLab.string = GameControl.ints.skinName[this.skinId]

    }

    protected onDisable(): void {
        this.node.off("click")
    }

    async touchEnd(event: cc.Event.EventTouch) {
        StateControl.ints.playEffect('click')
        let Gold = StorageConreol.ints.getStorage('gold')
        if (!this.skins.includes(this.skinId) && this.skinId != GameControl.ints.useSkin) {
            if (Gold >= this._data.value) {
                this.skins.push(this.skinId)
                Gold -= this._data.value
                StorageConreol.ints.setStorage('gold', Gold)
                StorageConreol.ints.setStorage('skins', this.skins)
                EventControl.ints.emit(EventName.ShopGet, { type: this._data.type })
                EventControl.ints.emit(EventName.ChangeItemCommon)


                let data_ = {
                    // pos_type: PosType.POS_TYPE_MOD,
                    pos_name: '获得皮肤',
                    pos_ext: '皮肤',
                    pos_sub_ext: "获得" + GameControl.ints.skinName[this.skinId],
                }
                ZTSDKControl.ints.onModEnter(data_);

                ViewControl.ints.showTip('获得皮肤' + GameControl.ints.skinName[this.skinId])

            } else {
                let goldNum = StorageConreol.ints.getStorage('goldNum')
                if (goldNum > 0) {
                    await ViewControl.ints.openView(Pages.GetGoldView, Storey.ViewUI, this._data.value - Gold)
                } else {
                    ViewControl.ints.showTip('金币不足')
                }
            }
        } else if (this.skins.includes(this.skinId) && this.skinId != GameControl.ints.useSkin) {
            GameControl.ints.useSkin = this.skinId
            StorageConreol.ints.setStorage('useSkin', this.skinId)
            EventControl.ints.emit(EventName.ShopGet, { type: this._data.type })
        }






    }

    // update (dt) {}
}
