import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('bug')
export class bug extends Component {
    onEnable() {
        console.log("onEnable");
        this.node.on(Node.EventType.TOUCH_START, this._touchStart, this);
    }

    onDisable() {
        console.log("onDisable");
        this.node.off(Node.EventType.TOUCH_START, this._touchStart, this);
    }

    private _touchStart() {
        console.log("TouchStart");
    }


}


