import BFSAssembler from "./BFSAssembler";


const { ccclass, menu, disallowMultiple } = cc._decorator;
//@ts-ignore
const RenderFlow = cc.RenderFlow;
@ccclass
@disallowMultiple
@menu("引擎扩展/渲染扩展/BFS渲染 BFSRenderCompon")
export default class BFSRenderCompon extends cc.Component {

    private _vertsDirty: boolean = true;
    private _assembler: BFSAssembler = null;

    private _resetAssembler() {
        //console.warn('_resetAssembler');
        this._assembler = new BFSAssembler();
        this._assembler.init(this);
        //this._updateColor();
        this.setVertsDirty();
    }

    private __preload() {
        this._resetAssembler();
    }

    onEnable() {
        //@ts-ignore
        let renderCompon = this.node._renderComponent;
        if (renderCompon) {
            renderCompon.enabled = false;
        }
        //@ts-ignore
        this.node._renderComponent = this;
        //@ts-ignore
        this.node._renderFlag |= cc.RenderFlow.FLAG_OPACITY_COLOR;

        this.setVertsDirty();
        if (!CC_EDITOR && !CC_NATIVERENDERER) {
            //@ts-ignore
            this.node._renderFlag |= cc.RenderFlow.FLAG_POST_RENDER;
        }
    }

    onDisable() {
        //@ts-ignore
        this.node._renderComponent = null;
        this.disableRender();
    }

    setVertsDirty() {
        this._vertsDirty = true;
        this.markForRender(true);
    }

    markForValidate() {
        RenderFlow.registerValidate(this);
    }

    markForRender(enable) {
        //@ts-ignore
        let flag = RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA;
        if (enable) {
            //@ts-ignore
            this.node._renderFlag |= flag;
            this.markForValidate();
        }
        else {
            //@ts-ignore
            this.node._renderFlag &= ~flag;
        }
    }

    disableRender() {
        //@ts-ignore
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA);
    }

    private _on3DNodeChanged() {
        this._resetAssembler();
    }

    private _updateColor() {

    }

    private _checkBacth(renderer, cullingMask) {

    }

    private _validateRender() {
    }
}