
//@ts-ignore
let gfx = cc.gfx;
var vfmtCustom = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },
    { name: "uv_range", type: gfx.ATTR_TYPE_FLOAT32, num: 4 },
    { name: "position_range", type: gfx.ATTR_TYPE_FLOAT32, num: 4 },
    { name: "texture_pixel", type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
]);

const { ccclass, property, inspector, menu, disallowMultiple, executeInEditMode } = cc._decorator;

@ccclass
@inspector("packages://my-inspector/comp/mylabel.js")
@disallowMultiple
@menu('引擎扩展/组件扩展/MyLabel')
@executeInEditMode
export default class MyLabel extends cc.Label {

    @property({ displayName: "是否启用自定义合图" })
    enableCustomAtlas: boolean = false;

    @property()
    customAtlasName: string = "";

    @property({ displayName: "是否为group合图" })
    isAtlasGroup: boolean = false;

    @property({ tooltip: "在group合图中，每张合图可以使用多少个texture" })
    maxCountInGroup: number = 0;

    private _textureKey: string = null;

    _resetAssembler() {
        //@ts-ignore
        cc.Assembler.init(this);
        //@ts-ignore
        this._setCustomVertsData(this._assembler);
        //@ts-ignore
        this._updateColor();
        //@ts-ignore
        this.setVertsDirty();
    }
    //@ts-ignore
    private _setCustomVertsData(assembler: cc.Assembler2D) {
        //@ts-ignore
        if (!this._assembler["override_vertsData"]) {
            let worldPos = this.node.convertToWorldSpaceAR(cc.v2(0, 0));
            /**求出自己中心点的世界坐标 */
            let centerPos = worldPos.add(cc.v2(this.node.width * (0.5 - this.node.anchorX), this.node.height * (0.5 - this.node.anchorY)));
            let pos_left = centerPos.x - this.node.width / 2;
            let pos_right = centerPos.x + this.node.width / 2;
            let pos_bottom = centerPos.y - this.node.height / 2;
            let pos_top = centerPos.y + this.node.height / 2;
            assembler.floatsPerVert = 15;
            assembler.getVfmt = () => {
                return vfmtCustom;
            }
            assembler.getBuffer = function () {
                //@ts-ignore
                return cc.renderer._handle.getBuffer("mesh", this.getVfmt());
            }

            assembler.uuvs = assembler.updateUVs;
            assembler.updateUVs = function (comp) {
                if (this.cacheMode == cc.Label.CacheMode.CHAR) return;
                assembler.uuvs(comp);
                let uv = [0, 1, 1, 1, 0, 0, 1, 0];
                if (comp && comp._frame)
                    uv = comp._frame.uv;
                let l = uv[0],
                    r = uv[2],
                    b = uv[1],
                    t = uv[5];

                let x_range_min = l,
                    x_range_max = r;

                let y_range_min = t,
                    y_range_max = b;

                let uvOffset = assembler.uvOffset;
                let floatsPerVert = assembler.floatsPerVert;
                let verts = assembler._renderData.vDatas[0];
                let rect = comp._frame._rect;
                let prePixelX = 1 / rect.width;
                let prePixelY = 1 / rect.height;
                for (let i = 0; i < (verts.length * floatsPerVert) / 4; i++) {
                    let dstOffset = floatsPerVert * i + uvOffset;
                    verts[dstOffset + 3] = x_range_min;
                    verts[dstOffset + 4] = y_range_min;
                    verts[dstOffset + 5] = x_range_max;
                    verts[dstOffset + 6] = y_range_max;
                    verts[dstOffset + 7] = pos_left;
                    verts[dstOffset + 8] = pos_bottom;
                    verts[dstOffset + 9] = pos_right;
                    verts[dstOffset + 10] = pos_top;
                    verts[dstOffset + 11] = prePixelX;
                    verts[dstOffset + 12] = prePixelY;
                }
                console.warn(verts);
            }
            assembler.initData();
            //@ts-ignore
            this._assembler["override_vertsData"] = true;
        }
        //@ts-ignore
        this._updateColor();
        //@ts-ignore
        this.setVertsDirty();
    }
}