
//@ts-ignore
let gfx = cc.gfx;
var vfmtCustom = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },
    { name: "uv_range", type: gfx.ATTR_TYPE_FLOAT32, num: 4 },
    { name: "position_range", type: gfx.ATTR_TYPE_FLOAT32, num: 4 },
    { name: "texture_pixel", type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
]);


const { ccclass, menu, disallowMultiple } = cc._decorator;

/*
* Char 缓存模式下，自定义参数没用
*/
@ccclass
@disallowMultiple
@menu('引擎扩展/组件扩展/MySprite')
export default class MySprite extends cc.Sprite {

    _resetAssembler() {
        //@ts-ignore
        cc.Assembler.init(this);
        //@ts-ignore
        this._setCustomVertsData(this._assembler);
        //@ts-ignore
        this._updateColor();
        //@ts-ignore
        this.setVertsDirty();
    }
    //@ts-ignore
    private _setCustomVertsData(assembler: cc.Assembler2D) {
        //@ts-ignore
        if (!this._assembler["override_vertsData"]) {

            assembler.floatsPerVert = 15;
            assembler.getVfmt = () => {
                return vfmtCustom;
            }
            assembler.getBuffer = function () {
                //@ts-ignore
                return cc.renderer._handle.getBuffer("mesh", this.getVfmt());
            }

            if (this.type == cc.Sprite.Type.SLICED) {
                assembler._renderData.createQuadData(0, assembler.verticesFloats, assembler.indicesCount);
                let indices = assembler._renderData.iDatas[0];
                let indexOffset = 0;
                for (let r = 0; r < 3; ++r) {
                    for (let c = 0; c < 3; ++c) {
                        let start = r * 4 + c;
                        indices[indexOffset++] = start;
                        indices[indexOffset++] = start + 1;
                        indices[indexOffset++] = start + 4;
                        indices[indexOffset++] = start + 1;
                        indices[indexOffset++] = start + 5;
                        indices[indexOffset++] = start + 4;
                    }
                }
            } else if (this.type === cc.Sprite.Type.FILLED && this.fillType == cc.Sprite.FillType.RADIAL) {
                assembler._renderData.createFlexData(0, 4, 6, assembler.getVfmt());
                assembler.updateIndices();
            }
            assembler.uuvs = assembler.updateUVs;
            assembler.updateUVs = function (sprite, fillStart, fillEnd) {
                assembler.uuvs(sprite, fillStart, fillEnd);
                if (!sprite || (sprite && !sprite._spriteFrame)) return;
                let uv = sprite._spriteFrame.uv;
                let isRotated = sprite._spriteFrame.isRotated();
                let l = uv[0],
                    r = uv[2],
                    b = uv[1],
                    t = uv[5];

                if (isRotated) {
                    // cc图集里的旋转总是顺时针旋转90度，以原左下角为中心。（旋转后左下角变为左上角）
                    l = uv[1]; r = uv[3];
                    b = uv[0]; t = uv[4];
                }

                let x_range_min = l,
                    x_range_max = r;

                let y_range_min = t,
                    y_range_max = b;

                let uvOffset = assembler.uvOffset;
                let floatsPerVert = assembler.floatsPerVert;
                let verts = assembler._renderData.vDatas[0];
                let worldPos = sprite.node.convertToWorldSpaceAR(cc.v2(0, 0));
                /**求出自己中心点的世界坐标 */
                let centerPos = worldPos.add(cc.v2(sprite.node.width * (0.5 - sprite.node.anchorX), sprite.node.height * (0.5 - sprite.node.anchorY)));
                let pos_left = centerPos.x - sprite.node.width / 2;
                let pos_right = centerPos.x + sprite.node.width / 2;
                let pos_bottom = centerPos.y - sprite.node.height / 2;
                let pos_top = centerPos.y + sprite.node.height / 2;
                let size = sprite.spriteFrame._originalSize;

                for (let i = 0; i < (verts.length * floatsPerVert) / 4; i++) {
                    let dstOffset = floatsPerVert * i + uvOffset;
                    //付值顺序为左上右下, UV渲染是由左至右，上至下
                    if (isRotated) {
                        verts[dstOffset + 3] = y_range_max;
                        verts[dstOffset + 4] = x_range_min;
                        verts[dstOffset + 5] = y_range_min;
                        verts[dstOffset + 6] = x_range_max;
                    } else {
                        verts[dstOffset + 3] = x_range_min;
                        verts[dstOffset + 4] = y_range_min;
                        verts[dstOffset + 5] = x_range_max;
                        verts[dstOffset + 6] = y_range_max;
                    }
                    verts[dstOffset + 7] = pos_left;
                    verts[dstOffset + 8] = pos_bottom;
                    verts[dstOffset + 9] = pos_right;
                    verts[dstOffset + 10] = pos_top;
                    verts[dstOffset + 11] = size.width;
                    verts[dstOffset + 12] = size.height;
                }
                console.warn(verts);
            }
            assembler.initData();
            assembler.initLocal();
            //@ts-ignore
            this._assembler["override_vertsData"] = true;
        }
    }
}