"use strict";
cc._RF.push(module, 'f68f5Ko2eJOYqI5UjZ30gva', 'MyLabel');
// Script/MyLabel.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-ignore
var gfx = cc.gfx;
var vfmtCustom = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },
    { name: "uv_range", type: gfx.ATTR_TYPE_FLOAT32, num: 4 },
    { name: "position_range", type: gfx.ATTR_TYPE_FLOAT32, num: 4 },
    { name: "texture_pixel", type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
]);
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, inspector = _a.inspector, menu = _a.menu, disallowMultiple = _a.disallowMultiple, executeInEditMode = _a.executeInEditMode;
var MyLabel = /** @class */ (function (_super) {
    __extends(MyLabel, _super);
    function MyLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.enableCustomAtlas = false;
        _this.customAtlasName = "";
        _this.isAtlasGroup = false;
        _this.maxCountInGroup = 0;
        _this._textureKey = null;
        return _this;
    }
    MyLabel.prototype._resetAssembler = function () {
        //@ts-ignore
        cc.Assembler.init(this);
        //@ts-ignore
        this._setCustomVertsData(this._assembler);
        //@ts-ignore
        this._updateColor();
        //@ts-ignore
        this.setVertsDirty();
    };
    //@ts-ignore
    MyLabel.prototype._setCustomVertsData = function (assembler) {
        //@ts-ignore
        if (!this._assembler["override_vertsData"]) {
            var worldPos = this.node.convertToWorldSpaceAR(cc.v2(0, 0));
            /**求出自己中心点的世界坐标 */
            var centerPos = worldPos.add(cc.v2(this.node.width * (0.5 - this.node.anchorX), this.node.height * (0.5 - this.node.anchorY)));
            var pos_left_1 = centerPos.x - this.node.width / 2;
            var pos_right_1 = centerPos.x + this.node.width / 2;
            var pos_bottom_1 = centerPos.y - this.node.height / 2;
            var pos_top_1 = centerPos.y + this.node.height / 2;
            assembler.floatsPerVert = 15;
            assembler.getVfmt = function () {
                return vfmtCustom;
            };
            assembler.getBuffer = function () {
                //@ts-ignore
                return cc.renderer._handle.getBuffer("mesh", this.getVfmt());
            };
            assembler.uuvs = assembler.updateUVs;
            assembler.updateUVs = function (comp) {
                if (this.cacheMode == cc.Label.CacheMode.CHAR)
                    return;
                assembler.uuvs(comp);
                var uv = [0, 1, 1, 1, 0, 0, 1, 0];
                if (comp && comp._frame)
                    uv = comp._frame.uv;
                var l = uv[0], r = uv[2], b = uv[1], t = uv[5];
                var x_range_min = l, x_range_max = r;
                var y_range_min = t, y_range_max = b;
                var uvOffset = assembler.uvOffset;
                var floatsPerVert = assembler.floatsPerVert;
                var verts = assembler._renderData.vDatas[0];
                var rect = comp._frame._rect;
                var prePixelX = 1 / rect.width;
                var prePixelY = 1 / rect.height;
                for (var i = 0; i < (verts.length * floatsPerVert) / 4; i++) {
                    var dstOffset = floatsPerVert * i + uvOffset;
                    verts[dstOffset + 3] = x_range_min;
                    verts[dstOffset + 4] = y_range_min;
                    verts[dstOffset + 5] = x_range_max;
                    verts[dstOffset + 6] = y_range_max;
                    verts[dstOffset + 7] = pos_left_1;
                    verts[dstOffset + 8] = pos_bottom_1;
                    verts[dstOffset + 9] = pos_right_1;
                    verts[dstOffset + 10] = pos_top_1;
                    verts[dstOffset + 11] = prePixelX;
                    verts[dstOffset + 12] = prePixelY;
                }
                console.warn(verts);
            };
            assembler.initData();
            //@ts-ignore
            this._assembler["override_vertsData"] = true;
        }
        //@ts-ignore
        this._updateColor();
        //@ts-ignore
        this.setVertsDirty();
    };
    __decorate([
        property({ displayName: "是否启用自定义合图" })
    ], MyLabel.prototype, "enableCustomAtlas", void 0);
    __decorate([
        property()
    ], MyLabel.prototype, "customAtlasName", void 0);
    __decorate([
        property({ displayName: "是否为group合图" })
    ], MyLabel.prototype, "isAtlasGroup", void 0);
    __decorate([
        property({ tooltip: "在group合图中，每张合图可以使用多少个texture" })
    ], MyLabel.prototype, "maxCountInGroup", void 0);
    MyLabel = __decorate([
        ccclass,
        inspector("packages://my-inspector/comp/mylabel.js"),
        disallowMultiple,
        menu('引擎扩展/组件扩展/MyLabel'),
        executeInEditMode
    ], MyLabel);
    return MyLabel;
}(cc.Label));
exports.default = MyLabel;

cc._RF.pop();