
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/BFSAssembler.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '42d9f/z9UtNq5/7XJ211aFE', 'BFSAssembler');
// Script/BFSAssembler.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
//@ts-ignore
var Assembler = cc.Assembler;
//@ts-ignore
//const RenderData = cc.RenderData;
//@ts-ignore
var RenderFlow = cc.RenderFlow;
// RenderFlow遍历过程中，需要防止子节点进入的函数
var RENDER_MASK = RenderFlow.FLAG_RENDER | RenderFlow.FLAG_POST_RENDER;
var PROP_DIRTY_MASK = RenderFlow.FLAG_OPACITY | RenderFlow.FLAG_WORLD_TRANSFORM;
// 通过开关控制仅在拥有该Assembler的根节点开启合批优化
// 用于避免该Assembler被嵌套使用
var BATCH_OPTIMIZE_SWITCH = true;
var BFSAssembler = /** @class */ (function (_super) {
    __extends(BFSAssembler, _super);
    function BFSAssembler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 每个2d渲染单元里的有:
        // 4个顶点属性数据
        // 6个顶点索引 -> 三角剖分成2个三角形
        // 每个顶点属性由5个32位数据组成
        // 顶点属性声明:
        // var vfmtPosUvColor = new gfx.VertexFormat([
        //     { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        //     { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        //     { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },       // 4个uint8
        // ]);
        // 顶点属性数据排列，每一格是32位 (float32/uint32)
        // x|y|u|v|color|x|y|u|v|color|...
        // 其中uv在一组数据中的偏移是2，color的偏移是4
        _this.verticesCount = 4;
        _this.indicesCount = 6;
        _this.floatsPerVert = 5;
        // vdata offset info
        _this.uvOffset = 2;
        _this.colorOffset = 4;
        //@ts-ignore
        _this._renderData = null;
        _this._local = null; // 中间结果。[l,b,r,t]。node对象左下、右上顶点的本地坐标，即相对于锚点的偏移
        return _this;
    }
    BFSAssembler.prototype.init = function (comp) {
        _super.prototype.init.call(this, comp);
        //console.warn("BFSAssembler", "init");
        // cc.Assembler2D的初始化放在constructor里
        // 此处把初始化放在init里，以便成员变量能够有机会修改
        //@ts-ignore
        this._renderData = new cc.RenderData();
        this._renderData.init(this);
        this.initLocal();
        this.initData();
        //console.warn(this._renderData, "init end");
    };
    Object.defineProperty(BFSAssembler.prototype, "verticesFloats", {
        get: function () {
            return this.verticesCount * this.floatsPerVert;
        },
        enumerable: false,
        configurable: true
    });
    BFSAssembler.prototype.initData = function () {
        var data = this._renderData;
        data.createQuadData(0, this.verticesFloats, this.indicesCount);
        // createQuadData内部会调用initQuadIndices初始化索引信息
        // 如果是用用flexbuffer创建则需要自己初始化
    };
    BFSAssembler.prototype.initLocal = function () {
        this._local = [];
        this._local.length = 4;
    };
    BFSAssembler.prototype.updateColor = function (comp, color) {
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的color部分
        var uintVerts = this._renderData.uintVDatas[0];
        if (!uintVerts)
            return;
        color = color != null ? color : comp.node.color._val;
        var floatsPerVert = this.floatsPerVert;
        var colorOffset = this.colorOffset;
        for (var i = colorOffset, l = uintVerts.length; i < l; i += floatsPerVert) {
            uintVerts[i] = color;
        }
    };
    BFSAssembler.prototype.getBuffer = function () {
        //@ts-ignore
        return cc.renderer._handle._meshBuffer;
    };
    BFSAssembler.prototype.updateWorldVerts = function (comp) {
        if (CC_NATIVERENDERER) {
            this.updateWorldVertsNative(comp);
        }
        else {
            this.updateWorldVertsWebGL(comp);
        }
    };
    BFSAssembler.prototype.updateWorldVertsWebGL = function (comp) {
        var local = this._local;
        var verts = this._renderData.vDatas[0];
        var matrix = comp.node._worldMatrix;
        var matrixm = matrix.m, a = matrixm[0], b = matrixm[1], c = matrixm[4], d = matrixm[5], tx = matrixm[12], ty = matrixm[13];
        var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
        /*
        m00 = 1, m01 = 0, m02 = 0, m03 = 0,
        m04 = 0, m05 = 1, m06 = 0, m07 = 0,
        m08 = 0, m09 = 0, m10 = 1, m11 = 0,
        m12 = 0, m13 = 0, m14 = 0, m15 = 1
        */
        // [a,b,c,d] = _worldMatrix[1,2,4,5] == [1,0,0,1]
        // _worldMatrix[12,13]是xy的平移量
        // 即世界矩阵的左上角2x2是单元矩阵，说明在2D场景内没有出现旋转或者缩放
        var justTranslate = a === 1 && b === 0 && c === 0 && d === 1;
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的xy部分
        var index = 0;
        var floatsPerVert = this.floatsPerVert;
        if (justTranslate) {
            // left bottom
            verts[index] = vl + tx;
            verts[index + 1] = vb + ty;
            index += floatsPerVert;
            // right bottom
            verts[index] = vr + tx;
            verts[index + 1] = vb + ty;
            index += floatsPerVert;
            // left top
            verts[index] = vl + tx;
            verts[index + 1] = vt + ty;
            index += floatsPerVert;
            // right top
            verts[index] = vr + tx;
            verts[index + 1] = vt + ty;
        }
        else {
            // 4对xy分别乘以 [2,2]仿射矩阵，然后+平移量
            var al = a * vl, ar = a * vr, bl = b * vl, br = b * vr, cb = c * vb, ct = c * vt, db = d * vb, dt = d * vt;
            // left bottom
            // newx = vl * a + vb * c + tx
            // newy = vl * b + vb * d + ty
            verts[index] = al + cb + tx;
            verts[index + 1] = bl + db + ty;
            index += floatsPerVert;
            // right bottom
            verts[index] = ar + cb + tx;
            verts[index + 1] = br + db + ty;
            index += floatsPerVert;
            // left top
            verts[index] = al + ct + tx;
            verts[index + 1] = bl + dt + ty;
            index += floatsPerVert;
            // right top
            verts[index] = ar + ct + tx;
            verts[index + 1] = br + dt + ty;
        }
    };
    // native场景下使用的updateWorldVerts
    // copy from \jsb-adapter-master\engine\assemblers\assembler-2d.js
    BFSAssembler.prototype.updateWorldVertsNative = function (comp) {
        var local = this._local;
        var verts = this._renderData.vDatas[0];
        var floatsPerVert = this.floatsPerVert;
        var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
        var index = 0;
        // left bottom
        verts[index] = vl;
        verts[index + 1] = vb;
        index += floatsPerVert;
        // right bottom
        verts[index] = vr;
        verts[index + 1] = vb;
        index += floatsPerVert;
        // left top
        verts[index] = vl;
        verts[index + 1] = vt;
        index += floatsPerVert;
        // right top
        verts[index] = vr;
        verts[index + 1] = vt;
    };
    // 将准备好的顶点数据填充进 VertexBuffer 和 IndiceBuffer
    BFSAssembler.prototype.fillBuffers = function (comp, renderer) {
        if (renderer.worldMatDirty) {
            this.updateWorldVerts(comp);
        }
        var renderData = this._renderData;
        var vData = renderData.vDatas[0];
        var iData = renderData.iDatas[0];
        var buffer = this.getBuffer( /*renderer*/);
        var offsetInfo = buffer.request(this.verticesCount, this.indicesCount);
        // buffer data may be realloc, need get reference after request.
        // fill vertices
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        if (vData.length + vertexOffset > vbuf.length) {
            vbuf.set(vData.subarray(0, vbuf.length - vertexOffset), vertexOffset);
        }
        else {
            vbuf.set(vData, vertexOffset);
        }
        // fill indices
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset; // vertexId是已经在buffer里的顶点数，也是当前顶点序号的基数
        for (var i = 0, l = iData.length; i < l; i++) {
            ibuf[indiceOffset++] = vertexId + iData[i];
        }
        if (CC_EDITOR || CC_NATIVERENDERER)
            return;
        if (!BATCH_OPTIMIZE_SWITCH)
            return;
        var layer = [];
        this._layers = [layer];
        // 当前节点是自定义渲染的根节点，worldDirtyFlag属性将被逐层传递
        // 此处的dirtyFlag包含世界坐标变化、透明度变化。（参考render-flow.js的_children函数）
        var worldTransformFlag = renderer.worldMatDirty ? RenderFlow.FLAG_WORLD_TRANSFORM : 0;
        var worldOpacityFlag = renderer.parentOpacityDirty ? RenderFlow.FLAG_OPACITY_COLOR : 0;
        var dirtyFlag = worldTransformFlag | worldOpacityFlag;
        comp.node["__gtDirtyFlag"] = dirtyFlag;
        // BFS过程
        var queue = [];
        queue.push(comp.node);
        var depth = 0;
        var end = 1;
        var iter = 0;
        var gtRenderFlag;
        while (iter < queue.length) {
            var node = queue[iter++];
            dirtyFlag = node["__gtDirtyFlag"];
            for (var _i = 0, _a = node.children; _i < _a.length; _i++) {
                var c = _a[_i];
                if (!c._activeInHierarchy || c._opacity === 0)
                    continue;
                gtRenderFlag = c._renderFlag & RENDER_MASK;
                if (gtRenderFlag > 0) {
                    // 移除子节点的renderFlag，使renderFlow不执行它的RENDER函数
                    c["__gtRenderFlag"] = gtRenderFlag;
                    c._renderFlag &= ~gtRenderFlag;
                    layer.push(c);
                }
                // 逐层传递父节点的dirtyFlag
                c["__gtDirtyFlag"] = dirtyFlag | (c._renderFlag & PROP_DIRTY_MASK);
                queue.push(c);
            }
            if (iter == end) {
                // 完成当前层遍历，开始下一层遍历
                ++depth;
                end = queue.length;
                layer = [];
                this._layers.push(layer);
            }
        }
    };
    BFSAssembler.prototype.postFillBuffers = function (comp, renderer) {
        // 记录worldMatDirty，函数退出时重置回去
        var originWorldMatDirty = renderer.worldMatDirty;
        if (!BATCH_OPTIMIZE_SWITCH || !this._layers)
            return;
        // off优化开关，避免嵌套
        BATCH_OPTIMIZE_SWITCH = false;
        var gtRenderFlag;
        var gtDirtyFlag;
        // 按层级遍历所有子节点
        for (var _i = 0, _a = this._layers; _i < _a.length; _i++) {
            var layer = _a[_i];
            if (layer.length == 0)
                continue;
            for (var _b = 0, layer_1 = layer; _b < layer_1.length; _b++) {
                var c = layer_1[_b];
                gtRenderFlag = c["__gtRenderFlag"];
                gtDirtyFlag = c["__gtDirtyFlag"];
                // 设置worldMatDirty，在引擎默认fillBuffers()中该变量用于判断是否更新世界坐标
                renderer.worldMatDirty = gtDirtyFlag > 0 ? 1 : 0;
                //@ts-ignore
                c._renderFlag |= gtRenderFlag;
                // 调用子节点RenderFlow的剩余部分
                RenderFlow.flows[gtRenderFlag]._func(c);
            }
        }
        this._layers = null;
        BATCH_OPTIMIZE_SWITCH = true;
        renderer.worldMatDirty = originWorldMatDirty;
    };
    BFSAssembler.prototype.updateUVs = function (comp) {
        // 4个顶点的uv坐标，对应左下、右下、左上、右上
        // 如果是cc.Sprite组件，这里取sprite._spriteFrame.uv;
        var uv = [0, 0, 1, 0, 0, 1, 1, 1];
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的uv部分
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    BFSAssembler.prototype.updateVerts = function (comp) {
        var node = comp.node, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l, b, r, t;
        l = -appx;
        b = -appy;
        r = cw - appx;
        t = ch - appy;
        var local = this._local;
        local[0] = l;
        local[1] = b;
        local[2] = r;
        local[3] = t;
        this.updateWorldVerts(comp);
    };
    BFSAssembler.prototype.updateRenderData = function (comp) {
        //@ts-ignore
        if (comp._vertsDirty) {
            this.updateUVs(comp);
            this.updateVerts(comp);
            //@ts-ignore
            comp._vertsDirty = false;
        }
    };
    return BFSAssembler;
}(Assembler));
exports.default = BFSAssembler;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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