"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
/**
 * @zh 如果希望兼容 3.3 之前的版本可以使用下方的代码
 * @en You can add the code below if you want compatibility with versions prior to 3.3
 */
// Editor.Panel.define = Editor.Panel.define || function(options: any) { return options }
module.exports = Editor.Panel.define({
    listeners: {
        show() { console.log('show'); },
        hide() { console.log('hide'); },
    },
    template: (0, fs_extra_1.readFileSync)((0, path_1.join)(__dirname, '../../../static/template/default/index.html'), 'utf-8'),
    style: (0, fs_extra_1.readFileSync)((0, path_1.join)(__dirname, '../../../static/style/default/index.css'), 'utf-8'),
    $: {
        sliceBtn: '#sliceBtn',
        plistBtn: '#plistBtn',
        previewImg: '#previewImg',
        canvas: '#canvas',
        row: '#row',
        column: '#column',
    },
    methods: {},
    ready() {
        let filePath = '';
        let fileName = '';
        let imgNativeWidth = 0;
        let imgNativeHeight = 0;
        let imgElement;
        let canvas = this.$.canvas;
        let ctx = canvas.getContext('2d');
        let row = 1;
        let col = 1;
        // 获得按钮的方法
        this.$.sliceBtn.onclick = (e) => {
            let row = parseInt(this.$.row.value);
            let col = parseInt(this.$.column.value);
            // 1. 获取previewImg中的图片
            let width = imgNativeWidth / col;
            let height = imgNativeHeight / row;
            let rootPath = (0, path_1.join)(filePath, fileName);
            // 创建目录
            (0, fs_extra_1.mkdir)(rootPath, { recursive: true }, (err) => {
                if (err) {
                    console.log(err);
                }
            });
            let totalCount = row * col;
            for (let i = 0; i < row; i++) {
                for (let j = 0; j < col; j++) {
                    // 2. 根据row和col切割图片
                    canvas.width = width;
                    canvas.height = height;
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    ctx.drawImage(imgElement, j * width, i * height, width, height, 0, 0, width, height);
                    let src = canvas.toDataURL();
                    let buffer = Buffer.from(src.split(',')[1], 'base64');
                    let savePath = (0, path_1.join)(rootPath, fileName + '_' + i + '_' + j + '.png');
                    (0, fs_extra_1.writeFile)(savePath, buffer, 'base64', err => {
                        if (err) {
                            console.log(err);
                        }
                        else {
                            totalCount--;
                            if (totalCount === 0) {
                                console.log('success');
                            }
                        }
                    });
                }
            }
            drawImage();
        };
        this.$.plistBtn.onclick = (e) => {
            let row = parseInt(this.$.row.value);
            let col = parseInt(this.$.column.value);
            // let previewImg = this.$.previewImg!;
            // 1. 获取previewImg中的图片
            // let imgElement = previewImg.querySelector('img');
            let plistFileLines = [];
            plistFileLines.push('<?xml version="1.0" encoding="UTF-8"?>');
            plistFileLines.push('<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">');
            plistFileLines.push('<plist version="1.0">');
            plistFileLines.push('    <dict>');
            plistFileLines.push('        <key>frames</key>');
            plistFileLines.push('        <dict>');
            let width = imgElement.naturalWidth / col;
            let height = imgElement.naturalHeight / row;
            for (let i = 0; i < row; i++) {
                for (let j = 0; j < col; j++) {
                    plistFileLines.push('            <key>' + fileName + '_' + i + '_' + j + '.png</key>');
                    plistFileLines.push('            <dict>');
                    plistFileLines.push('                <key>aliases</key>');
                    plistFileLines.push('                <array/>');
                    plistFileLines.push('                <key>spriteOffset</key>');
                    plistFileLines.push('                <string>{0,0}</string>');
                    plistFileLines.push('                <key>textureRotated</key>');
                    plistFileLines.push('                <false/>');
                    plistFileLines.push('                <key>spriteSize</key>');
                    plistFileLines.push('                <string>{' + width + ',' + height + '}</string>');
                    plistFileLines.push('                <key>spriteSourceSize</key>');
                    plistFileLines.push('                <string>{' + width + ',' + height + '}</string>');
                    plistFileLines.push('                <key>textureRect</key>');
                    plistFileLines.push('                <string>{{' + j * width + ',' + i * height + '},{' + width + ',' + height + '}}</string>');
                    plistFileLines.push('            </dict>');
                }
            }
            plistFileLines.push('        </dict>');
            plistFileLines.push('        <key>metadata</key>');
            plistFileLines.push('        <dict>');
            plistFileLines.push('            <key>format</key>');
            plistFileLines.push('            <integer>3</integer>');
            plistFileLines.push('            <key>realTextureFileName</key>');
            plistFileLines.push('            <string>' + fileName + '.png</string>');
            plistFileLines.push('            <key>size</key>');
            plistFileLines.push('            <string>{' + imgElement.naturalWidth + ',' + imgElement.naturalHeight + '}</string>');
            plistFileLines.push('            <key>smartupdate</key>');
            plistFileLines.push('            <string>$TexturePacker:SmartUpdate$</string>');
            plistFileLines.push('        </dict>');
            plistFileLines.push('    </dict>');
            plistFileLines.push('</plist>');
            let fileFullPath = (0, path_1.join)(filePath, fileName + '.plist');
            (0, fs_extra_1.writeFile)(fileFullPath, plistFileLines.join('\n'), (err) => {
                if (err) {
                    console.log(err);
                }
                else {
                    console.log('success');
                }
            });
        };
        let drawImage = () => {
            if (imgElement) {
                let previewImg = this.$.previewImg;
                let previewWidth = previewImg.offsetWidth - 2;
                let previewHeight = previewImg.offsetHeight - 2;
                canvas.width = previewWidth;
                canvas.height = previewHeight;
                // 计算图片缩放比
                let imgRatio = imgNativeWidth / imgNativeHeight;
                let previewRatio = previewWidth / previewHeight;
                if (imgRatio > previewRatio) {
                    imgElement.width = previewWidth;
                    imgElement.height = previewWidth / imgRatio;
                }
                else {
                    imgElement.height = previewHeight;
                    imgElement.width = imgElement.height * imgRatio;
                }
                let imgWidth = imgElement.width;
                let imgHeight = imgElement.height;
                let offsetX = (previewWidth - imgWidth) / 2;
                let offsetY = (previewHeight - imgHeight) / 2;
                ctx.strokeStyle = '#ff0000';
                ctx.lineWidth = 1;
                ctx.clearRect(0, 0, previewWidth, previewHeight);
                ctx.beginPath();
                ctx.drawImage(imgElement, offsetX, offsetY, imgWidth, imgHeight);
                for (let i = 0; i < row + 1; i++) {
                    ctx.moveTo(offsetX, offsetY + i * imgHeight / row);
                    ctx.lineTo(offsetX + imgWidth, offsetY + i * imgHeight / row);
                    ctx.stroke();
                }
                for (let i = 0; i < col + 1; i++) {
                    ctx.moveTo(offsetX + i * imgWidth / col, offsetY + 0);
                    ctx.lineTo(offsetX + i * imgWidth / col, offsetY + imgHeight);
                    ctx.stroke();
                }
            }
        };
        if (this.$.previewImg) {
            let previewImg = this.$.previewImg;
            previewImg.ondragenter = (e) => {
                e.preventDefault();
                e.stopPropagation();
            };
            previewImg.ondragover = (e) => {
                e.preventDefault();
                e.stopPropagation();
            };
            previewImg.ondragleave = (e) => {
            };
            previewImg.ondrop = (e) => {
                e.preventDefault();
                e.stopPropagation();
                let file = e.dataTransfer.files[0];
                let suffix = file.name.substring(file.name.lastIndexOf('.'));
                if (suffix !== '.jpg' && suffix !== '.png') {
                    alert('只支持jpg和png格式的图片');
                    return;
                }
                fileName = file.name.substring(0, file.name.lastIndexOf('.'));
                filePath = file.path;
                filePath = filePath.substring(0, filePath.lastIndexOf('\\') + 1);
                console.log(filePath);
                var reader = new FileReader();
                reader.onload = function (event) {
                    let source = event.target.result;
                    // 对读取的图片进行缩放，不超过previewImg的宽高
                    imgElement = new Image();
                    imgElement.src = source;
                    imgElement.onload = function () {
                        imgNativeWidth = imgElement.width;
                        imgNativeHeight = imgElement.height;
                        drawImage();
                    };
                };
                reader.readAsDataURL(file);
            };
        }
        if (this.$.column) {
            let columnInput = this.$.column;
            columnInput.addEventListener('input', (e) => {
                let columnStr = columnInput.value;
                let rowStr = this.$.row.value;
                row = parseInt(rowStr);
                col = parseInt(columnStr);
                drawImage();
            });
        }
        if (this.$.row) {
            let rowInput = this.$.row;
            rowInput.addEventListener('input', (e) => {
                let columnStr = this.$.column.value;
                let rowStr = rowInput.value;
                row = parseInt(rowStr);
                col = parseInt(columnStr);
                drawImage();
            });
        }
        window.onresize = () => {
            let previewImg = this.$.previewImg;
            let previewWidth = previewImg.offsetWidth - 2;
            let previewHeight = previewImg.offsetHeight - 2;
            canvas.width = previewWidth;
            canvas.height = previewHeight;
            drawImage();
        };
    },
    beforeClose() { },
    close() { }
});
//# sourceMappingURL=data:application/json;base64,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